/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil.archive;

import com.oracle.cie.common.SecureUnmarshaller;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.archive.PatchArchiveXmlException;
import oracle.opatch.opatchutil.archive.jaxb.PatchArchives;

public class PatchArchiveJaxbBinder {
    private static final String xsdSchema = ".patch_archive_mapping.xsd";
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private Schema schema;
    private static volatile PatchArchiveJaxbBinder instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PatchArchiveJaxbBinder getInstance() throws Exception {
        Class<PatchArchiveJaxbBinder> clazz = PatchArchiveJaxbBinder.class;
        synchronized (PatchArchiveJaxbBinder.class) {
            if (instance == null) {
                instance = new PatchArchiveJaxbBinder();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private PatchArchiveJaxbBinder() throws Exception {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PatchArchives.class});
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schema = schemaFactory.newSchema(this.getClass().getResource(xsdSchema));
            this.marshaller = context.createMarshaller();
            this.marshaller.setSchema(this.schema);
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.unmarshaller = context.createUnmarshaller();
            this.unmarshaller.setSchema(this.schema);
        }
        catch (Exception e2) {
            throw new PatchArchiveXmlException("Failed to initialize jaxb context");
        }
    }

    public PatchArchives loadFromXML(Path xmlFile) throws PatchArchiveXmlException {
        PatchArchives patchArchivesObj;
        OLogger.debug(" Loading Patch Info From .patch_archive_mapping.xml");
        if (!(xmlFile != null && Files.exists(xmlFile, new LinkOption[0]) && Files.isRegularFile(xmlFile, new LinkOption[0]) && Files.isReadable(xmlFile))) {
            throw new PatchArchiveXmlException("Can not load Xml from an invalid File.");
        }
        try (InputStream inputStream = Files.newInputStream(xmlFile, new OpenOption[0]);){
            patchArchivesObj = (PatchArchives)SecureUnmarshaller.unmarshal((Unmarshaller)this.unmarshaller, (InputStream)inputStream);
        }
        catch (Exception e2) {
            throw new PatchArchiveXmlException("Can not unmarshal object:" + e2);
        }
        return patchArchivesObj;
    }

    public void saveToXML(PatchArchives patchArchivesObject, Path xmlFile) throws PatchArchiveXmlException {
        OLogger.debug("Marshal to file " + xmlFile);
        if (!(!Files.exists(xmlFile, new LinkOption[0]) || Files.isRegularFile(xmlFile, new LinkOption[0]) && Files.isReadable(xmlFile))) {
            throw new PatchArchiveXmlException("Can not load Xml from an invalid File.");
        }
        try (OutputStream outputStream = Files.newOutputStream(xmlFile, new OpenOption[0]);){
            this.marshaller.marshal((Object)patchArchivesObject, outputStream);
            OLogger.debug("Finish Save .patch_archive_mapping XML.");
        }
        catch (Exception e2) {
            throw new PatchArchiveXmlException("Can not marshal the object:" + e2);
        }
    }
}

