/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchSession;
import oracle.opatch.Rac;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacSrvm;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OUSessionHelper;
import oracle.opatch.opatchutil.UtilEnv;
import oracle.opatch.wrappers.WrapperFactory;

public class MakeSession {
    protected static void runAnyCommand(String oracleHomePath) throws RuntimeException {
        try {
            OLogger.println("Invoking a command on a node.");
            String node = "";
            String[] nodes = OUSessionHelper.readNodes();
            Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
            if (nodes.length == 0) {
                throw new RuntimeException("Not able to get node name.");
            }
            String cmd = "";
            if (!UtilEnv.isCommand()) {
                throw new RuntimeException("Command to be invoked should  be specified using -cmd option.");
            }
            cmd = UtilEnv.getCommand();
            if (cmd == null || cmd.equals("")) {
                throw new IOException("Command to run is empty.");
            }
            StringBuffer failedNodeList = new StringBuffer("");
            boolean isFailed = false;
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                try {
                    rac.srvmRunRemoteCommand(nodes[i2], cmd);
                    continue;
                }
                catch (RuntimeException e2) {
                    failedNodeList.append(nodes[i2] + "\n ");
                    failedNodeList.append(e2.getMessage() + "\n");
                    isFailed = true;
                }
            }
            if (isFailed) {
                throw new RuntimeException("RunAnyCommand Failed on nodes:\n" + failedNodeList.toString());
            }
        }
        catch (IOException e3) {
            RuntimeException re = new RuntimeException(e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        catch (ExitOPatchException e4) {
            return;
        }
        catch (RuntimeException e5) {
            throw e5;
        }
    }

    protected static void runLocalMake(String oracleHomePath) throws RuntimeException {
        OLogger.debug(new StringBuffer("MakeSession::runLocalMake()"));
        try {
            OLogger.println("This option will invoke make commands on the local node.");
            String cookedPatchID = OUSessionHelper.readTimeStampedPatchID(oracleHomePath);
            String makeFile = OPatchEnv.getManualMakeFile(oracleHomePath, cookedPatchID);
            if (makeFile == null || makeFile.isEmpty()) {
                throw new RuntimeException("Null make file.  No commands are invoked.");
            }
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(makeFile, new String[0]);
            if (!Files.exists(f2, new LinkOption[0])) {
                StringBuffer buff = new StringBuffer("Make file ");
                buff.append("(");
                buff.append(makeFile);
                buff.append(") does not exist.");
                throw new RuntimeException(buff.toString());
            }
            OLogger.println("Invoking listed make commands in \"" + makeFile + "\" on local node...");
            try {
                OPatchSession.runMake(oracleHomePath, cookedPatchID);
            }
            catch (Error e2) {
                RuntimeException ioe = new RuntimeException(e2.getMessage());
                ioe.setStackTrace(e2.getStackTrace());
                throw ioe;
            }
        }
        catch (IOException e3) {
            RuntimeException re = new RuntimeException(e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        catch (RuntimeException e4) {
            throw e4;
        }
    }

    protected static void runRemoteMake(String oracleHomePath) throws RuntimeException {
        OLogger.debug(new StringBuffer("MakeSession::runRemoteMake()"));
        try {
            OLogger.println("This option will invoke remote make commands on a given set of nodes.");
            String[] nodes = OUSessionHelper.readNodes();
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            if (nodes == null || nodes.length == 0) {
                StringBuffer buff = new StringBuffer("There are no nodes to update.  ");
                buff.append("Remote nodes have not been modified.");
                throw new RuntimeException(buff.toString());
            }
            String racLoc = OUSessionHelper.readRacLocation(oracleHomePath);
            String mpFile = RacFileCreator.getMPFinalName();
            StringBuffer listedFileHolder = new StringBuffer(racLoc);
            listedFileHolder.append(File.separator);
            listedFileHolder.append(mpFile);
            String finalFile = RacFileCreator.getInstantiatedFile(listedFileHolder.toString());
            OLogger.println("Invoking listed make commands in \"" + listedFileHolder.toString() + "\" on remote nodes...");
            racSrvm.runMakeCmdOnNodes(oracleHomePath, nodes, listedFileHolder.toString(), "opatch", finalFile);
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (ExitOPatchException e3) {
            return;
        }
    }
}

