/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchlogger;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import oracle.opatch.wrappers.WrapperFactory;

public class CmdLinePrintStream
extends PrintStream {
    PrintStream console_out;
    PrintStream console_error;
    PrintWriter log_stream;

    public CmdLinePrintStream(PrintStream primary, PrintStream error, String fileLoc) throws IOException {
        super(primary);
        this.console_out = primary;
        this.console_error = error;
        this.log_stream = new PrintWriter(Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(fileLoc, new String[0]), new OpenOption[0]), true);
    }

    @Override
    public void flush() {
        if (this.console_out != null) {
            this.console_out.flush();
        }
        if (this.log_stream != null) {
            this.log_stream.flush();
        }
    }

    @Override
    public void close() {
        if (this.console_out != null) {
            this.console_out.close();
        }
        if (this.log_stream != null) {
            this.log_stream.close();
        }
    }

    @Override
    public boolean checkError() {
        boolean ce1 = false;
        boolean ce2 = false;
        if (this.console_out != null) {
            ce1 = this.console_out.checkError();
        }
        if (this.log_stream != null) {
            ce2 = this.log_stream.checkError();
        }
        return ce1 || ce2;
    }

    @Override
    public void write(int b2) {
        if (this.console_out != null) {
            this.console_out.write(b2);
        }
        if (this.log_stream != null) {
            this.log_stream.write(b2);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (this.console_out != null) {
            this.console_out.write(buf, off, len);
        }
        if (this.log_stream != null) {
            this.log_stream.write(new String(buf, off, len));
        }
    }

    public void writeSecondary(String str) {
        if (this.log_stream != null) {
            this.log_stream.write(str);
        }
    }

    public void printlnPrimary(String s) {
        if (this.console_out != null) {
            this.console_out.println(s);
        }
    }

    public void printPrimary(String s) {
        if (this.console_out != null) {
            this.console_out.print(s);
        }
        this.flush();
    }

    public void printlnPrimary(Object s) {
        if (this.console_out != null) {
            this.console_out.println(s);
        }
    }

    public void printlnError(String s) {
        if (this.console_error != null) {
            this.console_error.println(s);
        } else {
            this.printlnPrimary(s);
        }
    }

    public void printlnError(Object s) {
        if (this.console_error != null) {
            this.console_error.println(s);
        } else {
            this.printlnPrimary(s);
        }
    }

    @Override
    public void println() {
        if (this.console_out != null) {
            this.console_out.println();
        }
        this.writeSecondary("\n");
        this.flush();
    }

    @Override
    public void println(boolean x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    @Override
    public void println(char x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    @Override
    public void println(int x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    @Override
    public void println(long x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    @Override
    public void println(float x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    @Override
    public void println(double x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    @Override
    public void println(char[] x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    @Override
    public void println(String x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    @Override
    public void println(Object x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    public void setConsoleOut(PrintStream ps) {
        this.console_out = ps;
    }

    public void setConsoleErr(PrintStream ps) {
        this.console_error = ps;
    }
}

