/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchsdk.OPatchFAStep;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OPatchSOAStep
extends OPatchStepAdapter {
    static String host = "";
    static int port = -1;
    static String user = "";
    static String serverURL = "";
    static String t3URL = "";
    static boolean overwrite = true;
    String updateType = "";
    String sarFile = "";
    String jarFile = "";
    String logFile = "";
    String compositeName = "";
    String revision = "";
    String r1SarFile = "";
    String r2SarFile = "";
    String r1modJarFile = "";
    String resultJarfile = "";
    String configPlan = "";
    private OPatchFAStep faStep = null;

    protected OPatchSOAStep(OPatchFAStep faStep) {
        super(faStep);
        this.faStep = faStep;
    }

    public static void init(String host, int port, String user, String url) {
        OPatchSOAStep.host = host;
        OPatchSOAStep.port = port;
        OPatchSOAStep.user = user;
        serverURL = url;
        t3URL = url.replace("http", "t3");
    }

    public String getWLSTCommand() {
        StringBuffer buff = new StringBuffer();
        try {
            InputStream is = this.getClass().getResourceAsStream("WLSTCommandForSOAStep.xml");
            if (is == null) {
                buff = new StringBuffer("Cannot load file \"");
                buff.append("WLSTCommandForSOAStep.xml");
                buff.append("\".");
                throw new Exception(buff.toString());
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            NodeList stepList = doc.getElementsByTagName("step");
            for (int i2 = 0; i2 < stepList.getLength(); ++i2) {
                Node step = stepList.item(i2);
                NamedNodeMap stepAttr = step.getAttributes();
                String stepName = stepAttr.getNamedItem("name").getNodeValue();
                if (!stepName.equals(this.faStep.name())) continue;
                String commandName = stepAttr.getNamedItem("wlstcommand").getNodeValue();
                buff = new StringBuffer(commandName + "(");
                NodeList args = step.getChildNodes();
                for (int j2 = 0; j2 < args.getLength(); ++j2) {
                    String argTagName = args.item(j2).getNodeName();
                    if (!argTagName.equals("arg")) continue;
                    NamedNodeMap argAttr = args.item(j2).getAttributes();
                    String argName = argAttr.getNamedItem("name").getNodeValue();
                    Node prefixNode = argAttr.getNamedItem("prefix");
                    if (prefixNode != null) {
                        String prefix = prefixNode.getNodeValue();
                        buff.append(prefix);
                        buff.append("=");
                        if (!prefix.equals("overwrite")) {
                            buff.append("'");
                        }
                        buff.append(this.getClass().getDeclaredField(argName).get(this));
                        if (!prefix.equals("overwrite")) {
                            buff.append("'");
                        }
                    } else {
                        buff.append("'" + this.getClass().getDeclaredField(argName).get(this) + "'");
                    }
                    if (j2 == args.getLength() - 2) continue;
                    buff.append(",");
                }
                buff.append(")");
                break;
            }
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            Logger.loge(re);
            throw re;
        }
        return buff.toString();
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public void setSarFile(String sarFile) {
        this.sarFile = sarFile;
    }

    public void setJarFile(String jarFile) {
        this.jarFile = jarFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setCompositeName(String compositeName) {
        this.compositeName = compositeName;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setConfigPlan(String configPlan) {
        this.configPlan = configPlan;
    }

    public void setR1SarFile(String r1SarFile) {
        this.r1SarFile = r1SarFile;
    }

    public void setR2SarFile(String r2SarFile) {
        this.r2SarFile = r2SarFile;
    }

    public void setR1modJarFile(String r1modJarFile) {
        this.r1modJarFile = r1modJarFile;
    }

    public void setResultJarfile(String resultJarfile) {
        this.resultJarfile = resultJarfile;
    }

    @Override
    public String toString() {
        String wlstCommand = this.getWLSTCommand();
        StringBuffer buff = new StringBuffer("[ Step: ");
        buff.append(this.faStep.name());
        buff.append(", Description: ");
        buff.append(this.getStepDescription());
        buff.append(", WLST Command: ");
        buff.append(wlstCommand);
        buff.append(", Operation Status: ");
        buff.append(this.isSuccess());
        if (!this.isSuccess()) {
            buff.append(", Error Message: ");
            buff.append(this.getErrorMessage());
            buff.append(", Exception Info: ");
            buff.append(this.getExceptionObject().getStackTrace());
        }
        buff.append("]");
        return buff.toString();
    }
}

