/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import oracle.opatch.OPatchException;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.JMXConnection;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.NodeManagerClient;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.Util;
import oracle.opatch.opatchfafmw.rb.RB;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.NodeManagerMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerStartMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.edit.EditServiceMBean;
import weblogic.management.mbeanservers.edit.EditTimedOutException;
import weblogic.management.mbeanservers.edit.NotEditorException;
import weblogic.management.mbeanservers.edit.ValidationException;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;

public final class Domain {
    private final String protocol;
    private final String host;
    private final String username;
    private final String password;
    private final int port;
    private String nmUsername;
    private String nmPassword;
    private DomainRuntimeServiceMBean drs;
    private DomainRuntimeMBean drt;
    private DomainMBean dc;
    private String adminServerName;
    private String domainName;
    private String domainHome;
    private SOACompositeManager scm;
    private NodeManagerClient nmc;
    private WebLogicDeploymentManager wdm;
    private boolean connected;

    Domain(String protocol, String host, int port, String username, String password) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    void setNMCredential(String nmUsername, String nmPassword) {
        this.nmUsername = nmUsername;
        this.nmPassword = nmPassword;
    }

    void setupJMXConnection() {
        this.drs = JMXConnection.getDomainRuntimeService(this.protocol, this.host, this.port, this.username, this.password);
        this.drt = this.drs.getDomainRuntime();
        this.dc = this.drs.getDomainConfiguration();
        this.connected(true);
    }

    String getAdminServerName() {
        if (this.adminServerName == null) {
            this.adminServerName = this.dc.getAdminServerName();
        }
        return this.adminServerName;
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    String getProtocol() {
        return this.protocol;
    }

    String getAdminServerState() {
        this.adminServerName = this.dc.getAdminServerName();
        ServerLifeCycleRuntimeMBean adminBean = this.getServerLifeCycleRuntimeMBean(this.adminServerName);
        return adminBean.getState();
    }

    String getDomainName() {
        if (this.domainName == null) {
            this.domainName = this.dc.getName();
        }
        return this.domainName;
    }

    String getDomainHome() {
        if (this.domainHome == null) {
            this.domainHome = this.dc.getRootDirectory();
        }
        return this.domainHome;
    }

    String getDomainDirectoryForServerInstance(String domain, String server) throws Exception {
        String serverDomainRootDir;
        try {
            MBeanServerConnection mbs = JMXConnection.getJMXConnection();
            ObjectName serverDomain = new ObjectName("com.bea:Name=" + domain + ",Location=" + server + ",Type=Domain");
            serverDomainRootDir = (String)mbs.getAttribute(serverDomain, "RootDirectory");
        }
        catch (Exception e2) {
            throw e2;
        }
        catch (Throwable t) {
            Exception e3 = new Exception(t.getMessage());
            e3.setStackTrace(t.getStackTrace());
            throw e3;
        }
        return serverDomainRootDir;
    }

    public static ObjectName[] getServerMBeans(MBeanServerConnection mbs) throws Exception {
        ObjectName drs1 = new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME);
        ObjectName domainconfig = (ObjectName)mbs.getAttribute(drs1, "DomainConfiguration");
        ObjectName[] servers = (ObjectName[])mbs.getAttribute(domainconfig, "Servers");
        return servers;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setServerConfigAttribute(String server, String attribute, String attrValue, String objType, boolean errorOnPrevEdit) throws Exception {
        JMXConnector jc = null;
        JMXConnector editJc = null;
        Object on = null;
        MBeanServerConnection mbs = null;
        Object value = null;
        try {
            Integer waitTimeToEdit = new Integer(60000);
            Integer timeOut = new Integer(120000);
            Long longTimeOut = new Long(120000L);
            jc = JMXConnection.getConnector(this.protocol, this.host, this.port, this.username, this.password, "weblogic.management.mbeanservers.domainruntime");
            mbs = JMXConnection.getConnection(jc);
            ObjectName[] servers = Domain.getServerMBeans(mbs);
            boolean serverFound = false;
            String dName = this.getDomainName();
            for (int i2 = 0; i2 < servers.length; ++i2) {
                String name = (String)mbs.getAttribute(servers[i2], "Name");
                if (!name.equals(server)) continue;
                serverFound = true;
                editJc = JMXConnection.getConnector(this.protocol, this.host, this.port, this.username, this.password, "weblogic.management.mbeanservers.edit");
                ObjectName es = new ObjectName(EditServiceMBean.OBJECT_NAME);
                MBeanServerConnection mbs1 = JMXConnection.getConnection(editJc);
                ObjectName cfgMgr = (ObjectName)mbs1.getAttribute(es, "ConfigurationManager");
                if (!errorOnPrevEdit) {
                    mbs1.invoke(cfgMgr, "cancelEdit", null, null);
                }
                boolean myEdit = false;
                String msg = "";
                String serverDomain = "[server=" + server + ",domain=" + dName + "]";
                try {
                    ObjectName domainConfigRoot = (ObjectName)mbs1.invoke(cfgMgr, "startEdit", new Object[]{waitTimeToEdit, timeOut}, new String[]{"java.lang.Integer", "java.lang.Integer"});
                    myEdit = true;
                    ObjectName serverConfig = (ObjectName)mbs1.invoke(domainConfigRoot, "lookupServer", new Object[]{server}, new String[]{"java.lang.String"});
                    Class<?> c2 = Class.forName(objType);
                    Class<?> paramType = Class.forName("java.lang.String");
                    Constructor<?> con = c2.getConstructor(paramType);
                    Object o2 = con.newInstance(attrValue);
                    mbs1.setAttribute(serverConfig, new Attribute(attribute, o2));
                    mbs1.invoke(cfgMgr, "save", null, null);
                    ObjectName task = (ObjectName)mbs1.invoke(cfgMgr, "activate", new Object[]{longTimeOut}, new String[]{"java.lang.Long"});
                    break;
                }
                catch (MBeanException e2) {
                    Exception excep = e2.getTargetException();
                    if (excep instanceof EditTimedOutException) {
                        msg = "OPatch encountered 'edit timeout' exception while trying to set the attribute \"" + attribute + "\" value " + serverDomain + ".";
                    } else if (excep instanceof ValidationException) {
                        msg = "OPatch encountered 'validation' error while trying to save changes for \"" + attribute + "\" value " + serverDomain + ".";
                    } else if (excep instanceof NotEditorException) {
                        msg = "OPatch was not able to open 'edit mode' for \"" + attribute + "\" value " + serverDomain + ".";
                    }
                    Exception ex = new Exception(msg);
                    ex.setStackTrace(excep.getStackTrace());
                    throw ex;
                }
                catch (AttributeNotFoundException e3) {
                    msg = "OPatch was not able to find an attribute by name \"" + attribute + "\" " + serverDomain + ".";
                    Exception ex = new Exception(msg);
                    ex.setStackTrace(e3.getStackTrace());
                    throw ex;
                }
                catch (NoSuchMethodException e4) {
                    msg = "OPatch was not able to set attribute value \"" + attrValue + "\" for the attribute \"" + attribute + "\" " + serverDomain + ". Please check if value conforms " + "to the type \"" + objType + "\"";
                    Exception ex = new Exception(msg);
                    ex.setStackTrace(e4.getStackTrace());
                    throw ex;
                }
                finally {
                    if (myEdit) {
                        mbs1.invoke(cfgMgr, "cancelEdit", null, null);
                    }
                }
            }
            if (!serverFound) {
                throw new Exception("Server name \"" + server + "\" does not match with any servers of the domain \"" + dName + "\".");
            }
        }
        catch (Exception e5) {
            try {
                throw e5;
                catch (Throwable t) {
                    Exception e6 = new Exception(t.getMessage());
                    e6.setStackTrace(t.getStackTrace());
                    throw e6;
                }
            }
            catch (Throwable throwable) {
                JMXConnection.closeConnector(jc);
                JMXConnection.closeConnector(editJc);
                throw throwable;
            }
        }
        JMXConnection.closeConnector(jc);
        JMXConnection.closeConnector(editJc);
    }

    public Object getServerConfigAttribute(String server, String attribute) throws Exception {
        JMXConnector jc = null;
        Object on = null;
        MBeanServerConnection mbs = null;
        Object value = null;
        try {
            jc = JMXConnection.getConnector(this.protocol, this.host, this.port, this.username, this.password, "weblogic.management.mbeanservers.domainruntime");
            mbs = JMXConnection.getConnection(jc);
            ObjectName[] servers = Domain.getServerMBeans(mbs);
            String dName = this.getDomainName();
            boolean serverFound = false;
            String msg = "";
            String serverDomain = "[server=" + server + ",domain=" + dName + "]";
            for (int i2 = 0; i2 < servers.length; ++i2) {
                String name = (String)mbs.getAttribute(servers[i2], "Name");
                if (!name.equals(server)) continue;
                serverFound = true;
                try {
                    value = mbs.getAttribute(servers[i2], attribute);
                    break;
                }
                catch (AttributeNotFoundException e2) {
                    msg = "OPatch was not able to find an attribute by name \"" + attribute + "\" " + serverDomain + ".";
                    Exception ex = new Exception(msg);
                    ex.setStackTrace(e2.getStackTrace());
                    throw ex;
                }
            }
            if (!serverFound) {
                throw new Exception("Server name \"" + server + "\" does not match with any servers of the domain \"" + dName + "\".");
            }
        }
        catch (Exception e3) {
            try {
                throw e3;
            }
            catch (Throwable throwable) {
                JMXConnection.closeConnector(jc);
                throw throwable;
            }
        }
        JMXConnection.closeConnector(jc);
        return value;
    }

    ServerLifeCycleRuntimeMBean getServerLifeCycleRuntimeMBean(String name) {
        return this.drt.lookupServerLifeCycleRuntime(name);
    }

    AppDeploymentMBean getAppDeploymentMBean(String name) {
        AppDeploymentMBean adm = this.dc.lookupAppDeployment(name);
        if (adm == null) {
            adm = this.dc.lookupLibrary(name);
        }
        return adm;
    }

    ServerMBean[] getServers(String t, FMWContext.Type type) {
        switch (type) {
            case SERVER: {
                ServerMBean server = this.dc.lookupServer(t);
                if (server == null) break;
                return new ServerMBean[]{server};
            }
            case CLUSTER: {
                ClusterMBean cluster = this.dc.lookupCluster(t);
                if (cluster == null) break;
                return cluster.getServers();
            }
            case CONTAINER: {
                TargetMBean[] targets;
                AppDeploymentMBean adm = this.getAppDeploymentMBean(t);
                if (adm == null || (targets = adm.getTargets()) == null || targets.length <= 0) break;
                ArrayList<ServerMBean> list = new ArrayList<ServerMBean>(targets.length);
                for (TargetMBean target : targets) {
                    if ("Server".equals(target.getType())) {
                        list.add(this.dc.lookupServer(target.getName()));
                        continue;
                    }
                    ServerMBean[] members = this.dc.lookupCluster(target.getName()).getServers();
                    if (members == null || members.length <= 0) continue;
                    list.addAll(Arrays.asList(members));
                }
                return list.toArray(new ServerMBean[0]);
            }
        }
        return null;
    }

    public SOACompositeManager getSOACompositeManager() {
        if (this.scm == null) {
            ServerMBean[] servers = this.getServers("soa-infra", FMWContext.Type.CONTAINER);
            if (servers == null || servers.length == 0) {
                return null;
            }
            String host = null;
            int port = -1;
            String name = null;
            boolean foundAnyServer = false;
            for (ServerMBean server : servers) {
                String serverURL;
                ServerLifeCycleRuntimeMBean serverLC = this.getServerLifeCycleRuntimeMBean(server.getName());
                if (!server.isListenPortEnabled() || !"RUNNING".equals(serverLC.getState()) || ((serverURL = serverLC.getIPv4URL("t3")) == null || serverURL.equals("")) && ((serverURL = serverLC.getIPv6URL("t3")) == null || serverURL.equals(""))) continue;
                try {
                    StringTokenizer urlArr = new StringTokenizer(serverURL, ":");
                    urlArr.nextToken();
                    host = urlArr.nextToken().substring(2);
                    port = Integer.parseInt(urlArr.nextToken());
                }
                catch (Throwable t) {
                    Logger.logi("Not able to get SOA Server details due to tokenizer/parsing exceptions. Trying another server...");
                    Logger.loge(new RuntimeException(t));
                    continue;
                }
                Logger.logi("SOA Server identified with 'RUNNING' state and listen port enabled  --> Protocol:t3 host:" + host + " port:" + port);
                foundAnyServer = true;
                if (!this.isLocalHost(host)) continue;
                name = server.getName();
                break;
            }
            if (!foundAnyServer) {
                Logger.error(RB.Entry.SOA_SERVER_NOT_FOUND, new Object[0]);
            }
            if ("".equals(host = Util.norm(host))) {
                Logger.error(RB.Entry.SOA_SERVER_HOST_NOT_SPECIFIED, Util.norm(name));
            }
            if (port <= 0) {
                Logger.error(RB.Entry.SOA_SERVER_PORT_NOT_SPECIFIED, Util.norm(name));
            }
            Logger.logi("SOA Server identified for current request  --> Protocol:t3 host:" + host + " port:" + port);
            this.scm = new SOACompositeManager(host, port, this.username, this.password);
            return this.scm;
        }
        return this.scm;
    }

    private boolean isLocalHost(String host) {
        try {
            if (host == null || host.equals("")) {
                Logger.debug("Since host is empty, OPatch till take this as 'local host'.");
                return true;
            }
            InetAddress local = InetAddress.getLocalHost();
            if (Logger.debug) {
                Logger.debug("Local Host Name [" + local.getHostName() + "] IP [" + local.getHostAddress() + "]");
            }
            InetAddress other = InetAddress.getByName(host);
            if (Logger.debug) {
                Logger.debug("Server Host Name [" + other.getHostName() + "] IP [" + other.getHostAddress() + "]");
            }
            return local.equals(other);
        }
        catch (Exception e2) {
            Logger.loge(e2);
            return false;
        }
    }

    boolean isAssociatedWithCurrentOH(String commonHomeGUID, String s) {
        ServerMBean server = this.dc.lookupServer(s);
        if (server.isListenPortEnabled()) {
            String homeGUID;
            if (this.isLocalHost(server.getListenAddress())) {
                return true;
            }
            if (!"".equals(commonHomeGUID) && commonHomeGUID.equals(homeGUID = JMXConnection.getHomeGUID("t3", server.getListenAddress(), server.getListenPort(), this.username, this.password))) {
                return true;
            }
        }
        return false;
    }

    void checkNMCredential() {
        this.nmUsername = Util.norm(this.nmUsername);
        if ("".equals(this.nmUsername)) {
            OPatchStateManagerFactory.getInstance().setErrorCode(127);
            Logger.error(RB.Entry.NODE_MANAGER_USERNAME_NOT_SPECIFIED, new Object[0]);
        }
        this.nmPassword = Util.norm(this.nmPassword);
        if ("".equals(this.nmPassword)) {
            OPatchStateManagerFactory.getInstance().setErrorCode(128);
            Logger.error(RB.Entry.NODE_MANAGER_PASSWORD_NOT_SPECIFIED, new Object[0]);
        }
    }

    boolean connectedToNM(String s) throws OPatchException {
        NodeManagerClient nmc = this.getNMClient(s);
        if (nmc == null) {
            return false;
        }
        String state = nmc.getState();
        Logger.logi("Node Manager State of Server [" + s + "] [" + state + "]");
        if (state == null) {
            OPatchException e2 = new OPatchException();
            if (nmc.excep != null) {
                e2 = new OPatchException(nmc.excep.getMessage());
                e2.setStackTrace(nmc.excep.getStackTrace());
            }
            throw e2;
        }
        if (s.equals(this.getAdminServerName())) {
            this.nmc = nmc;
        } else {
            nmc.done();
        }
        return true;
    }

    private NodeManagerClient getNMClient(String s) throws OPatchException {
        String type;
        StringBuffer buff = new StringBuffer();
        ServerMBean server = this.dc.lookupServer(s);
        MachineMBean machine = server.getMachine();
        if (machine == null) {
            buff = new StringBuffer("Machine not configured for server [" + s + "]");
            Logger.loge(buff.toString());
            throw new OPatchException(buff.toString());
        }
        NodeManagerMBean nm = machine.getNodeManager();
        if (nm == null) {
            buff = new StringBuffer("Node Manager not configured for server [" + s + "]");
            Logger.loge(buff.toString());
            throw new OPatchException(buff.toString());
        }
        Properties p2 = null;
        if (s.equals(this.getAdminServerName())) {
            Properties sup;
            ServerStartMBean ss = server.getServerStart();
            Properties bp = ss.getBootProperties();
            if (bp != null) {
                p2 = bp;
            }
            if ((sup = ss.getStartupProperties()) != null) {
                if (p2 == null) {
                    p2 = sup;
                } else {
                    p2.putAll((Map<?, ?>)sup);
                }
            }
        }
        if ((type = nm.getNMType()) == null || "SSL".equalsIgnoreCase(type)) {
            this.setTrustKeyStore(server);
        }
        return new NodeManagerClient(nm, this.getDomainName(), "", this.nmUsername, this.nmPassword, s, p2);
    }

    private void setTrustKeyStore(ServerMBean server) {
        int i2;
        String keyStores = Util.norm(server.getKeyStores());
        if (Logger.debug) {
            Logger.debug("KeyStores for Server [" + server.getName() + "] [" + keyStores + "]");
        }
        if ((i2 = keyStores.indexOf("And")) > 0) {
            String trustKeyStore = keyStores.substring(i2 + 3);
            if (Logger.debug) {
                Logger.debug("TrustKeyStore for Server [" + server.getName() + "] [" + trustKeyStore + "]");
            }
            if (trustKeyStore != null) {
                System.setProperty("weblogic.security.TrustKeyStore", trustKeyStore);
            }
            if ("CustomTrust".equals(trustKeyStore)) {
                String file;
                String type = server.getCustomTrustKeyStoreType();
                if (type != null) {
                    System.setProperty("weblogic.security.CustomTrustKeyStoreType", server.getCustomTrustKeyStoreType());
                }
                if ((file = server.getCustomTrustKeyStoreFileName()) != null) {
                    System.setProperty("weblogic.security.CustomTrustKeyStoreFileName", server.getCustomTrustKeyStoreFileName());
                }
            }
        }
    }

    NodeManagerClient getNMClient() {
        return this.nmc;
    }

    WebLogicDeploymentManager getWebLogicDeploymentManager() {
        if (this.wdm == null) {
            try {
                if (Logger.debug) {
                    Logger.debug("Getting new DeploymentManager.");
                }
                this.wdm = SessionHelper.getRemoteDeploymentManager((String)this.protocol, (String)this.host, (String)("" + this.port), (String)this.username, (String)this.password);
                if (Logger.debug) {
                    Logger.debug("Got DeploymentManager.");
                }
            }
            catch (Exception e2) {
                OPatchStateManagerFactory.getInstance().setErrorCode(130);
                Logger.error(RB.Entry.ERROR_IN_GETTING_DM, new Object[0]);
            }
        }
        return this.wdm;
    }

    void connected(boolean connected) {
        this.connected = connected;
    }

    boolean connected() {
        return this.connected;
    }
}

