/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import oracle.integration.platform.blocks.deploy.patch.PatchStatus;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchSOAStep;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.Util;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.wrappers.WrapperFactory;

final class CheckSOACompositeDeploy
implements Operation {
    CheckSOACompositeDeploy() {
    }

    @Override
    public void run(FMWContext c2) {
        SOACompositeManager scm = null;
        String list = "";
        OPatchStepAdapter prereqStep = null;
        try {
            scm = c2.getDomain().getSOACompositeManager();
            list = Util.norm(scm.listDeployedComposites());
        }
        catch (Throwable t) {
            prereqStep = new OPatchStepAdapter(OPatchFAStep.GET_LIST_OF_SOA_COMPOSITES);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Try to get list of deployed SOA Composites");
            String errorMsg = "OPatch was not able to get the list of deployed SOA Composites.";
            if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            prereqStep.setErrorMessage(errorMsg);
            RuntimeException re = new RuntimeException(t);
            prereqStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            throw re;
        }
        String errorMsg = "";
        String compositeDN = "";
        String newCompositeDN = "";
        String defaultRevision = "";
        if (Logger.debug) {
            Logger.debug("Details of deployed SOA Composites\n" + list);
        }
        SOAComposite sc = c2.getSOAComposite();
        String name = sc.getName();
        String path = sc.getPath();
        String revision = sc.getRevision();
        try {
            if (!scm.isBaseCompositeDeployed(name)) {
                throw new RuntimeException("No Base composite is deployed for the composite \"" + name + "\"");
            }
            Logger.logi("Base composite for composite with name \"" + name + "\" is found");
        }
        catch (Throwable t) {
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_BASE_COMPOSITE_CONFIGURED);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check if Base composite is configured");
            errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
            if (errorMsg != null) {
                prereqStep.setErrorMessage(t.getMessage());
            }
            RuntimeException re = new RuntimeException(t);
            prereqStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            throw re;
        }
        try {
            defaultRevision = Util.norm(scm.getDefaultRevision(name));
        }
        catch (Throwable t) {
            prereqStep = new OPatchStepAdapter(OPatchFAStep.SOA_GET_DEFAULT_REVISION);
            prereqStep.setSuccess(false);
            errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
            prereqStep.setStepDescription("Get the default revision of the composite");
            RuntimeException re = new RuntimeException(t);
            if (errorMsg != null) {
                prereqStep.setErrorMessage(errorMsg);
            }
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            prereqStep.setExceptionObject(re);
            throw re;
        }
        if ("".equals(defaultRevision) || list.indexOf(name + "[" + defaultRevision + "]") == -1) {
            Logger.warn(RB.Entry.DEPLOY_SOA_COMPOSITES_NOT_CONFIGURED, name);
            c2.clearSOAComposite();
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_BASE_COMPOSITE_CONFIGURED);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check if base SOA Composite is configured");
            prereqStep.setErrorMessage("SOA Composite is not configured. Composite will not be redeployed during deployment operation.");
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            return;
        }
        compositeDN = "default/" + name + "!" + revision;
        try {
            Logger.logi("Check if the input revision of the composite is not deployed [" + compositeDN + "]");
            if (scm.isDeployed(compositeDN)) {
                throw new RuntimeException("The composite \"" + name + "\" with revision \"" + revision + "\" is already deployed. Current Operation cannot be performed.");
            }
            Logger.logi("Input revision of the composite is not deployed");
        }
        catch (Throwable t) {
            OPatchStepAdapter isDeployedStep = new OPatchStepAdapter(OPatchFAStep.CHECK_COMPOSITE_DEPLOYED);
            isDeployedStep.setStepDescription("Find if the composite revision is not deployed");
            isDeployedStep.setSuccess(false);
            errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
            if (errorMsg != null) {
                isDeployedStep.setErrorMessage(errorMsg);
            }
            RuntimeException re = new RuntimeException(t);
            isDeployedStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(isDeployedStep);
            throw re;
        }
        if (c2.getSOAComposite() != null && c2.getTempLocation() == null) {
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_TEMP_LOCATION);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check if temp location is accessible");
            prereqStep.setErrorMessage("Temp location not specified or doesn't have the read/write permissions");
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            Logger.error(RB.Entry.TEMP_LOCATION_NOT_AVAILABLE, new Object[0]);
        }
        if (!Util.existFile(path)) {
            errorMsg = Logger.getString(RB.Entry.SOA_COMPOSITE_NOT_EXIST, path, name);
            Logger.loge(errorMsg);
            RuntimeException re = new RuntimeException(errorMsg);
            throw re;
        }
        try {
            String tempLocation = Util.getTempLocation(c2.getTempLocation(), name);
            Logger.logi("Temporary Location used to store jars generated in SOA Composite Prerequisite checks -> [" + tempLocation + "]");
            String s = tempLocation + System.getProperty("file.separator") + "sca_" + name + "_rev" + defaultRevision + "-";
            String composite = s + "composite.jar";
            String customization = s + "customization.jar";
            String property = s + "property.jar";
            String runtime = s + "runtime.jar";
            String plan = s + "configplan.xml";
            String log = s + "mergelog.xml";
            String result = s + "result.jar";
            Util.deleteFile(composite);
            Util.deleteFile(customization);
            Util.deleteFile(property);
            Util.deleteFile(runtime);
            Util.deleteFile(plan);
            Util.deleteFile(log);
            Util.deleteFile(result);
            Logger.logi("Path where the jar is taken is -> " + path);
            String jarName = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]).getFileName().toString();
            String jarWithPlan = c2.getTempLocation() + System.getProperty("file.separator") + jarName;
            Util.deleteFile(jarWithPlan);
            if (!Util.copyFile(path, jarWithPlan)) {
                errorMsg = "OPatch was not able to copy the 'jar with plan' to temporary scratch area";
                Logger.loge(errorMsg);
                RuntimeException re1 = new RuntimeException(errorMsg);
                throw re1;
            }
            OPatchSOAStep singleDeployStep = new OPatchSOAStep(OPatchFAStep.SOA_SINGLE_DEPLOY);
            singleDeployStep.setSarFile(jarWithPlan);
            boolean noneConfigPlan = c2.isNoneConfigPlan();
            if (noneConfigPlan) {
                Logger.logi("CheckSOACompositeDeploy OPatch uses configplan=\"none\" for composite deployment");
            } else {
                Logger.logi("CheckSOACompositeDeploy OPatch uses config plan from base composite for deployment");
            }
            boolean report = OPatchEnv.isReport();
            if (!report) {
                singleDeployStep.setStepDescription("  CheckSOACompositeDeploy composite deployment with single coarse api");
                PatchStatus status = scm.prereqSingleDeploy(jarWithPlan, noneConfigPlan);
                c2.getContextBuilder().setSOAOpResult(status);
                Logger.logi("Summary of the execution Steps:");
                Logger.logi(status.getStepInfoSummary());
                if (status.getState() == PatchStatus.PATCH_STATE.patchSuccess || status.getState() == PatchStatus.PATCH_STATE.validateSuccess) {
                    Logger.logi("CheckSOACompositeDeploy succeeded.");
                    singleDeployStep.setSuccess(true);
                } else {
                    Logger.logi("CheckSOACompositeDeploy failed");
                    singleDeployStep.setSuccess(false);
                    singleDeployStep.setErrorMessage("CheckSOACompositeDeploy Composite validation failed. " + status.getStepInfoSummary());
                    c2.getContextBuilder().setFailedPrereqStep(singleDeployStep);
                }
            } else {
                singleDeployStep.setStepDescription("[skip] CheckSOACompositeDeploy  composite deployment with single coarse api");
                singleDeployStep.setSuccess(true);
            }
            c2.getContextBuilder().addExecutionStep(singleDeployStep);
        }
        catch (Exception e2) {
            Logger.loge(e2);
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
    }
}

