/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class CheckCompositeLifecycle
implements Operation {
    CheckCompositeLifecycle() {
    }

    @Override
    public void run(FMWContext c2) {
        String name = "";
        String revision = "";
        String compositeDN = "";
        RuntimeException re = null;
        Domain d2 = c2.getDomain();
        try {
            if (!d2.connected()) {
                Logger.logi("Set up JMX Connectivity");
                d2.setupJMXConnection();
            }
        }
        catch (Throwable t) {
            String errorMsg = "";
            errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
            OPatchStepAdapter jmxconStep = new OPatchStepAdapter(OPatchFAStep.SETUP_JMX_CONNECTION);
            jmxconStep.setStepDescription("Set up JMX Connectivity");
            jmxconStep.setSuccess(false);
            jmxconStep.setErrorMessage(errorMsg);
            re = new RuntimeException(t);
            jmxconStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(jmxconStep);
            Logger.loge(re);
            throw re;
        }
        SOAComposite sc = c2.getSOAComposite();
        SOACompositeManager scm = d2.getSOACompositeManager();
        name = sc.getName();
        revision = sc.getRevision();
        if (revision == null || revision.length() < 1) {
            try {
                Logger.logi("Get the default revision of the composite since the input revision is empty.");
                revision = scm.getDefaultRevision(name);
            }
            catch (Throwable t) {
                String errorMsg = "";
                errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
                OPatchStepAdapter getdefaultRevStep = new OPatchStepAdapter(OPatchFAStep.SOA_FIND_CORRECT_REVISION);
                getdefaultRevStep.setStepDescription("Trying to get the default revision since the input revision is empty.");
                getdefaultRevStep.setSuccess(false);
                if (errorMsg != null) {
                    getdefaultRevStep.setErrorMessage(errorMsg);
                }
                re = new RuntimeException(t);
                getdefaultRevStep.setExceptionObject(re);
                c2.getContextBuilder().setFailedPrereqStep(getdefaultRevStep);
                Logger.loge(re);
                throw re;
            }
        }
        compositeDN = "default/" + name + "!" + revision;
        try {
            Logger.logi("Check if the input revision of the composite is already deployed [" + compositeDN + "]");
            if (!scm.isDeployed(compositeDN)) {
                throw new RuntimeException("The composite \"" + name + "\" with revision \"" + revision + "\" is not deployed. Current Operation cannot be performed.");
            }
            Logger.logi("Input revision of the composite is already deployed");
        }
        catch (Throwable t) {
            String errorMsg = "";
            errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
            OPatchStepAdapter isDeployedStep = new OPatchStepAdapter(OPatchFAStep.CHECK_COMPOSITE_DEPLOYED);
            isDeployedStep.setStepDescription("Find if the composite revision is deployed");
            isDeployedStep.setSuccess(false);
            if (errorMsg != null) {
                isDeployedStep.setErrorMessage(errorMsg);
            }
            re = new RuntimeException(t);
            isDeployedStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(isDeployedStep);
            Logger.loge(re);
            throw re;
        }
        try {
            Logger.logi("Check if the input revision of the composite is active [" + compositeDN + "]");
            if (!scm.isActive(compositeDN)) {
                throw new RuntimeException("The composite \"" + name + "\" with revision \"" + revision + "\" is not in active state. Current Operation cannot be performed.");
            }
            Logger.logi("Input revision of the composite is in active state");
        }
        catch (Throwable t) {
            String errorMsg = "";
            errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
            OPatchStepAdapter isActiveStep = new OPatchStepAdapter(OPatchFAStep.CHECK_COMPOSITE_ACTIVE);
            isActiveStep.setStepDescription("Find if the composite revision is active");
            isActiveStep.setSuccess(false);
            if (errorMsg != null) {
                isActiveStep.setErrorMessage(errorMsg);
            }
            re = new RuntimeException(t);
            isActiveStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(isActiveStep);
            Logger.loge(re);
            throw re;
        }
    }
}

