/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import oracle.opatch.InitReadMeAction;
import oracle.opatch.InitScriptAction;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.Rules;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NapplyProcessHelper;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OPatchUtilHelper;

public class RunInit {
    private NApplyData data;

    public RunInit(NApplyData data) {
        this.data = data;
    }

    public void runInit(String oracleHomePath, NApplyData data) {
        OneOffEntry[] patchesToApply = data.getPatchesToApply();
        try {
            int i2;
            PatchObject[] filteredPatchObjects = OPatchUtilHelper.getPatchesToApply(oracleHomePath, patchesToApply, "NApply");
            String[] filteredPatchLocs = OPatchUtilHelper.getPatchLocs(filteredPatchObjects);
            ArrayList<InitReadMeAction> initReadMes = new ArrayList<InitReadMeAction>();
            ArrayList<NapplyProcessHelper.InitScriptBuff> initScripts = new ArrayList<NapplyProcessHelper.InitScriptBuff>();
            for (i2 = 0; i2 < filteredPatchObjects.length; ++i2) {
                PatchObject po = filteredPatchObjects[i2];
                String id = po.getPatchID();
                StringBuffer dBuff = new StringBuffer("N-Apply: save list all Init ");
                dBuff.append("for patch ").append(id);
                OLogger.debug(dBuff);
                InitReadMeAction initRead = po.getInitReadMeAction();
                InitScriptAction initScript = po.getInitScriptAction();
                try {
                    if (initRead != null && !initRead.isNoOp()) {
                        InitReadMeAction i1 = (InitReadMeAction)initRead.clone();
                        initReadMes.add(i1);
                    }
                    if (initScript == null || initScript.isNoOp()) continue;
                    InitScriptAction i22 = (InitScriptAction)initScript.clone();
                    NapplyProcessHelper.InitScriptBuff initBuff = new NapplyProcessHelper.InitScriptBuff(i22, id);
                    initScripts.add(initBuff);
                    continue;
                }
                catch (CloneNotSupportedException e2) {
                    StringBuffer buff = new StringBuffer("NApply not able to clone Init Actions: ");
                    buff.append(e2.getMessage());
                    throw new RuntimeException(buff.toString());
                }
            }
            for (i2 = 0; i2 < initReadMes.size(); ++i2) {
                InitReadMeAction readme = (InitReadMeAction)initReadMes.get(i2);
                readme.process();
            }
            StringBuffer dBuff = new StringBuffer("N-Apply: run all Init-scripts of apply");
            OLogger.debug(dBuff);
            for (int i3 = 0; i3 < initScripts.size(); ++i3) {
                NapplyProcessHelper.InitScriptBuff initBuff = (NapplyProcessHelper.InitScriptBuff)initScripts.get(i3);
                InitScriptAction script = initBuff.a;
                String patchID = initBuff.patchID;
                String arg = OPatchSessionHelper.getInitScriptActionArgument(patchID);
                dBuff = new StringBuffer(" Invoke init-script of patch ");
                dBuff.append(patchID).append(" with argument \"");
                dBuff.append(arg).append("\" and ").append("apply");
                OLogger.debug(dBuff);
                int initReturnVal = script.process(arg, "apply", patchID);
                if (initReturnVal == 0) continue;
                String initMsg = OLogger.getString("OUI-67133", new Object[]{"INIT", Integer.toString(initReturnVal)});
                OLogger.warn("OUI-67133", new Object[]{"INIT", Integer.toString(initReturnVal)});
                if (Rules.shouldContinueInCaseOfPrePostError("")) continue;
                RuntimeException initRe = new RuntimeException(initMsg);
                throw initRe;
            }
        }
        catch (Exception e3) {
            RuntimeException re = new RuntimeException(e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
    }
}

