/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.opatch.InitScriptAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PostScriptAction;
import oracle.opatch.PreScriptAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OUSession;

public class NapplyProcessHelper {
    protected static void processPrereqNotExecuted(Vector detail) throws RuntimeException {
        int i2;
        StringBuffer buff = new StringBuffer("OPatchUtilHelper::processPrereqNotExecuted()");
        OLogger.debug(buff);
        if (detail == null && detail.size() == 0) {
            buff = new StringBuffer("Pre-req. API not executed but no detail is available.");
            OLogger.log(OLogger.SEVERE, buff.toString());
            throw new RuntimeException(buff.toString());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (i2 = 0; i2 < detail.size(); ++i2) {
            Object obj = detail.get(i2);
            if (obj instanceof Exception) {
                Exception e2 = (Exception)obj;
                buff = new StringBuffer("An exception occured when calling Pre-req. API. Detail: ");
                buff.append(e2.getMessage());
                OLogger.log(OLogger.SEVERE, buff.toString());
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            if (!(obj instanceof String)) continue;
            String s = (String)obj;
            list.add(s);
        }
        buff = new StringBuffer("Pre-req. API didn't execute.  Detail: ");
        for (i2 = 0; i2 < list.size(); ++i2) {
            String s = (String)list.get(i2);
            buff.append(s);
            buff.append(", ");
        }
        OLogger.log(OLogger.SEVERE, buff.toString());
        throw new RuntimeException(buff.toString());
    }

    protected static void checkEmptyPatchList(OneOffEntry[] patchesToApply) {
        if (patchesToApply == null || patchesToApply.length == 0) {
            StringBuffer buff = new StringBuffer(OLogger.getString("OUI-67306", new Object[]{"NApply", "apply"}));
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
    }

    protected static String getNApplyCmdToRunAgain(String[] list) {
        String patchLoc = OUSession.getPatchBaseDir();
        StringBuffer tryAgainCmd = new StringBuffer("<ORACLE_HOME>/OPatch/opatch napply ");
        tryAgainCmd.append(patchLoc);
        tryAgainCmd.append(" -id ");
        for (int i2 = 0; i2 < list.length; ++i2) {
            String id = list[i2];
            if (i2 != 0) {
                tryAgainCmd.append(",");
            }
            tryAgainCmd.append(id);
        }
        String orgCmd = OPatchEnv.getOriginalCommand();
        StringTokenizer tk = new StringTokenizer(orgCmd);
        int i3 = 1;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (i3 > 2) {
                if (token.equals("-id")) {
                    tk.nextToken();
                } else {
                    tryAgainCmd.append(" ").append(token);
                }
            }
            ++i3;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("Conflict with patches in OracleHome detected. Please run OPatch again as\n");
        buff.append(tryAgainCmd.toString());
        buff.append("\n\nIf the command is too long, please paste the patch id list in a file and");
        buff.append("\ninvoke with 'idfile' option. Please refer 'opatch napply -help' for ");
        buff.append("\n'idfile' option.");
        return buff.toString();
    }

    public static class InitScriptBuff {
        InitScriptAction a;
        String patchID;

        InitScriptBuff(InitScriptAction a2, String patchID) {
            this.a = a2;
            this.patchID = patchID;
        }
    }

    public static class PostScriptBuff {
        PostScriptAction a;
        String patchID;

        PostScriptBuff(PostScriptAction a2, String patchID) {
            this.a = a2;
            this.patchID = patchID;
        }
    }

    public static class PreScriptBuff {
        PreScriptAction a;
        String patchID;

        PreScriptBuff(PreScriptAction a2, String patchID) {
            this.a = a2;
            this.patchID = patchID;
        }
    }
}

