/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.SessionMode;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.HomeOperationsException;
import oracle.glcm.opatch.common.api.install.HomeOperationsExt;
import oracle.glcm.opatch.common.api.install.PatchInfo;
import oracle.opatch.JarActionEntity;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchException;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.Rules;
import oracle.opatch.cup.CUPFileHandler;
import oracle.opatch.ipm.HomeInventoryHelper;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.IPMReadServices;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.ipm.OHILock;
import oracle.opatch.ipm.RawInventory;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixLanguage;

class IPMRWServices
extends IPMReadServices
implements IIPMRWServices {
    private static IPMRWServices instance = null;
    OiiiInstallOneoffInvEntry entry = null;
    boolean needsLockBack = false;
    String saveOHForLockBack = null;

    private IPMRWServices() {
    }

    protected static synchronized IPMRWServices getInstance() {
        if (instance == null) {
            instance = new IPMRWServices();
        }
        return instance;
    }

    @Override
    public void lock(String oracleHomePath) throws RuntimeException {
        if (lock != null && lock.isWriterLock()) {
            OLogger.debug(new StringBuffer("IPMReadServices::init() IIPMRWServices has been already initialized"));
        } else {
            if (lock != null) {
                OLogger.debug(new StringBuffer("IPMReadServices::init() releasing RO lock to create RW lock "));
                lock.release();
            }
            try {
                try {
                    this.verifyPatchStorageDirectory(oracleHomePath);
                }
                catch (Throwable t) {
                    String msg = OLogger.getString("OUI-68060", new Object[]{oracleHomePath});
                    OLogger.println(msg);
                    throw t;
                }
                lock = OHILock.lock(oracleHomePath, false);
                if (RawInventory.isInstallInventoryExist()) {
                    rawInventory = RawInventory.getInstance(lock.getOracleHomePath(), lock.getCurrentOUISession(), true);
                    if (cookedInventory != null) {
                        cookedInventory.reload(rawInventory);
                    }
                }
            }
            catch (Throwable e2) {
                OLogger.debug(new StringBuffer("Unable to acquire OHI RW Lock: "));
                RuntimeException re = new RuntimeException(e2.getMessage(), e2);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
    }

    @Override
    public void verify(List<OneOffEntry> list) throws OPatchException {
    }

    private void addPatchCUP(PatchObject patchObject) throws HomeOperationsException {
        StringBuffer buff = new StringBuffer("IPMRWServices::addPatchCUP(PatchObject patchObject)");
        PatchInfo patchInfoObj = this.createPatchInfoObj(patchObject, false);
        HomeOperationsExt homeOp = this.getHomeOperations();
        OLogger.debug(buff.toString() + " : adding installed patch " + patchObject.getPatchID() + " to inventory...");
        if (!homeOp.getVersionInfo().isNextGen()) {
            IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
            if (rwServices.isLocked()) {
                this.needsLockBack = true;
                this.saveOHForLockBack = rwServices.getOracleHomePath();
                rwServices.release();
            }
            homeOp.initialize(SessionMode.WRITE);
        }
        homeOp.addPatchToInventory(patchInfoObj);
        OLogger.debug(buff.toString() + " : Done adding installed patch " + patchObject.getPatchID() + " to inventory...");
    }

    @Override
    public void add(PatchObject patchObject) throws HomeOperationsException, RuntimeException, NullPointerException, Exception {
        if (OPatchEnv.isCUPSupported() && !OPatchEnv.isSnowBall()) {
            this.addPatchCUP(patchObject);
        } else {
            StringBuffer buff = new StringBuffer("IPMRWServices::add()");
            if (patchObject == null) {
                buff = new StringBuffer("IPMRWServices::add() gets ");
                buff.append(" null PatchObject");
                OLogger.debug(buff);
                throw new NullPointerException(buff.toString());
            }
            if (!RawInventory.isInstallInventoryExist()) {
                buff = new StringBuffer("IPMRWServices::add()");
                buff.append(" gets null installInventory");
                OLogger.debug(buff);
                throw new NullPointerException(buff.toString());
            }
            InstalledComponent[] installedComponents = this.getInstalledComponents();
            if (installedComponents == null) {
                buff = new StringBuffer("IPMRWServices::add()");
                buff.append(" gets null InstallComponent[]");
                OLogger.debug(buff);
                throw new NullPointerException(buff.toString());
            }
            String oracleHomeName = null;
            int oracleHomeIndex = -1;
            try {
                oracleHomeName = this.getOracleHomeName();
                oracleHomeIndex = this.getIndex();
            }
            catch (Throwable t) {
                // empty catch block
            }
            String patchID = patchObject.getOriginalPatchID();
            Vector bugsToFix = patchObject.getBugsToFixVector();
            boolean isRollBackable = patchObject.isRollBackable();
            String uniquePatchID = patchObject.getPatchInventory().getPSENumber();
            String patchDescription = patchObject.getPatchInventory().getPatchDescription();
            Vector langs = new Vector();
            Vector<OiiiInstallOneoffInvEntry> subsetPatches = new Vector<OiiiInstallOneoffInvEntry>();
            String language = patchObject.getPatchInventory().getPatchLanguage();
            if (patchObject.getPatchType().equals("snowball")) {
                langs = OiixLanguage.strToVect((String)language);
            }
            this.getRawInventory();
            Vector installedOneOffList = RawInventory.getAllOneoffInvEntries();
            for (Object obj : installedOneOffList) {
                OiiiInstallOneoffInvEntry invEntry;
                Vector bugsFixed;
                if (!(obj instanceof OiiiInstallOneoffInvEntry) || !bugsToFix.containsAll(bugsFixed = (invEntry = (OiiiInstallOneoffInvEntry)obj).getBugs()) || bugsToFix.size() == 0 || bugsFixed.size() == 0 || bugsToFix.size() == bugsFixed.size()) continue;
                subsetPatches.add(invEntry);
            }
            buff = new StringBuffer("IPMRWServices::add() with patch ID ");
            buff.append(patchID);
            OLogger.debug(buff);
            if (oracleHomeName == null || oracleHomeIndex == -1 || patchID == null || bugsToFix == null) {
                buff = new StringBuffer("IPMRWServices::add() gets ");
                buff.append("a null object: oracleHomeName = ");
                buff.append(oracleHomeName);
                buff.append(", index = ");
                buff.append(oracleHomeIndex);
                buff.append(", bugsToFix = ");
                buff.append(bugsToFix);
                OLogger.debug(buff);
                throw new NullPointerException(buff.toString());
            }
            try {
                buff = new StringBuffer("IPMRWServices::add() calling OUI createOneoffInvEntry()");
                OLogger.debug(buff);
                this.entry = this.getRawInventory().createOneoffInvEntry(patchID, bugsToFix, isRollBackable, oracleHomeName, uniquePatchID, patchDescription, langs, oracleHomeIndex, subsetPatches);
            }
            catch (OiiiOneoffException ex) {
                OLogger.printStackTrace(ex);
                buff = new StringBuffer("IPMRWServices::add() fails to createOneoffEnvEntry (or) createMiniPatchsetInvEntry: \"");
                buff.append(ex.getMessage());
                buff.append("\"");
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(buff.toString(), ex);
                re.setStackTrace(ex.getStackTrace());
                throw re;
            }
            if (this.entry == null) {
                buff = new StringBuffer("IPMRWServices::add(), createOneOff returns null");
                OLogger.debug(buff);
                throw new NullPointerException(buff.toString());
            }
            PatchComponent[] patchComponents = patchObject.getIncludedPatchComponents();
            for (int i2 = 0; i2 < patchComponents.length && this.entry != null; ++i2) {
                ConflictHandler conflictHandler;
                OiiiCompInstallID compInstallID;
                PatchComponent eachPatchComp = patchComponents[i2];
                if (eachPatchComp == null || eachPatchComp.getName().equals("oracle.nextgen.metadata") || (compInstallID = (conflictHandler = new ConflictHandler()).getComponentInstallID(installedComponents, eachPatchComp)) == null) continue;
                OiiiCompIdOhPair oPair = new OiiiCompIdOhPair(compInstallID, oracleHomeIndex);
                if (this.entry != null) {
                    this.entry.addBaseComp(oPair);
                }
                PatchAction[] patchActions = patchObject.getPatchActionsForComponent(eachPatchComp);
            }
            try {
                buff = new StringBuffer("IPMRWServices::add() calling OUI addOneoffInvEntry");
                OLogger.debug(buff);
                this.getRawInventory().addOneoffInvEntry(this.entry, oracleHomeName);
            }
            catch (OiiiOneoffException e2) {
                OPatchStateManagerFactory.getInstance().setErrorCode(103);
                OLogger.printStackTrace(e2);
                buff = new StringBuffer("IPMRWServices::add(), addOneoff.. throws OiiiOneoffExp");
                buff.append(e2.getMessage());
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(e2.getMessage(), e2);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            catch (Exception e3) {
                OPatchStateManagerFactory.getInstance().setErrorCode(103);
                OLogger.printStackTrace(e3);
                buff = new StringBuffer("IPMRWServices::add(), addOneoff.. throws Exception");
                OLogger.debug(buff);
                throw e3;
            }
            OLogger.debug(new StringBuffer("IPMRWServices::add() returns"));
        }
    }

    private void processPatch(PatchObject patchObject, boolean rollback) {
        if (OPatchEnv.isCUPSupported() && !OPatchEnv.isSnowBall()) {
            try {
                HomeOperationsExt homeOp = this.getHomeOperations();
                if (this.getBatchMode()) {
                    return;
                }
                PatchInfo pInfoObj = this.createPatchInfoObj(patchObject, rollback);
                OLogger.justlog(OLogger.INFO, "Before homeOp.processPatch()");
                homeOp.processPatch(pInfoObj);
                OLogger.justlog(OLogger.INFO, "After homeOp.processPatch()");
            }
            catch (Throwable e2) {
                OLogger.justlog(OLogger.SEVERE, "Nextget could not process patch " + patchObject.getPatchID());
                StringWriter errors = new StringWriter();
                e2.printStackTrace(new PrintWriter(errors));
                OLogger.justlog(OLogger.SEVERE, errors.toString());
                RuntimeException rt = new RuntimeException(e2);
                rt.setStackTrace(e2.getStackTrace());
                throw rt;
            }
            finally {
                if (!this.getBatchMode()) {
                    if (rollback) {
                        rollbackPatchCheckResultsMap.remove(patchObject);
                        rollbackAnalyzedPatches.remove(patchObject);
                    } else {
                        applyPatchCheckResultsMap.remove(patchObject);
                        applyAnalyzedPatches.remove(patchObject);
                    }
                }
            }
        }
    }

    @Override
    public void savePatch(PatchObject patchObject) throws Throwable {
        boolean cont = true;
        StringBuffer buff = new StringBuffer("IPMRWServices::savePatch()");
        OLogger.debug(buff);
        if ((!OPatchEnv.isCUPSupported() || OPatchEnv.isSnowBall()) && this.entry == null) {
            OPatchStateManagerFactory.getInstance().setErrorCode(116);
            OLogger.debug(new StringBuffer("IPMRWServices::savePatch() gets a null OiiiInstallOneoffInvEntry (or) entry object"));
            throw new NullPointerException("IPMRWServices::savePatch() gets a null OiiiInstallOneoffInvEntry entry, probably because caller has not called to register the patch yet");
        }
        String patchLoc = patchObject.getPatchLocation();
        String patchID = patchObject.getTripletPatchID();
        String oh = null;
        oh = OPatchEnv.isCUPSupported() ? IPM.INSTANCE.getReadServices().getHomeOperations().getHomeDir() : lock.getOracleHomePath();
        String ohPatchLocToSave = OPatchEnv.getPatchFilemapInfoLoc(oh, patchID);
        buff = new StringBuffer("IPMRWServices::savePatch() will save patch actions & inventory to ");
        buff.append(ohPatchLocToSave);
        OLogger.debug(buff);
        HomeInventoryHelper.savePatchMetaFileToInventory(oh, patchObject);
        OLogger.debug(new StringBuffer("IPMRWServices::savePatch() calling OUI saveInstallInventory()"));
        cont = Rules.OUIWrite_continue();
        if (cont) {
            HomeOperationsExt homeOp;
            this.processPatch(patchObject, false);
            this.saveInstallInventory();
            if (OPatchEnv.isCUP2Supported()) {
                CUPFileHandler cupFileHandler = new CUPFileHandler();
                cupFileHandler.save(oh, patchObject);
            }
            if (OPatchEnv.isCUPSupported() && !OPatchEnv.isSnowBall() && !(homeOp = IPM.INSTANCE.getRWServices().getHomeOperations()).getVersionInfo().isNextGen()) {
                homeOp.close();
                if (this.needsLockBack) {
                    IPM.INSTANCE.getRWServices().lock(this.saveOHForLockBack);
                }
            }
        } else {
            buff = new StringBuffer("REPORT: IPMRWServices::savePatch(): skip calling");
            buff.append(" OUI saveInstallInventory()");
            OLogger.log(OLogger.FINEST, buff.toString());
        }
        OLogger.debug(new StringBuffer("IPMRWServices::savePatch() returns"));
    }

    private void removePatchCUP(PatchObject patchObject) throws HomeOperationsException {
        StringBuffer buff = new StringBuffer("IPMRWServices::removePatchCUP(PatchObject patchObject)");
        PatchInfo patchInfoObj = this.createPatchInfoObj(patchObject, true);
        HomeOperationsExt homeOp = this.getHomeOperations();
        OLogger.debug(buff.toString() + " : removing installed patch " + patchObject.getPatchID() + " from inventory...");
        if (!homeOp.getVersionInfo().isNextGen()) {
            IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
            if (rwServices.isLocked()) {
                this.needsLockBack = true;
                this.saveOHForLockBack = rwServices.getOracleHomePath();
                rwServices.release();
            }
            homeOp.initialize(SessionMode.WRITE);
        }
        homeOp.removePatchFromInventory(patchInfoObj);
        OLogger.debug(buff.toString() + " : Done removing installed patch " + patchObject.getPatchID() + " from inventory...");
    }

    @Override
    public void remove(PatchObject patchObject) throws NullPointerException, IllegalAccessException, Exception {
        if (OPatchEnv.isCUPSupported() && !OPatchEnv.isSnowBall()) {
            this.removePatchCUP(patchObject);
        } else {
            OLogger.debug(new StringBuffer("IPMRWServices::remove()"));
            if (patchObject == null) {
                throw new NullPointerException("IPMRWServices::remove() gets null patchObject");
            }
            if (!RawInventory.isInstallInventoryExist()) {
                throw new NullPointerException("IPMRWServices::remove() gets null installInventory");
            }
            InstalledComponent[] installedComponents = this.getInstalledComponents();
            if (installedComponents == null) {
                throw new NullPointerException("IPMRWServices::remove() gets null InstallComponents[]");
            }
            String oracleHomeName = null;
            int oracleHomeIndex = -1;
            String oracleHomePath = "";
            try {
                oracleHomeName = this.getOracleHomeName();
                oracleHomeIndex = this.getIndex();
                oracleHomePath = this.getOracleHomePath();
            }
            catch (Throwable t) {
                // empty catch block
            }
            String patchID = patchObject.getOriginalPatchID();
            String uid = patchObject.getPatchInventory().getPSENumber();
            Vector bugsToFix = patchObject.getBugsToFixVector();
            boolean isRollBackable = patchObject.isRollBackable();
            Vector langs = new Vector();
            String language = patchObject.getPatchInventory().getPatchLanguage();
            if (patchObject.getPatchType().equals("snowball")) {
                langs = OiixLanguage.strToVect((String)language);
            }
            StringBuffer buff = new StringBuffer("IPMRWServices::remove() with patch ID ");
            buff.append(patchID);
            OLogger.debug(buff);
            if (oracleHomeName == null || oracleHomeIndex == -1 || patchID == null || bugsToFix == null) {
                buff = new StringBuffer("IPMRWServices::remove() gets ");
                buff.append("a null object: oracleHomeName = ");
                buff.append(oracleHomeName);
                buff.append(", index = ");
                buff.append(oracleHomeIndex);
                buff.append(", bugsToFix = ");
                buff.append(bugsToFix);
                OLogger.debug(buff);
                throw new NullPointerException("IPMRWServices::remove() gets null Oracle Home path, null patchID, or null bugsToFix vector");
            }
            try {
                buff = new StringBuffer("IPMRWServices::remove() calling OUI createOneoffInvEntry()");
                OLogger.debug(buff);
                this.entry = this.getRawInventory().getOneoffInvEntry(patchID, langs, uid, oracleHomeIndex, oracleHomePath);
            }
            catch (OiiiOneoffException ex) {
                buff = new StringBuffer("IPMRWServices::remove() fails to getOneoffEnvEntry: \"");
                buff.append(ex.getMessage());
                buff.append("\"");
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(buff.toString(), ex);
                re.setStackTrace(ex.getStackTrace());
                throw re;
            }
            if (this.entry == null) {
                buff = new StringBuffer("IPMRWServices::remove(), getOneOff returns null");
                OLogger.debug(buff);
                throw new NullPointerException("IPMRWServices::remove(): new entry was created as null by OUI");
            }
            try {
                buff = new StringBuffer("IPMRWServices::remove() calling OUI removeOneoffInvEntry");
                OLogger.debug(buff);
                this.getRawInventory().removeOneoffInvEntry(this.entry);
            }
            catch (OiiiOneoffException e2) {
                buff = new StringBuffer("IPMRWServices::remove(), removeOneoff.. throws OiiiOneoffExp");
                buff.append(e2.getMessage());
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(e2.getMessage(), e2);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            catch (Exception e3) {
                buff = new StringBuffer("IPMRWServices::remove(), removeOneoff.. throws Exception");
                OLogger.debug(buff);
                throw e3;
            }
            OLogger.debug(new StringBuffer("IPMRWServices::remove() returns"));
        }
    }

    @Override
    public void deletePatch(String node, PatchObject patchObject) throws Throwable {
        HomeOperationsExt homeOp;
        StringBuffer buff = new StringBuffer("IPMRWServices::deletePatch()");
        OLogger.debug(buff);
        buff.append(" is called with node ");
        buff.append(node);
        OLogger.debug(buff);
        if (!OPatchEnv.isCUPSupported() && this.entry == null) {
            OLogger.debug(new StringBuffer("IPMRWServices::deletePatch() gets a null OiiiInstallOneoffInvEntry object"));
            throw new NullPointerException("IPMRWServices::deletePatch() gets a null OiiiInstallOneoffInvEntry entry (or) OiiiInstallMiniPatchsetInvEntry, probably because caller has not called to remove the patch yet");
        }
        String patchLoc = patchObject.getPatchLocation();
        String patchID = patchObject.getTripletPatchID();
        String oh = null;
        oh = OPatchEnv.isCUPSupported() ? IPM.INSTANCE.getReadServices().getHomeOperations().getHomeDir() : lock.getOracleHomePath();
        String ohPatchLocToSave = OPatchEnv.getPatchFilemapInfoLoc(oh, patchID);
        buff = new StringBuffer("IPMRWServices::deletePatch() will delete patch actions & inventory under ");
        buff.append(ohPatchLocToSave);
        OLogger.debug(buff);
        try {
            HomeInventoryHelper.removePatchDirectoryStructure(ohPatchLocToSave);
        }
        catch (Exception e2) {
            buff = new StringBuffer("IPMRWServices::deletePatch() failed to delete files from ");
            buff.append(ohPatchLocToSave);
            OLogger.debug(buff);
        }
        OLogger.debug(new StringBuffer("IPMRWServices::deletePatch() calling OUI saveInstallInventory()"));
        this.processPatch(patchObject, true);
        this.saveInstallInventory();
        if (OPatchEnv.isCUPSupported() && !(homeOp = IPM.INSTANCE.getRWServices().getHomeOperations()).getVersionInfo().isNextGen()) {
            homeOp.close();
            if (this.needsLockBack) {
                IPM.INSTANCE.getRWServices().lock(this.saveOHForLockBack);
            }
        }
        OLogger.debug(new StringBuffer("IPMRWServices::deletePatch() returns"));
    }

    @Override
    public void closeHomeOpResetLock() throws Throwable {
        HomeOperationsExt homeOp;
        if (OPatchEnv.isCUPSupported() && !(homeOp = IPM.INSTANCE.getRWServices().getHomeOperations()).getVersionInfo().isNextGen()) {
            homeOp.close();
            if (this.needsLockBack) {
                IPM.INSTANCE.getRWServices().lock(this.saveOHForLockBack);
            }
        }
    }

    @Override
    public boolean isLockedAsRW() {
        return lock != null && lock.isWriterLock();
    }

    @Override
    public void upgradeVersion(String intComponent, String version) {
        StringBuffer buff = new StringBuffer("IPMRWServices::upgradeVersion() called");
        OLogger.debug(buff);
        if (!Rules.OUIWrite_continue()) {
            return;
        }
        OiiiVersion oVer = new OiiiVersion(version);
        if (oVer == null) {
            throw new RuntimeException("\nIllegal version given for update. Please provide a valid version.");
        }
        String chkVersion = oVer.getVerString();
        if (chkVersion == null || chkVersion.equals("")) {
            throw new RuntimeException("\nIllegal version given for update. Please provide a valid version.");
        }
        int homeIndex = this.getIndex();
        OLogger.log(OLogger.FINE, "Home Index is : " + homeIndex);
        OLogger.log(OLogger.FINE, "Version is : " + version);
        OLogger.log(OLogger.FINE, "Component is : " + intComponent);
        boolean isUpdateCompPresent = this.checkIfUpdateComponentPresent(intComponent);
        if (!isUpdateCompPresent) {
            OLogger.println(OLogger.getString("OUI-67666", new Object[]{intComponent, "updateopatchversion"}));
            return;
        }
        boolean success = true;
        OLogger.println(OLogger.getString("OUI-67607", new Object[]{version, intComponent, this.getRawInventory().getOracleHomePath()}));
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallInventory");
            Method[] methods = chkClass.getMethods();
            boolean foundFlag = false;
            for (int i2 = 0; i2 < methods.length; ++i2) {
                if (!methods[i2].getName().equalsIgnoreCase("updateCompVersion")) continue;
                foundFlag = true;
                break;
            }
            if (!foundFlag) {
                OLogger.warn("OUI-67124", new Object[]{"OPatch cannot execute this utility because of no OUI support."});
                return;
            }
            success = this.getRawInventory().updateCompVersion(intComponent, oVer, homeIndex);
            this.getRawInventory().saveInstallInventory();
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage(), e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (!success) {
            throw new RuntimeException("\nUpgrade of OPatch version was not successful.");
        }
    }

    private boolean checkIfUpdateComponentPresent(String intComponent) {
        InstalledComponent[] comps;
        if (OPatchEnv.isNextGen()) {
            comps = this.getNextGenInstalledComponents();
            if (comps == null) {
                comps = this.getInstalledComponents();
            }
        } else {
            comps = this.getInstalledComponents();
        }
        boolean isUpdateCompPresent = false;
        for (InstalledComponent comp : comps) {
            if (!intComponent.equals(comp.getID())) continue;
            isUpdateCompPresent = true;
        }
        return isUpdateCompPresent;
    }

    @Override
    public void savePatchesToInventory() throws Exception {
        if (OPatchEnv.isCUPSupported() && !OPatchEnv.isSnowBall() && this.getBatchMode()) {
            OLogger.printlnOnLog("Saving inventory only once after applying all patches");
            OLogger.justlog(OLogger.INFO, "Before homeop.saveInventory()");
            HomeOperationsExt homeOp = this.getHomeOperations();
            homeOp.saveInventory();
            OLogger.justlog(OLogger.INFO, "After homeop.saveInventory()");
        }
    }

    @Override
    public void saveInstallInventory() throws Exception {
        if (OPatchEnv.isCUPSupported() && !OPatchEnv.isSnowBall()) {
            HomeOperationsExt homeOp = this.getHomeOperations();
            if (!this.getBatchMode()) {
                OLogger.printlnOnLog("Saving inventory after applying each patch");
                homeOp.saveInventory();
            } else {
                OLogger.justlog(OLogger.INFO, "No save inventory for each patch, wait till the end for all patches.");
            }
        } else {
            try {
                this.getRawInventory().saveInstallInventory();
            }
            catch (Throwable e2) {
                RuntimeException re = new RuntimeException(e2.getMessage(), e2);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
    }

    private void verifyPatchStorageDirectory(String oracleHomePath) throws Throwable {
        StringBuffer buff = new StringBuffer("IPMRWServices::verifyPatchStorageDirectory()");
        OLogger.debug(buff);
        String patchStorageDirPath = "";
        String customLogDir = OPatchEnv.getCustomLogDir();
        patchStorageDirPath = customLogDir != null && !customLogDir.equals("") ? OPatchEnv.getPatchStorageDirectoryPath(customLogDir) : OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        Path patchStorage = WrapperFactory.getNioServiceWrapper().getPath(patchStorageDirPath, new String[0]);
        boolean dirExist = Files.exists(patchStorage, new LinkOption[0]);
        if (!dirExist) {
            buff = new StringBuffer("IPMRWServices::verifyPatchStorageDirectory() mkdir ");
            buff.append(patchStorageDirPath);
            OLogger.debug(buff);
            try {
                Files.createDirectories(patchStorage, new FileAttribute[0]);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        if (!(Files.exists(patchStorage, new LinkOption[0]) && Files.isReadable(patchStorage) && Files.isWritable(patchStorage))) {
            throw new SecurityException("IPMRWServices::verifyPatchStorageDirectory() cannot read or write to " + patchStorageDirPath);
        }
    }

    @Override
    public void lockWithoutCreatingPS(String oracleHomePath) throws RuntimeException {
        if (lock != null && lock.isWriterLock()) {
            OLogger.debug(new StringBuffer("IPMReadServices::init() IIPMRWServices has been already initialized"));
        } else {
            if (lock != null) {
                OLogger.debug(new StringBuffer("IPMReadServices::init() releasing RO lock to create RW lock "));
                lock.release();
            }
            try {
                lock = OHILock.lock(oracleHomePath, false);
                if (RawInventory.isInstallInventoryExist()) {
                    rawInventory = RawInventory.getInstance(lock.getOracleHomePath(), lock.getCurrentOUISession(), true);
                    PatchingModel.returnModelCode(lock.getOracleHomePath());
                }
            }
            catch (Throwable e2) {
                OLogger.debug(new StringBuffer("Unable to acquire OHI RW Lock: "));
                RuntimeException re = new RuntimeException(e2.getMessage(), e2);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
    }

    @Override
    public void processPatches(PatchObject[] patchObjects, boolean rollback) {
        if (OPatchEnv.isCUPSupported() && !OPatchEnv.isSnowBall()) {
            try {
                if (this.getBatchMode()) {
                    OLogger.printlnOnLog("Process patches in batch mode, only once after applying all patches");
                    PatchObject[] patchInfoList = new ArrayList();
                    for (PatchObject pObj : patchObjects) {
                        patchInfoList.add(this.createPatchInfoObj(pObj, rollback));
                    }
                    OLogger.justlog(OLogger.INFO, "Before homeOp.processPatches()");
                    HomeOperationsExt homeOp = this.getHomeOperations();
                    homeOp.processPatches((List)patchInfoList);
                    OLogger.justlog(OLogger.INFO, "After homeOp.processPatches()");
                }
            }
            catch (Throwable e2) {
                OLogger.justlog(OLogger.SEVERE, "Nextgen could not process patches");
                StringWriter errors = new StringWriter();
                e2.printStackTrace(new PrintWriter(errors));
                OLogger.justlog(OLogger.SEVERE, errors.toString());
                RuntimeException rt = new RuntimeException(e2);
                rt.setStackTrace(e2.getStackTrace());
                throw rt;
            }
            finally {
                if (this.getBatchMode()) {
                    String cachekey;
                    if (rollback) {
                        for (PatchObject patchObject : patchObjects) {
                            cachekey = patchObject.getPatchUniqID() + "_" + patchObject.getPatchID();
                            rollbackPatchCheckResultsMap.remove(cachekey);
                            rollbackAnalyzedPatches.remove(cachekey);
                        }
                    } else {
                        for (PatchObject patchObject : patchObjects) {
                            cachekey = patchObject.getPatchUniqID() + "_" + patchObject.getPatchID();
                            applyPatchCheckResultsMap.remove(cachekey);
                            applyAnalyzedPatches.remove(cachekey);
                        }
                    }
                }
            }
        }
    }

    private PatchInfo createPatchInfoObj(PatchObject patchObject, boolean rollback) {
        PatchCheckResults pcr = this.getPatchCheckResults(patchObject, rollback);
        return WrapperFactory.getCommonApiWrapper().getPatchInfo(patchObject, rollback, pcr, this.getAffectedFilesWithState(patchObject));
    }

    private Map<FileState, List<Path>> getAffectedFilesWithState(PatchObject patch) {
        Object result;
        ArrayList<Path> modifiedFiles = new ArrayList<Path>();
        ArrayList<Path> addedFiles = new ArrayList<Path>();
        ArrayList<Path> deletedFiles = new ArrayList<Path>();
        String oraclehome = this.getOracleHomePath();
        for (PatchComponent pc : patch.getIncludedPatchComponents()) {
            for (PatchAction pa : patch.getImmediatePatchActionsToExecuteForComponent(pc)) {
                String[] touched;
                Path file;
                String[] deletefile;
                ArrayList deletefiles;
                if (pa instanceof DeleteAction && (deletefiles = pa.getFilesTouched(oraclehome)) != null && !deletefiles.isEmpty() && (deletefile = (String[])deletefiles.get(0)) != null && deletefile.length > 1 && !deletefile[1].equals("")) {
                    file = WrapperFactory.getNioServiceWrapper().getPath(deletefile[1], new String[0]);
                    deletedFiles.add(file);
                }
                if (pa instanceof JarActionEntity) {
                    String jarTouched = pa.getParentFilePath(oraclehome);
                    Path file2 = WrapperFactory.getNioServiceWrapper().getPath(jarTouched, new String[0]);
                    if (Files.exists(file2, new LinkOption[0])) {
                        modifiedFiles.add(file2);
                        OLogger.debug("JarAction file touched:" + jarTouched);
                        continue;
                    }
                    if (!OPatchEnv.isDeleteInactivePatches()) {
                        OLogger.justlog(OLogger.SEVERE, "File container " + jarTouched + " does not exist");
                        throw new RuntimeException("ERROR: File container :" + jarTouched + " does not exist");
                    }
                    OLogger.justlog(OLogger.INFO, "Ignoreing error File container " + jarTouched + " does not exist for delete inactive patches case");
                    continue;
                }
                ArrayList filesTouched = pa.getFilesTouched(oraclehome);
                if (filesTouched == null || filesTouched.isEmpty() || (touched = (String[])filesTouched.get(0)) == null || touched.length <= 1 || touched[1].equals("")) continue;
                file = WrapperFactory.getNioServiceWrapper().getPath(touched[1], new String[0]);
                if (Files.exists(file, new LinkOption[0])) {
                    modifiedFiles.add(file);
                    continue;
                }
                addedFiles.add(file);
            }
        }
        if (patch.isSparseCopy() && (result = OPatchEnv.getMSIDCustomResults().get(patch.getPatchUniqID())) != null) {
            for (String file : result.getAddedFiles()) {
                addedFiles.add(WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]));
            }
            for (String file : result.getRemoveFiles()) {
                deletedFiles.add(WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]));
            }
        }
        result = new LinkedHashMap<FileState, ArrayList<Path>>();
        result.put(FileState.ADDED, addedFiles);
        result.put(FileState.DELETED, deletedFiles);
        result.put(FileState.MODIFIED, modifiedFiles);
        return result;
    }

    public static void destroyObject() {
        if (instance != null) {
            IPMRWServices.instance.entry = null;
            instance = null;
        }
    }
}

