/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.Result;
import oracle.glcm.opatch.common.impl.ComponentCheckResultImpl;
import oracle.glcm.opatch.common.impl.PatchInventoryImpl;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PrereqSession;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;

public class UninstallValidation {
    private Map<String, List<String>> componentPatchMap = null;
    private List<String> autorollbackList;
    private Map<String, Set<String>> conflictMap;
    private List<String> uninstallList;
    private Set<String> emptySet;
    private List<String> inactivePatches;
    private static UninstallValidation uninstallValidation;

    public static UninstallValidation createInstance(List<PatchInventory.Component> uninstallComps) {
        if (uninstallValidation == null) {
            uninstallValidation = new UninstallValidation(uninstallComps);
        }
        return uninstallValidation;
    }

    public static UninstallValidation getInstance() {
        return uninstallValidation;
    }

    private UninstallValidation(List<PatchInventory.Component> uninstallComps) {
        this.buildUninstlalList(uninstallComps);
        this.buildComponentMap();
    }

    private void buildUninstlalList(List<PatchInventory.Component> uninstallComps) {
        this.uninstallList = new ArrayList<String>();
        for (PatchInventory.Component invComp : uninstallComps) {
            this.uninstallList.add(this.buildKey(invComp));
        }
    }

    private void buildComponentMap() {
        OneOffEntry[] inactiveOneoffs;
        this.componentPatchMap = new HashMap<String, List<String>>();
        this.autorollbackList = new ArrayList<String>();
        this.conflictMap = new HashMap<String, Set<String>>();
        this.inactivePatches = new ArrayList<String>();
        this.emptySet = new HashSet<String>(0);
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(OPatchEnv.getOracleHome());
        }
        catch (Throwable e2) {
            OLogger.log(OLogger.SEVERE, e2.getMessage());
        }
        OneOffEntry[] pohs = readServices.getAllInstalledPatches();
        for (OneOffEntry oneoff : inactiveOneoffs = readServices.getInactivePatches()) {
            this.inactivePatches.add(oneoff.getPatchID());
        }
        this.buildComponentMap(inactiveOneoffs);
        this.buildComponentMap(pohs);
    }

    private void buildComponentMap(OneOffEntry[] patches) {
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (OneOffEntry patch : patches) {
            this.compute(patch);
            for (PatchComponent component : patch.getIncludedPatchComponents()) {
                String key = this.buildKey(component);
                if (this.componentPatchMap.containsKey(key)) {
                    this.componentPatchMap.get(key).add(patch.getPatchID());
                    continue;
                }
                ArrayList<String> pIDs = new ArrayList<String>();
                pIDs.add(patch.getPatchID());
                this.componentPatchMap.put(key, pIDs);
            }
        }
    }

    private String buildKey(String componentName, String componentVersion) {
        return componentName + "_" + componentVersion;
    }

    private String buildKey(PatchComponent pc) {
        return this.buildKey(pc.getName(), pc.getVersion());
    }

    private String buildKey(PatchInventory.Component pc) {
        return this.buildKey(pc.getName(), pc.getVersion());
    }

    public ComponentCheckResult checkUninstall(PatchInventory.Component component) {
        ComponentCheckResultImpl result = new ComponentCheckResultImpl(component);
        if (this.conflictMap.isEmpty()) {
            result.setResult(Result.NOT_EVALUATED);
            result.setDetails("The check for uninstall component : " + component.getName() + " passed from opatch side.");
        } else {
            String key = this.buildKey(component);
            if (this.componentPatchMap.containsKey(key)) {
                List<String> patchInUse = this.componentPatchMap.get(key);
                HashSet<String> patchInConflict = new HashSet<String>();
                for (String p2 : patchInUse) {
                    if (!this.conflictMap.containsKey(p2)) continue;
                    patchInConflict.add(p2);
                }
                result.setResult(Result.METADATA_ERROR);
                result.setDetails("Can't uninstall the component:  " + component.getName() + component.getVersion() + "\nBecause it is used by following patches: " + patchInConflict);
            }
        }
        return result;
    }

    private void compute(OneOffEntry patch) {
        HashSet<String> componentsInPatch = new HashSet<String>();
        for (PatchComponent pc : patch.getIncludedPatchComponents()) {
            componentsInPatch.add(this.buildKey(pc));
        }
        HashSet sameComps = new HashSet(componentsInPatch);
        sameComps.retainAll(this.uninstallList);
        if (sameComps.size() > 0) {
            if (sameComps.size() < componentsInPatch.size()) {
                this.conflictMap.put(patch.getPatchID(), sameComps);
            }
            if (sameComps.size() == componentsInPatch.size()) {
                if (this.canAutoRollback(patch)) {
                    this.autorollbackList.add(patch.getPatchID());
                } else {
                    this.conflictMap.put(patch.getPatchID(), this.emptySet);
                }
            }
        }
    }

    private boolean canAutoRollback(OneOffEntry patch) {
        if (patch.getIsComposite()) {
            OLogger.justlog(OLogger.SEVERE, "UninstallValidation: canAutoRollback() : Can't autorollback composite patch: " + patch.getPatchID());
            return false;
        }
        if (this.inactivePatches.contains(patch.getPatchID())) {
            OLogger.justlog(OLogger.SEVERE, "UninstallValidation: canAutoRollback() : Can't autorollback inactive patch: " + patch.getPatchID());
            return false;
        }
        return true;
    }

    public boolean isInAutoRollbackList(String patchId) {
        return this.autorollbackList.contains(patchId);
    }

    public static void clear() {
        uninstallValidation = null;
    }
}

