/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.MergePatch;

public class MergePatchBuilder {
    private static MergePatchBuilder builder = null;

    public static MergePatchBuilder getInstance() {
        if (builder == null) {
            builder = new MergePatchBuilder();
        }
        return builder;
    }

    private MergePatchBuilder() {
    }

    public MergePatch build(IPatch supersetPatch, Collection<IPatch> subPatches, IConflictMap map) {
        MergePatch rebuildPatch = null;
        Collection<IPatch> installedPatches = map.getPoh();
        rebuildPatch = new MergePatch(supersetPatch, subPatches);
        ArrayList<IPatch> relevantPatches = this.getCompleteOverlayPatches(subPatches, installedPatches);
        for (IPatch toMergePatch : relevantPatches) {
            rebuildPatch.addToMergePatch(toMergePatch);
            rebuildPatch.addBugs(toMergePatch.getBugs());
        }
        for (IPatch subPatch : subPatches) {
            rebuildPatch.addOverlayPatches(subPatch, this.getOverlayPatches(subPatch, installedPatches));
        }
        rebuildPatch.addBugs(supersetPatch.getBugs());
        return rebuildPatch;
    }

    protected ArrayList<IPatch> getCompleteOverlayPatches(Collection<IPatch> subPatches, Collection<IPatch> installedPatches) {
        ArrayList<IPatch> finalList = new ArrayList<IPatch>();
        ArrayList<IPatch> intermediateList = new ArrayList<IPatch>();
        for (IPatch subPatch : subPatches) {
            intermediateList.add(subPatch);
        }
        while (!intermediateList.isEmpty()) {
            IPatch patch = (IPatch)intermediateList.get(0);
            ArrayList<IPatch> dependents = this.getOverlayPatches(patch, installedPatches);
            for (IPatch dependent : dependents) {
                if (intermediateList.contains(dependent) || finalList.contains(dependent)) continue;
                intermediateList.add(dependent);
            }
            finalList.add(patch);
            intermediateList.remove(0);
        }
        return finalList;
    }

    private ArrayList<IPatch> getOverlayPatches(IPatch patch, Collection<IPatch> pohs) {
        ArrayList<IPatch> overlayPatches = new ArrayList<IPatch>();
        for (String overlayID : patch.getBeingOverlaysID()) {
            for (IPatch poh : pohs) {
                if (!poh.getPatchId().equals(overlayID) || overlayPatches.contains(poh)) continue;
                overlayPatches.add(poh);
            }
        }
        return overlayPatches;
    }
}

