/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import oracle.opatch.conflicttextualinterpreter.IPatch;

public class GraphHelper {
    public Collection topologicalSort(HashMap patchesMap) {
        ENode node;
        int i2;
        Graph graph = new Graph(patchesMap);
        VNode[] mVexs = graph.getVertex();
        int num = mVexs.length;
        int[] ins = new int[num];
        ArrayList<IPatch> sortedPatches = new ArrayList<IPatch>();
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (i2 = 0; i2 < num; ++i2) {
            node = mVexs[i2].firstEdge;
            while (node != null) {
                int n2 = node.ivex;
                ins[n2] = ins[n2] + 1;
                node = node.nextEdge;
            }
        }
        for (i2 = 0; i2 < num; ++i2) {
            if (ins[i2] != 0) continue;
            queue.offer(i2);
        }
        while (!queue.isEmpty()) {
            int j2 = (Integer)queue.poll();
            sortedPatches.add(mVexs[j2].patch);
            node = mVexs[j2].firstEdge;
            while (node != null) {
                int n3 = node.ivex;
                ins[n3] = ins[n3] - 1;
                if (ins[node.ivex] == 0) {
                    queue.offer(node.ivex);
                }
                node = node.nextEdge;
            }
        }
        return sortedPatches;
    }

    public Collection topologicalSort(Collection patches) {
        HashMap patchesMap = new HashMap();
        for (Object obj : patches) {
            IPatch patch = (IPatch)obj;
            HashSet<String> relatives = new HashSet<String>();
            HashSet<String> tempSet = new HashSet<String>();
            relatives.addAll(patch.getPrereqsID());
            relatives.addAll(patch.getOverlaysID());
            if (!patch.isComposite()) {
                for (String relative : relatives) {
                    IPatch p2;
                    boolean noMatch = true;
                    for (Object o2 : patches) {
                        p2 = (IPatch)o2;
                        if (!p2.getPatchId().equals(relative)) continue;
                        noMatch = false;
                        break;
                    }
                    if (!noMatch) continue;
                    block3: for (Object o2 : patches) {
                        p2 = (IPatch)o2;
                        if (!p2.isComposite()) continue;
                        for (IPatch subPatch : p2.getSubPatches()) {
                            if (!subPatch.getPatchId().equals(relative)) continue;
                            tempSet.add(p2.getPatchId());
                            continue block3;
                        }
                    }
                }
            }
            relatives.addAll(tempSet);
            patchesMap.put(patch, relatives);
        }
        return this.topologicalSort(patchesMap);
    }

    public boolean isCycle(Collection<IPatch> patches) {
        HashMap<IPatch, Collection<String>> prereqMap = new HashMap<IPatch, Collection<String>>();
        for (IPatch patch : patches) {
            prereqMap.put(patch, patch.getPrereqsID());
        }
        Collection sortedPrereqPatches = this.topologicalSort(prereqMap);
        HashMap<IPatch, Collection<String>> overlayMap = new HashMap<IPatch, Collection<String>>();
        for (IPatch patch : patches) {
            overlayMap.put(patch, patch.getOverlaysID());
        }
        Collection sortedOverlayPatches = this.topologicalSort(overlayMap);
        return sortedPrereqPatches.size() != patches.size() || sortedOverlayPatches.size() != patches.size();
    }

    public class Graph {
        private VNode[] mVexs = null;

        public Graph(HashMap patchesMap) {
            int i2;
            Set patchSet = patchesMap.keySet();
            ArrayList<IPatch> patches = new ArrayList<IPatch>();
            for (IPatch patch : patchSet) {
                patches.add(patch);
            }
            Collections.sort(patches, new Comparator<IPatch>(){

                @Override
                public int compare(IPatch p1, IPatch p2) {
                    int p2Len;
                    int p1Len = p1.getPatchId().length();
                    if (p1Len < (p2Len = p2.getPatchId().length())) {
                        return 1;
                    }
                    if (p1Len > p2Len) {
                        return -1;
                    }
                    return p2.getPatchId().compareTo(p1.getPatchId());
                }
            });
            int vlen = patches.size();
            this.mVexs = new VNode[vlen];
            for (i2 = 0; i2 < vlen; ++i2) {
                this.mVexs[i2] = new VNode();
                this.mVexs[i2].patch = (IPatch)patches.get(i2);
                this.mVexs[i2].firstEdge = null;
            }
            for (i2 = 0; i2 < vlen; ++i2) {
                IPatch p1 = (IPatch)patches.get(i2);
                Collection relatives = (Collection)patchesMap.get(p1);
                if (relatives.isEmpty()) continue;
                for (int j2 = 0; j2 < vlen; ++j2) {
                    IPatch p2 = (IPatch)patches.get(j2);
                    if (!relatives.contains(p2.getPatchId())) continue;
                    ENode enode = new ENode();
                    enode.ivex = j2;
                    if (this.mVexs[i2].firstEdge == null) {
                        this.mVexs[i2].firstEdge = enode;
                        continue;
                    }
                    this.addNodeToChain(this.mVexs[i2].firstEdge, enode);
                }
            }
        }

        public VNode[] getVertex() {
            return this.mVexs;
        }

        private void addNodeToChain(ENode head, ENode newNode) {
            if (head == null) {
                return;
            }
            ENode point = head;
            while (point.nextEdge != null) {
                point = point.nextEdge;
            }
            point.nextEdge = newNode;
        }
    }

    public class VNode {
        IPatch patch = null;
        ENode firstEdge = null;
    }

    public class ENode {
        int ivex;
        ENode nextEdge = null;
    }
}

