/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class SQLUtilities {
    private static boolean migrateMode = false;
    private static ArrayList sidsStarted = new ArrayList();

    private static String buildSqlCmd(String oracleHomePath, String sqlFilePath, String sqlplusPath, String dbUser, String dbPasswd) {
        StringBuffer buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID()));
        String masterFileLoc = "";
        buff.append(File.separator);
        buff.append("master.sql");
        masterFileLoc = buff.toString();
        StringBuffer sqlCmd = new StringBuffer(sqlplusPath);
        sqlCmd.append(" -silent ");
        sqlCmd.append(" -L ");
        sqlCmd.append(dbUser);
        sqlCmd.append("/");
        sqlCmd.append(dbPasswd);
        sqlCmd.append(" as sysdba @");
        sqlCmd.append(masterFileLoc);
        buff = new StringBuffer();
        buff.append("@");
        buff.append(sqlFilePath);
        buff.append("\n");
        String exitSqlFilePath = "";
        try {
            exitSqlFilePath = SQLUtilities.createDBExitFile(oracleHomePath);
        }
        catch (RuntimeException e2) {
            OLogger.printStackTrace(e2);
            OLogger.printlnOnLog(OLogger.INFO, "Not able to append the EXIT sql file to the command for sqlplus");
            exitSqlFilePath = "";
        }
        if (!exitSqlFilePath.equals("")) {
            buff.append("@");
            buff.append(exitSqlFilePath);
        }
        try {
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(masterFileLoc, new String[0]);
            if (!Files.exists(f2, new LinkOption[0])) {
                Files.createFile(f2, new FileAttribute[0]);
            }
            if (!Files.exists(f2, new LinkOption[0])) {
                throw new RuntimeException("Cannot create \"" + sqlCmd.toString() + "\"");
            }
            BufferedWriter fw = Files.newBufferedWriter(f2, Charset.forName("UTF-8"), new OpenOption[0]);
            fw.write(buff.toString());
            fw.flush();
            fw.close();
            OLogger.debug(new StringBuffer("This Master Sql file contains ->\n"));
            OLogger.debug(buff);
            OLogger.debug(new StringBuffer("\n"));
        }
        catch (IOException e3) {
            RuntimeException re = new RuntimeException(e3);
            throw re;
        }
        return sqlCmd.toString();
    }

    public static SystemCall.ExecReturn runSqlScript(String oracleHomePath, String sqlFilePath, String dbUser, String dbPasswd, String dbSid) {
        StringBuffer buff = new StringBuffer("SQLUtilities::runSqlScript()");
        OLogger.debug(buff);
        if (!Rules.SystemWrite_continue()) {
            return null;
        }
        String sqlCmd = "";
        OPatchProperty opp = new OPatchProperty();
        try {
            sqlCmd = SQLUtilities.buildSqlCmd(oracleHomePath, sqlFilePath, opp.getSqlplusCommand(), dbUser, dbPasswd);
        }
        catch (Exception e2) {
            buff = new StringBuffer("SQLUtilities::runSqlScript())\n");
            buff.append("    " + e2.getMessage());
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException("Command 'sqlplus' not found", e2);
            throw re;
        }
        String[] systemCommands = new String[]{sqlCmd};
        String[] sqlEnvp = null;
        if (dbSid == null || dbSid.equals("")) {
            RuntimeException re = new RuntimeException("SQL : One of the SIDs is null or empty string.");
            throw re;
        }
        sqlEnvp = new String[]{"ORACLE_HOME=" + oracleHomePath, "ORACLE_SID=" + dbSid, "NLS_LANG=AMERICAN_AMERICA.AL32UTF8"};
        buff = new StringBuffer("Executing the SQL command : ");
        buff.append(sqlCmd);
        buff.append(" \nwith ORACLE_HOME as \"" + oracleHomePath + "\" \n");
        buff.append(" and ORACLE_SID as \"" + dbSid + "\" \n");
        buff.append(" and NLS_LANG as \"AMERICAN_AMERICA.AL32UTF8\" \n");
        OLogger.log(OLogger.FINE, buff.toString());
        SystemCall.ExecReturn ret = SystemCall.runtimeExec(systemCommands, sqlEnvp, null);
        buff = new StringBuffer("SQLUtilities::runSqlScript done\n");
        buff.append("Return Obj is " + ret.toString());
        OLogger.debug(buff);
        return ret;
    }

    public static boolean startupDB(String oracleHomePath, boolean migrateMode, String dbUser, String dbPasswd, String dbSID) throws RuntimeException {
        if (!Rules.SystemWrite_continue()) {
            return true;
        }
        if (sidsStarted.contains(dbSID)) {
            return true;
        }
        String sqlFilePath = SQLUtilities.createSQLFile(oracleHomePath, migrateMode, true);
        SystemCall.ExecReturn ret = null;
        OPatchEnv.setRunTimeExecMessageNeeded(false);
        try {
            ret = SQLUtilities.runSqlScript(oracleHomePath, sqlFilePath, dbUser, dbPasswd, dbSID);
            sidsStarted.add(dbSID);
        }
        catch (Exception e2) {
            StringBuffer buff = new StringBuffer("SQLUtilities::startupDB()\n");
            buff.append("    " + e2.getMessage());
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException("DB startup failed.", e2);
            throw re;
        }
        finally {
            OPatchEnv.setRunTimeExecMessageNeeded(true);
        }
        OLogger.debug(new StringBuffer(ret.toString()));
        return ret.isOK();
    }

    public static boolean shutdownDB(String oracleHomePath, String dbUser, String dbPasswd, String dbSID) {
        if (!Rules.SystemWrite_continue()) {
            return true;
        }
        if (!sidsStarted.contains(dbSID)) {
            return true;
        }
        String sqlFilePath = SQLUtilities.createSQLFile(oracleHomePath, migrateMode, false);
        SystemCall.ExecReturn ret = null;
        try {
            ret = SQLUtilities.runSqlScript(oracleHomePath, sqlFilePath, dbUser, dbPasswd, dbSID);
            sidsStarted.remove(dbSID);
        }
        catch (Exception e2) {
            StringBuffer buff = new StringBuffer("SQLUtilities::shutdownDB()\n");
            buff.append("    " + e2.getMessage());
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException("DB shutdown failed.", e2);
            throw re;
        }
        OLogger.debug(new StringBuffer(ret.toString()));
        return ret.isOK();
    }

    public static void shutdownAllDB(String oracleHomePath) {
        if (!Rules.SystemWrite_continue()) {
            return;
        }
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbUsers = OPatchEnv.getDBUsers();
        String[] dbPasswds = OPatchEnv.getDBPasswds();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String localNode = OPatchEnv.getLocalNode();
        if (dbSids == null || dbSids.length < 1) {
            return;
        }
        for (int sidIter = 0; sidIter < dbSids.length; ++sidIter) {
            if (dbNodes[sidIter] != null && !dbNodes[sidIter].equals("") && !dbNodes[sidIter].equals(localNode) || SQLUtilities.shutdownDB(oracleHomePath, dbUsers[sidIter], dbPasswds[sidIter], dbSids[sidIter])) continue;
            StringBuffer buff = new StringBuffer("Unable to shutdown the database instance \"");
            buff.append(dbSids[sidIter]);
            buff.append("\". Please try to shutdown and startup manually.");
            OLogger.warn("OUI-67124", new Object[]{buff.toString()});
        }
    }

    private static String createSQLFile(String oracleHomePath, boolean migrateMode, boolean startupCode) {
        StringBuffer buff = new StringBuffer("SQLUtilities::createSQLFile()");
        OLogger.debug(buff);
        buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID()));
        buff.append(File.separator);
        StringBuffer sqlCmds = null;
        if (startupCode) {
            buff.append("db_startup.sql");
            sqlCmds = new StringBuffer();
            if (migrateMode) {
                sqlCmds.append("STARTUP MIGRATE");
            } else {
                sqlCmds.append("STARTUP");
            }
        } else {
            buff.append("db_shutdown.sql");
            sqlCmds = new StringBuffer();
            sqlCmds.append("SHUTDOWN IMMEDIATE");
        }
        sqlCmds.append(";\nexit;\n");
        try {
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
            if (!Files.exists(f2, new LinkOption[0])) {
                Files.createFile(f2, new FileAttribute[0]);
            }
            if (!Files.exists(f2, new LinkOption[0])) {
                throw new RuntimeException("Cannot create \"" + buff.toString() + "\"");
            }
            BufferedWriter fw = Files.newBufferedWriter(f2, Charset.forName("UTF-8"), new OpenOption[0]);
            fw.write(sqlCmds.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
        return buff.toString();
    }

    private static String createDBExitFile(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("SQLUtilities::createDBExitFile()");
        OLogger.debug(buff);
        buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID()));
        buff.append(File.separator);
        buff.append("db_exit.sql");
        StringBuffer sqlCmds = new StringBuffer("exit;");
        try {
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
            if (!Files.exists(f2, new LinkOption[0])) {
                Files.createFile(f2, new FileAttribute[0]);
            }
            if (!Files.exists(f2, new LinkOption[0])) {
                throw new RuntimeException("Cannot create \"" + buff.toString() + "\"");
            }
            BufferedWriter fw = Files.newBufferedWriter(f2, Charset.forName("UTF-8"), new OpenOption[0]);
            fw.write(sqlCmds.toString());
            fw.close();
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
        return buff.toString();
    }

    public static String detectOraError(String input) {
        String oraString = "";
        if (input == null || input.equals("")) {
            return oraString;
        }
        int indexMatch = input.indexOf("ORA-");
        if (indexMatch == -1) {
            return oraString;
        }
        return input;
    }

    public static SystemCall.ExecReturn runMemoryReqs(String oracleHomePath, String pchFilePath, String dbUser, String dbPasswd, String dbSid) {
        StringBuffer buff = new StringBuffer("SQLUtilities::runMemoryReqs()");
        OLogger.debug(buff);
        Object[] systemCommands = new String[]{};
        OPatchProperty opp = new OPatchProperty();
        try {
            if (dbSid != null) {
                StringBuffer connectStringBuff = new StringBuffer(dbUser);
                connectStringBuff.append("/");
                connectStringBuff.append(dbPasswd);
                connectStringBuff.append(" as sysdba");
                systemCommands = new String[]{opp.getOputilCommand(), "memoryreqs", "-o", pchFilePath, "-c", connectStringBuff.toString()};
            } else {
                systemCommands = new String[]{opp.getOputilCommand(), "memoryreqs", "-o", pchFilePath};
            }
        }
        catch (Exception e2) {
            buff = new StringBuffer("SQLUtilities::runMemoryReqs())\n");
            buff.append("    " + e2.getMessage());
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException("Command 'oputil' not found", e2);
            throw re;
        }
        String[] sqlEnvp = null;
        if (dbSid != null && !dbSid.equals("")) {
            sqlEnvp = new String[]{"ORACLE_HOME=" + oracleHomePath, "ORACLE_SID=" + dbSid};
            buff = new StringBuffer("Executing the oputil command : ");
            buff.append(Arrays.toString(systemCommands));
            buff.append(" \nwith ORACLE_HOME as \"" + oracleHomePath + "\" \n");
            buff.append(" and ORACLE_SID as \"" + dbSid + "\" \n");
        }
        OLogger.log(OLogger.FINE, buff.toString());
        SystemCall.ExecReturn ret = SystemCall.runtimeExec((String[])systemCommands, sqlEnvp, null);
        buff = new StringBuffer("SQLUtilities::runMemoryReqs done\n");
        buff.append("Return Obj is " + ret.toString());
        OLogger.debug(buff);
        return ret;
    }
}

