/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;

public abstract class Rac {
    public abstract String toString(IIPMReadServices var1);

    public abstract boolean shouldPropagate(RacType var1) throws NullPointerException;

    public abstract boolean shouldRemoteRun(RacType var1) throws NullPointerException;

    public abstract void srvmCopyOneoffsRecursive(String var1, String var2) throws RuntimeException;

    public abstract void srvmCopySavedPatchInPatchStorage(String var1, String var2) throws RuntimeException;

    public abstract void srvmCopyDirectoryRecursive(String var1, String var2, boolean var3) throws RuntimeException;

    public abstract void srvmCopyPatchFile(String var1, String var2) throws RuntimeException;

    public abstract void srvmCopyPatchFile(String var1, String var2, String var3) throws RuntimeException;

    public abstract void srvmRunRemoteCommand(String var1, String var2) throws RuntimeException;

    public abstract RacType getInstance(IIPMReadServices var1, boolean var2);

    public abstract RacType getInstance(IIPMReadServices var1);

    public abstract String readPatchingLevel(String var1) throws RuntimeException;

    public abstract boolean isCFS(String var1, String[] var2, String var3);

    public static class RacType {
        private RacDiagCode racDiagCode = RacDiagCode.UN_INIT;
        private String crsDownPrompt = "";
        private String localNode = "";
        private String[] remoteNodes = new String[0];
        String typeDesc = "";
        public static final RacType NO_RAC = new RacType("NO_RAC");
        public static final RacType SINGLE_NODE = new RacType("SINGLE_NODE");
        public static final RacType MULTIPLE_NODE = new RacType("MULTIPLE_NODE");
        public static final RacType SHARED_MULTIPLE_NODE = new RacType("SHARED_MULTIPLE_NODE");

        void setCrsDownPrompt(String prompt) {
            this.crsDownPrompt = prompt;
        }

        protected String getCrsDownPrompt() {
            return this.crsDownPrompt;
        }

        public void setRacDiagCode(RacDiagCode code) {
            this.racDiagCode = code;
        }

        public String getRacDiagMessage() {
            return this.racDiagCode.getRacDiagMsg();
        }

        public RacDiagCode getRacDiagCode() {
            return this.racDiagCode;
        }

        public String[] getRemoteNodes() {
            String[] retVal = new String[this.remoteNodes.length];
            for (int i2 = 0; i2 < this.remoteNodes.length; ++i2) {
                retVal[i2] = this.remoteNodes[i2];
            }
            return retVal;
        }

        public void setRemoteNodes(String[] nodes) {
            this.remoteNodes = new String[nodes.length];
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                this.remoteNodes[i2] = nodes[i2];
            }
        }

        public String getLocalNode() {
            return this.localNode;
        }

        public void setLocalNode(String node) {
            this.localNode = node;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("[RacType: ");
            buff.append("typeDesc= ");
            buff.append(this.typeDesc);
            buff.append(", detail= ");
            buff.append(this.getDetail());
            buff.append(" ]");
            return buff.toString();
        }

        private RacType() {
        }

        public RacType(String type) {
            this.typeDesc = type;
        }

        public String getDetail() {
            String detail = "";
            detail = this == NO_RAC ? OLogger.getString("OUI-67144") : (this == SINGLE_NODE ? OLogger.getString("OUI-67146") : (this == MULTIPLE_NODE ? OLogger.getString("OUI-67147") : OLogger.getString("OUI-67145")));
            return detail;
        }
    }

    public static class RacDiagCode {
        private int code = 0;
        String msg0 = "N/A";
        String msg1 = OLogger.getString("OUI-67137");
        String msg2 = OLogger.getString("OUI-67138");
        String msg3 = OLogger.getString("OUI-67139");
        String msg4 = OLogger.getString("OUI-67140");
        String msg5 = OLogger.getString("OUI-67141");
        String msg6 = OLogger.getString("OUI-67142");
        String[] racMessages = new String[]{this.msg0, this.msg1, this.msg2, this.msg3, this.msg4, this.msg5, this.msg6};
        public static final RacDiagCode UN_INIT = new RacDiagCode(0);
        public static final RacDiagCode SHARED_ORACLE_HOME = new RacDiagCode(1);
        public static final RacDiagCode NODE_LIST_DETECTED_PATCH_LOCAL = new RacDiagCode(2);
        public static final RacDiagCode NODE_LIST_ONE_ELEMENT = new RacDiagCode(3);
        public static final RacDiagCode NON_CLUSTER_ORACLE_HOME = new RacDiagCode(4);
        public static final RacDiagCode CAN_PROPAGATE_ORACLE_HOME = new RacDiagCode(5);
        public static final RacDiagCode LOCAL_FLAG_REQUESTED = new RacDiagCode(6);

        private RacDiagCode() {
        }

        private RacDiagCode(int code) {
            this.code = code;
        }

        String getRacDiagMsg() {
            return this.racMessages[this.code];
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("[RacDiagCode: ");
            buff.append(this.getRacDiagMsg());
            buff.append(" ]");
            return buff.toString();
        }
    }
}

