/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.opatch.FMWHandler;
import oracle.opatch.automation.AutomationHelper;
import oracle.opatch.automation.jaxb.ActionType;
import oracle.opatch.automation.jaxb.Automation;
import oracle.opatch.automation.jaxb.AutomationVariables;
import oracle.opatch.automation.jaxb.Command;
import oracle.opatch.automation.jaxb.CommandAction;
import oracle.opatch.automation.jaxb.DeployAction;
import oracle.opatch.automation.jaxb.DeployArtifact;
import oracle.opatch.automation.jaxb.J2EELifecycleAction;
import oracle.opatch.automation.jaxb.LifecycleAction;
import oracle.opatch.automation.jaxb.PatchingPhase;
import oracle.opatch.automation.jaxb.Variable;
import oracle.opatch.fmwpatchverbs.DeployActionEl;
import oracle.opatch.fmwpatchverbs.LifecycleActionEl;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchverbs.CommandActionEl;
import oracle.opatch.patchverbs.InterviewEl;
import oracle.opatch.patchverbs.ParserObject;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffException;

public class OPatchVersionSpecific {
    public static final String[] DISABLED_UTILS = new String[0];
    public static final String[] AVAILABLE_MAIN_CMDS = new String[]{"apply", "rollback", "lsinv", "lspatches", "lsinventory", "query", "util", "prereq", "version", "napply", "nrollback", "-fmw", "compare", "update", "enablecas", "disablecas", "enableioc"};
    public static final String[] AVAILABLE_ZDT_CMDS = new String[]{"createview", "lsviews", "synchview", "destroyview", "detach", "attach", "tagbranch", "cleanup", "iscasrepospresent"};
    public static final boolean isPropertySupported = true;

    public static ParserObject loadAutomationFile(Path xmlfile) throws Exception {
        if (!Files.exists(xmlfile, new LinkOption[0]) || Files.isDirectory(xmlfile, new LinkOption[0])) {
            return null;
        }
        ParserObject parserObject = OPatchVersionSpecific.loadAutomationFileStream(Files.newInputStream(xmlfile, new OpenOption[0]));
        parserObject.setFileName(xmlfile.getFileName().toString());
        return parserObject;
    }

    public static ParserObject loadAutomationFileStream(InputStream xmlFileStream) throws Exception {
        ParserObject parserObject = new ParserObject();
        AutomationHelper helper = null;
        try {
            helper = AutomationHelper.getInstance();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            throw e2;
        }
        catch (Throwable t) {
            OLogger.printStackTrace(t);
            throw new Exception(t.getMessage());
        }
        try {
            Automation automation = helper.readAutomation(xmlFileStream, true);
            AutomationVariables interview = automation.getAutomationVariables();
            if (interview != null) {
                List<Variable> interviewList = interview.getVariable();
                for (Variable promptObj : interviewList) {
                    String key = promptObj.getName();
                    String question = "";
                    if (promptObj.getPromptUser() != null) {
                        question = promptObj.getPromptUser().getValue();
                    }
                    boolean required = promptObj.isRequired();
                    String defaultValue = promptObj.getDefaultValue();
                    if (defaultValue == null) {
                        defaultValue = "";
                    }
                    boolean mask = promptObj.isSecured();
                    InterviewEl inter = new InterviewEl();
                    inter.setMaskValue(mask);
                    inter.setQuestionValue(question);
                    inter.setRequiredValue(required);
                    inter.setDefaultValue(defaultValue);
                    inter.setKeyValue(key);
                    parserObject.addInterviewElement(inter);
                }
            }
            PatchingPhase[] phases = new PatchingPhase[]{automation.getPrePatchApplication(), automation.getPostPatchApplication()};
            for (int pc = 0; pc < 2; ++pc) {
                PatchingPhase phase = phases[pc];
                if (phase == null) continue;
                List<ActionType> list = AutomationHelper.getActionOrContextList(phase);
                for (ActionType element : list) {
                    CommandAction cAction;
                    List<Command> cList;
                    ActionType aType = element;
                    if (aType instanceof DeployAction) {
                        DeployActionEl deployAction = new DeployActionEl();
                        DeployAction JAXBDeployAction = (DeployAction)aType;
                        String actsOn = JAXBDeployAction.getActsOn();
                        ArrayList JAXBDeployList = (ArrayList)JAXBDeployAction.getDeployArtifact();
                        if (JAXBDeployList == null) continue;
                        for (int i2 = 0; i2 < JAXBDeployList.size(); ++i2) {
                            boolean isBaseCompDeploy;
                            DeployArtifact JAXBArtifact = (DeployArtifact)JAXBDeployList.get(i2);
                            String compositeName = JAXBArtifact.getFileName().toString();
                            String fileName = JAXBArtifact.getFileName();
                            String path = JAXBArtifact.getDestinationPath();
                            String revision = JAXBArtifact.getRevision();
                            boolean bl = isBaseCompDeploy = JAXBArtifact.isBaseCompositeDeployment() == null ? false : JAXBArtifact.isBaseCompositeDeployment();
                            if (actsOn.equals("SOAComposite")) {
                                deployAction.setSOACompDeployFlag(true);
                            } else if (actsOn.equals("SOAResourceBundle")) {
                                deployAction.setSOARbDeployFlag(true);
                            } else if (actsOn.equals("BI")) {
                                deployAction.setBIPDeployFlag(true);
                            } else if (actsOn.equals("IDM")) {
                                deployAction.setLDIFDeployFlag(true);
                            }
                            deployAction.setFileName(fileName);
                            deployAction.setFilePath(path);
                            deployAction.setCompositeName(compositeName);
                            deployAction.setRevision(revision);
                            if (isBaseCompDeploy) {
                                deployAction.setBaseCompositeDeployment(true);
                            }
                            if (pc == 0) {
                                deployAction.setPreAction(true);
                            }
                            parserObject.addDeployActionElement(deployAction);
                        }
                        continue;
                    }
                    if (aType instanceof J2EELifecycleAction) {
                        LifecycleAction lifeCycleAction = (LifecycleAction)aType;
                        String action = lifeCycleAction.getType();
                        LifecycleActionEl lel = new LifecycleActionEl();
                        lel.setLifeCycleActionType(action);
                        J2EELifecycleAction j2eeLifecycleAction = (J2EELifecycleAction)aType;
                        List<String> applNamesList = j2eeLifecycleAction.getApplicableEntityName();
                        for (String applName : applNamesList) {
                            lel.addDependencyList(applName);
                        }
                        if (pc == 0) {
                            lel.setPreAction(true);
                        }
                        parserObject.addLifeCycleActionElement(lel);
                        continue;
                    }
                    if (!(aType instanceof CommandAction) || (cList = (cAction = (CommandAction)aType).getCommand()) == null) continue;
                    for (int i3 = 0; i3 < cList.size(); ++i3) {
                        Command cmd = cList.get(i3);
                        String runAs = cAction.getRunAs();
                        String completeScriptPath = cmd.getSource().getValue();
                        List<String> parameters = cmd.getParameter();
                        CommandActionEl ca = new CommandActionEl(runAs, completeScriptPath, parameters);
                        if (pc == 0) {
                            ca.setPreAction(true);
                        }
                        parserObject.addCommandActionElement(ca);
                    }
                }
            }
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
            throw e3;
        }
        catch (Throwable t) {
            OLogger.printStackTrace(t);
            throw new Exception(t.getMessage());
        }
        return parserObject;
    }

    public static OiiiInstallOneoffInvEntry createOneoffInvEntry(OiiiInstallInventory oiInv, String patchID, Vector bugsToFix, boolean isRollBackable, Vector langs, String uniquePatchID, int oracleHomeIndex) throws OiiiOneoffException {
        OiiiInstallOneoffInvEntry retEntry = oiInv.createOneoffInvEntry(patchID, bugsToFix, new Vector(), isRollBackable, langs, uniquePatchID, oracleHomeIndex);
        return retEntry;
    }

    public static OiiiInstallOneoffInvEntry getOneoffInvEntry(OiiiInstallInventory oiInv, String patchID, Vector langs, String uniquePatchID, int oracleHomeIndex) throws OiiiOneoffException {
        return oiInv.getOneoffInvEntry(patchID, langs, uniquePatchID, oracleHomeIndex);
    }

    public static void setDescription(String patchDescription, OiiiInstallOneoffInvEntry retEntry) {
        retEntry.setDescription(patchDescription);
    }

    public static void setSupersededOneOffsList(Vector subsetPatches, OiiiInstallOneoffInvEntry retEntry) {
        retEntry.setSupersededOneOffsList(subsetPatches);
    }

    public static Vector getAllOneoffInvEntries(OiiiInstallInventory oiInv, Integer index) {
        try {
            return oiInv.getAllOneoffInvEntries(index.intValue(), false);
        }
        catch (Throwable t) {
            return oiInv.getAllOneoffInvEntries(index.intValue());
        }
    }

    static void fmwApply() {
        FMWHandler.apply();
    }

    static void fmwRollback() {
        FMWHandler.rollback();
    }
}

