/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.Rules;
import oracle.opatch.StringResource;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchProperty {
    protected static final String OPATCH_RESOURCE_FILE = "properties";
    private static final String SEPARATOR = ":";
    protected static final String USER_DIR_KEY = "user.dir";
    protected static final String PATH = "OPatch.PATH";
    protected static final String PATH_SEPARATOR_KEY = "path.separator";
    private static Properties systemProp = null;
    private static String _pathSeparator = null;
    private static String _path = null;

    public OPatchProperty() {
        systemProp = System.getProperties();
        _pathSeparator = systemProp.getProperty(PATH_SEPARATOR_KEY);
        _path = systemProp.getProperty(PATH);
    }

    protected Properties getBundledProperty() {
        InputStream is = this.getClass().getResourceAsStream(OPATCH_RESOURCE_FILE);
        Properties prop = new Properties();
        if (is != null) {
            try {
                prop.load(is);
            }
            catch (IOException e2) {
                return prop;
            }
        }
        return prop;
    }

    protected static Properties getUserProperty() {
        Properties userProp = new Properties();
        if (OPatchEnv.getPropertyFile().equals("")) {
            String launchLoc;
            String string = launchLoc = systemProp != null ? systemProp.getProperty(USER_DIR_KEY) : null;
            if (launchLoc != null) {
                StringBuffer buff = new StringBuffer(launchLoc);
                buff.append(File.separator);
                buff.append(OPATCH_RESOURCE_FILE);
                Path file = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
                if (Files.exists(file, new LinkOption[0]) && Files.isReadable(file)) {
                    try {
                        InputStream fis = Files.newInputStream(file, new OpenOption[0]);
                        userProp.load(fis);
                    }
                    catch (IOException e2) {
                        return userProp;
                    }
                }
            }
        } else {
            Path file = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getPropertyFile(), new String[0]);
            if (Files.exists(file, new LinkOption[0]) && Files.isReadable(file)) {
                try {
                    InputStream fis = Files.newInputStream(file, new OpenOption[0]);
                    userProp.load(fis);
                }
                catch (IOException e3) {
                    return userProp;
                }
            } else {
                RuntimeException re = new RuntimeException("User given property file does not exist.");
                throw re;
            }
        }
        return userProp;
    }

    protected static Properties mergeProperties(Properties p1, Properties p2) {
        Properties mProp = new Properties();
        if (p1 == null && p2 == null) {
            return mProp;
        }
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        Set<Object> keySet1 = p1.keySet();
        Set<Object> keySet2 = p2.keySet();
        for (String string : keySet1) {
            String string2 = p1.getProperty(string);
            mProp.setProperty(string, string2);
        }
        Set<Object> set = keySet1;
        for (String string : keySet2) {
            if (set.contains(string)) continue;
            String value2 = p2.getProperty(string);
            mProp.setProperty(string, value2);
        }
        return mProp;
    }

    private String replaceLiteralOHWithPath(String path) {
        int beginIndex = 0;
        beginIndex = path.indexOf("%ORACLE_HOME%");
        if (beginIndex == -1) {
            return path;
        }
        beginIndex += "%ORACLE_HOME%".length();
        try {
            path = path.substring(beginIndex + 1);
            path = PatchObjectUtil.getPlatformDependentPath(path);
            String oracleHomePath = OPatchEnv.getOracleHome();
            path = oracleHomePath + File.separator + path;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    protected String getCommandInPropertyFiles(String command) {
        boolean isBatIndex;
        boolean isExeIndex;
        StringBuffer buff = new StringBuffer();
        StringBuffer tmp = new StringBuffer("getCommandInPropertyFiles():  looking up command \"");
        tmp.append(command);
        tmp.append("\" in property file \"");
        tmp.append(OPATCH_RESOURCE_FILE);
        tmp.append("\"");
        OLogger.debug(tmp);
        Properties bundledProp = this.getBundledProperty();
        Properties userProp = OPatchProperty.getUserProperty();
        Properties opatchProp = OPatchProperty.mergeProperties(userProp, bundledProp);
        Properties systemProp = System.getProperties();
        boolean found = false;
        String foundPath = null;
        String pathForCommand = opatchProp.getProperty(command);
        try {
            pathForCommand = this.replaceLiteralOHWithPath(pathForCommand);
        }
        catch (Exception e2) {
            // empty catch block
        }
        tmp = new StringBuffer("Path in merged property files: ");
        tmp.append(pathForCommand);
        OLogger.debug(tmp);
        if (command.equals("linux_ar") || command.equals("unix_ar")) {
            command = "ar";
        }
        if (command.equals("linux_make") || command.equals("unix_make")) {
            command = "make";
        }
        if (command.equals("ptlpatch")) {
            tmp = new StringBuffer(command);
            if (OPatchEnv.isWindows()) {
                tmp.append(".cmd");
            } else {
                tmp.append(".csh");
            }
            command = tmp.toString();
            tmp = new StringBuffer("Appending command with extension before look up...");
            tmp.append(command);
            OLogger.debug(tmp);
        }
        if (command.equals("sqlplus") && OPatchEnv.isWindows() && !(isExeIndex = command.endsWith(".exe"))) {
            buff = new StringBuffer(command);
            buff.append(".exe");
            command = buff.toString();
        }
        if (command.equals("mkpatch") && OPatchEnv.isWindows() && !(isExeIndex = command.endsWith(".exe"))) {
            buff = new StringBuffer(command);
            buff.append(".exe");
            command = buff.toString();
        }
        if (command.equals("oracle") && OPatchEnv.isWindows() && !(isExeIndex = command.endsWith(".exe"))) {
            buff = new StringBuffer(command);
            buff.append(".exe");
            command = buff.toString();
        }
        if (command.equals("patchgen") && OPatchEnv.isWindows() && !(isBatIndex = command.endsWith(".bat"))) {
            buff = new StringBuffer(command);
            buff.append(".bat");
            command = buff.toString();
        }
        if (pathForCommand != null && _pathSeparator != null) {
            foundPath = this.searchCommand(command, pathForCommand, _pathSeparator);
        }
        return foundPath;
    }

    public String searchCommand(String command, String path, String pathSeparator) {
        String foundPath = null;
        StringTokenizer st = new StringTokenizer(path, pathSeparator);
        while (st.hasMoreTokens()) {
            String eachPath = st.nextToken();
            StringBuffer buff = new StringBuffer(eachPath);
            buff.append(File.separator);
            buff.append(command);
            StringBuffer tmp = new StringBuffer("  check on \"");
            tmp.append(buff.toString());
            tmp.append("\"");
            OLogger.debug(tmp);
            Path file = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
            if (!Files.exists(file, new LinkOption[0])) continue;
            foundPath = buff.toString();
            tmp = new StringBuffer("  found \"");
            tmp.append(foundPath);
            tmp.append("\"");
            OLogger.debug(tmp);
            break;
        }
        return foundPath;
    }

    public String getCommandInPath(String command) {
        String pathSeparator;
        StringBuffer tmp = new StringBuffer("getCommandInPath(): check for command \"");
        tmp.append(command);
        tmp.append("\"");
        OLogger.debug(tmp);
        String foundPath = null;
        boolean found = false;
        Properties systemProp = System.getProperties();
        Properties userProp = new Properties();
        tmp = new StringBuffer("  Looking up command in path \"");
        tmp.append(_path);
        tmp.append("\"");
        OLogger.debug(tmp);
        String string = pathSeparator = systemProp != null ? systemProp.getProperty(PATH_SEPARATOR_KEY) : null;
        if (command.equals("ptlpatch")) {
            tmp = new StringBuffer(command);
            if (OPatchEnv.isWindows()) {
                tmp.append(".cmd");
            } else {
                tmp.append(".csh");
            }
            command = tmp.toString();
            tmp = new StringBuffer("Appending command with extension before look up...");
            tmp.append(command);
            OLogger.debug(tmp);
        }
        if (_path != null && _pathSeparator != null) {
            foundPath = this.searchCommand(command, _path, _pathSeparator);
        }
        return foundPath;
    }

    public boolean hasCommand(String cmdToCheck) {
        try {
            this.getCommand(cmdToCheck);
        }
        catch (NoSuchMethodException e2) {
            return false;
        }
        return true;
    }

    public String getCommand(String command) throws NoSuchMethodException {
        String commandInProperties = this.getCommandInPropertyFiles(command);
        if (commandInProperties != null) {
            return commandInProperties;
        }
        String commandInPath = this.getCommandInPath(command);
        if (commandInPath != null) {
            return commandInPath;
        }
        String msg = OLogger.getString("OUI-67143", new Object[]{command, OPATCH_RESOURCE_FILE, _path});
        throw new NoSuchMethodException(msg);
    }

    public String getLiteralFuserCommand() {
        return "fuser";
    }

    public String getLiteralJarCommand() {
        if (OPatchEnv.isWindows()) {
            return "jar.exe";
        }
        return "jar";
    }

    public String getLiteralArchiveCommand() {
        return "ar";
    }

    public String getLiteralMakeCommand() {
        return "make";
    }

    public String getLiteralMkPatchCommand() {
        return "mkpatch";
    }

    public String getLiteralSqlplusCommand() {
        return "sqlplus";
    }

    public String getLiteralPtlpatchCommand() {
        return "ptlpatch";
    }

    public String getLiteralPatchgenCommand() {
        return "patchgen";
    }

    public String getFuserCommand() throws NoSuchMethodException {
        String cmd = "";
        if (OPatchEnv.isWindows()) {
            String msg = OLogger.getString("OUI-67143", new Object[]{"fuser", OPATCH_RESOURCE_FILE, _path});
            throw new NoSuchMethodException(msg);
        }
        cmd = this.getCommandInPropertyFiles("fuser");
        if (cmd != null && !cmd.equals("")) {
            return cmd;
        }
        cmd = this.getCommandInPath("fuser");
        if (cmd != null) {
            return cmd;
        }
        String msg = OLogger.getString("OUI-67143", new Object[]{"fuser", OPATCH_RESOURCE_FILE, _path});
        throw new NoSuchMethodException(msg);
    }

    public String getMkPatchCommand() throws NoSuchMethodException {
        String cmd = "";
        if (Rules.isMkPatchRequired()) {
            cmd = this.getCommandInPropertyFiles("mkpatch");
            if (cmd != null && !cmd.equals("")) {
                return cmd;
            }
            String msg = OLogger.getString("OUI-67270", new Object[]{"mkpatch", OPATCH_RESOURCE_FILE});
            throw new NoSuchMethodException(msg);
        }
        return "";
    }

    public String getPatchgenCommand() throws NoSuchMethodException {
        String cmd = "";
        String msg = "";
        cmd = this.getCommandInPropertyFiles("patchgen");
        if (cmd != null && !cmd.equals("")) {
            return cmd;
        }
        msg = OLogger.getString("OUI-67270", new Object[]{"patchgen", OPATCH_RESOURCE_FILE});
        throw new NoSuchMethodException(msg);
    }

    public String getPtlpatchCommand() throws NoSuchMethodException {
        String cmd = "";
        cmd = this.getCommandInPropertyFiles("ptlpatch");
        if (cmd != null && !cmd.equals("")) {
            return cmd;
        }
        cmd = this.getCommandInPath("ptlpatch");
        if (cmd != null) {
            return cmd;
        }
        StringBuffer buff = new StringBuffer("ptlpatch");
        if (OPatchEnv.isWindows()) {
            buff.append(".cmd");
        } else {
            buff.append(".csh");
        }
        String msg = OLogger.getString("OUI-67143", new Object[]{buff.toString(), OPATCH_RESOURCE_FILE, _path});
        throw new NoSuchMethodException(msg);
    }

    public String getSqlplusCommand() throws NoSuchMethodException {
        String cmd = "";
        StringBuffer buff = new StringBuffer("sqlplus");
        cmd = this.getCommandInPropertyFiles(buff.toString());
        if (cmd != null && !cmd.equals("")) {
            return cmd;
        }
        String msg = OLogger.getString("OUI-67270", new Object[]{"sqlplus", OPATCH_RESOURCE_FILE});
        throw new NoSuchMethodException(msg);
    }

    public String getOracleBinary() throws NoSuchMethodException {
        String cmd = "";
        cmd = this.getCommandInPropertyFiles("oracle");
        if (cmd != null && !cmd.equals("")) {
            return cmd;
        }
        cmd = this.getCommandInPath("oracle");
        if (cmd != null) {
            return cmd;
        }
        String msg = OLogger.getString("OUI-67143", new Object[]{"oracle", OPATCH_RESOURCE_FILE, _path});
        throw new NoSuchMethodException(msg);
    }

    public String getJarCommand(String oracleHomePath) throws NoSuchMethodException {
        StringBuffer buff = new StringBuffer();
        String cmd = "";
        Path file = null;
        boolean jdkOptionUsed = OPatchEnv.isJdkOptionSpecified();
        if (jdkOptionUsed) {
            String jdkLoc = OPatchEnv.getJdkLoc();
            buff = new StringBuffer(jdkLoc);
            if (OPatchEnv.isWindows()) {
                buff.append(StringResource.JDK_BIN_JAR_CMD_WINDOWS);
            } else {
                buff.append(StringResource.JDK_BIN_JAR_CMD_UNIX);
            }
            cmd = buff.toString();
            file = WrapperFactory.getNioServiceWrapper().getPath(cmd, new String[0]);
            if (Files.exists(file, new LinkOption[0])) {
                return cmd;
            }
        }
        buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        if (OPatchEnv.isWindows()) {
            buff.append(StringResource.JDK_JAR_CMD_WINDOWS);
        } else {
            buff.append(StringResource.JDK_JAR_CMD_UNIX);
        }
        cmd = buff.toString();
        file = WrapperFactory.getNioServiceWrapper().getPath(cmd, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            return cmd;
        }
        String literalCmd = OPatchEnv.isWindows() ? "jar.exe" : "jar";
        cmd = this.getCommandInPath(literalCmd);
        if (cmd != null) {
            return cmd;
        }
        String msg = OLogger.getString("OUI-67143", new Object[]{literalCmd, OPATCH_RESOURCE_FILE, _path});
        throw new NoSuchMethodException(msg);
    }

    public String getArchiveCommand() throws NoSuchMethodException {
        String cmd = "";
        if (OPatchEnv.isWindows()) {
            String msg = OLogger.getString("OUI-67143", new Object[]{"ar", OPATCH_RESOURCE_FILE, _path});
            throw new NoSuchMethodException(msg);
        }
        cmd = this.getCommandInPropertyFiles("ar");
        if (cmd != null && !cmd.equals("")) {
            return cmd;
        }
        if (OPatchEnv.isLinux() ? (cmd = this.getCommandInPropertyFiles("linux_ar")) != null && !cmd.equals("") : !OPatchEnv.isWindows() && (cmd = this.getCommandInPropertyFiles("unix_ar")) != null && !cmd.equals("")) {
            return cmd;
        }
        cmd = this.getCommandInPath("ar");
        if (cmd != null) {
            return cmd;
        }
        String msg = OLogger.getString("OUI-67143", new Object[]{"ar", OPATCH_RESOURCE_FILE, _path});
        throw new NoSuchMethodException(msg);
    }

    public String getMakeCommand() throws NoSuchMethodException {
        String cmd = "";
        if (OPatchEnv.isWindows()) {
            String msg = OLogger.getString("OUI-67143", new Object[]{"make", OPATCH_RESOURCE_FILE, _path});
            throw new NoSuchMethodException(msg);
        }
        cmd = this.getCommandInPropertyFiles("make");
        if (cmd != null && !cmd.equals("")) {
            return cmd;
        }
        if (OPatchEnv.isLinux() ? (cmd = this.getCommandInPropertyFiles("linux_make")) != null && !cmd.equals("") : !OPatchEnv.isWindows() && (cmd = this.getCommandInPropertyFiles("unix_make")) != null && !cmd.equals("")) {
            return cmd;
        }
        cmd = this.getCommandInPath("make");
        if (cmd != null) {
            return cmd;
        }
        String msg = OLogger.getString("OUI-67143", new Object[]{"make", OPATCH_RESOURCE_FILE, _path});
        throw new NoSuchMethodException(msg);
    }

    public boolean hasCopyCommand() {
        return true;
    }

    public boolean hasJarCommand(String oracleHomePath) {
        try {
            String arCmd = this.getJarCommand(oracleHomePath);
            if (arCmd != null && !arCmd.equals("")) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public boolean hasArchiveCommand() {
        try {
            String arCmd = this.getArchiveCommand();
            if (arCmd != null && !arCmd.equals("")) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public boolean hasMakeCommand() {
        try {
            String makeCmd = this.getMakeCommand();
            if (makeCmd != null && !makeCmd.equals("")) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public boolean hasFuserCommand() {
        try {
            String fuserCmd = this.getFuserCommand();
            if (fuserCmd != null && !fuserCmd.equals("")) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public boolean hasMkPatchCommand() {
        try {
            String mkpatchCmd = this.getMkPatchCommand();
            if (mkpatchCmd != null && !mkpatchCmd.equals("")) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public boolean hasPtlpatchCommand() {
        try {
            String ptlpatchCmd = this.getPtlpatchCommand();
            if (ptlpatchCmd != null && !ptlpatchCmd.equals("")) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public boolean hasSqlplusCommand() {
        try {
            String sqlplusCmd = this.getSqlplusCommand();
            if (sqlplusCmd != null && !sqlplusCmd.equals("")) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    protected static String getPath() {
        return _path;
    }

    protected static String getPropertyFileName() {
        return OPATCH_RESOURCE_FILE;
    }

    static void dumpProperties(Properties prop) {
        if (prop != null) {
            Set<Object> keySet = prop.keySet();
            for (String string : keySet) {
                String value = prop.getProperty(string);
                System.out.println(string + "-->" + value);
            }
        }
    }

    public String getOputilCommand() throws NoSuchMethodException {
        String cmd = "";
        cmd = this.getCommandInPropertyFiles("oputil");
        if (cmd != null && !cmd.equals("")) {
            return cmd;
        }
        String msg = OLogger.getString("OUI-67270", new Object[]{"oputil", OPATCH_RESOURCE_FILE});
        throw new NoSuchMethodException(msg);
    }

    public static void main(String[] argv) {
        String command;
        OPatchProperty op = new OPatchProperty();
        try {
            OPatchACL.invokeOLogger(op, "setDebug", new Object[]{true});
        }
        catch (IllegalAccessException e2) {
            // empty catch block
        }
        String completePath = command = "copy";
        try {
            op.getCommand(command);
        }
        catch (NoSuchMethodException e3) {
            System.out.println(e3.getMessage());
        }
    }
}

