/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.opatch.NotSupportedOPatchCASOperationException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchException;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexPair;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.twophase.TwoPhaseMatchType;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchOverCASUtil {
    public static void serializeData(String oh, OPatchPatch[] pis) {
        OLogger.debug("ENTERING METHOD: OPatchOverCASUtil::serializeData(String oh, OPatchPatch[] pis)");
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] saving CAS hash data for current oh and pi onto disk");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            OneOffEntry[] oneoffs = new OneOffEntry[pis.length];
            for (int i2 = 0; i2 < pis.length; ++i2) {
                oneoffs[i2] = pis[i2].getOneOffEntry();
            }
            IndexPair data = OPatchSessionHelper.getHashCodes(oh, oneoffs);
            serializer.serializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "main_oh_hash.txt", data.getFirstKey());
            serializer.serializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "pi_cas_key.txt", data.getSecondKey());
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("serializeData error: " + e2.getMessage());
        }
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] saved CAS hash data for current oh and pi to disk");
        OLogger.debug("EXITING METHOD: OPatchOverCASUtil::serializeData(String oh, OPatchPatch[] pis)");
    }

    public static IndexPair deserializeData(String oh) {
        IndexPair data;
        OLogger.debug("ENTERING METHOD: OPatchOverCASUtil::deserializeData(String oh)");
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] reading CAS hash data for current oh and pi from disk");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            String ohHash = serializer.deserializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "main_oh_hash.txt");
            String keyHash = serializer.deserializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "pi_cas_key.txt");
            data = new IndexPair(ohHash, keyHash);
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("deserializeData error: " + e2.getMessage());
            return null;
        }
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] finished reading CAS hash data for current oh and pi from disk");
        OLogger.debug("EXITING METHOD: OPatchOverCASUtil::deserializeData(String oh)");
        return data;
    }

    public static void serializeStatus(String oh, PatchObject[] pis) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: OPatchOverCASUtil::serializeStatus(String oh, PatchObject[] pis)");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            OneOffEntry[] oneoffs = OPatchUtilHelper.getOneOffObjects(oh, pis);
            String hash = OPatchSessionHelper.getHashCode(oneoffs);
            if (OPatchEnv.isOPatchSDKMode()) {
                serializer.serializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "phaseone_status_SDK", hash);
            } else {
                serializer.serializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "phaseone_status_CLI", hash);
            }
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("serializeStatus error: " + e2.getMessage());
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCASUtil::serializeStatus(String oh, PatchObject[] pis)");
    }

    public static TwoPhaseMatchType deserializeStatus(String oh, PatchObject[] pis) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: OPatchOverCASUtil::deserializeStatus(String oh, PatchObject[] pis)");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        TwoPhaseMatchType t = TwoPhaseMatchType.NONE;
        try {
            OneOffEntry[] oneoffs = OPatchUtilHelper.getOneOffObjects(oh, pis);
            String stored = OPatchEnv.isOPatchSDKMode() ? serializer.deserializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "phaseone_status_SDK") : serializer.deserializeStringValue(OPatchEnv.getPrereqResultFileLoc(oh) + File.separator + "phaseone_status_CLI");
            if (stored == null) {
                return t;
            }
            String current = OPatchSessionHelper.getHashCode(oneoffs);
            t = stored.equals(current) ? TwoPhaseMatchType.SAME : TwoPhaseMatchType.DIFFERENT;
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("deserializeStatus error: " + e2.getMessage());
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCASUtil::deserializeStatus(String oh, PatchObject[] pis)");
        return t;
    }

    public static void cleanupCache(String oracleHomePath) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: OPatchOverCASUtil::cleanupCache()");
        String cacheLoc = OPatchEnv.isOPatchSDKMode() ? OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "phaseone_status_SDK" : OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "phaseone_status_CLI";
        Path cacheLocFile = WrapperFactory.getNioServiceWrapper().getPath(cacheLoc, new String[0]);
        if (Files.exists(cacheLocFile, new LinkOption[0]) && Files.isWritable(cacheLocFile)) {
            OLogger.justlog(OLogger.INFO, "Deleting cached file " + cacheLocFile.getFileName().toString());
            try {
                Files.deleteIfExists(cacheLocFile);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        OPatchOverCASUtil.cleanupFullDBCasRepoStatus(oracleHomePath);
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCASUtil::cleanupCache()");
    }

    public static void validateScripts(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches) throws NotSupportedOPatchCASOperationException {
        String patchLoc;
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCASUtil::validateScripts(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches)");
        if (PatchingModel.returnModelCode(oh) == 2) {
            return;
        }
        boolean found = false;
        if (rollbackPatches != null) {
            for (PatchObject rb : rollbackPatches) {
                patchLoc = OPatchEnv.getPatchBackupDirectoryPath(oh, rb.getCookedPatchID());
                if (!OPatchOverCASUtil.hasCustomScripts(patchLoc)) continue;
                OLogger.justlog(OLogger.INFO, "Patch " + rb.getPatchID() + "to be rolled-back has custom scripts.");
                found = true;
                rb.setScriptsFlagForOPatchOverCAS(true);
            }
        }
        if (applyPatches != null) {
            for (PatchObject ap : applyPatches) {
                patchLoc = ap.getPatchLocation();
                if (!OPatchOverCASUtil.hasCustomScripts(patchLoc)) continue;
                OLogger.justlog(OLogger.INFO, "Patch " + ap.getPatchID() + "to be applied has custom scripts.");
                found = true;
                ap.setScriptsFlagForOPatchOverCAS(true);
            }
        }
        if (found) {
            if (!OPatchEnv.isScriptsEnabledforCAS()) {
                NotSupportedOPatchCASOperationException re = new NotSupportedOPatchCASOperationException(OLogger.getString("OUI-68206"));
                throw re;
            }
            OPatchEnv.setRunWithScriptsforCAS(true);
            OPatchEnv.setPrePostMakePresent(true);
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCASUtil::validateScripts(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches)");
    }

    private static boolean hasCustomScripts(String patchLoc) {
        boolean init = PatchObject.isThereInitScript(patchLoc);
        boolean pre = PatchObject.isTherePreScript(patchLoc);
        boolean post = PatchObject.isTherePostScript(patchLoc);
        return init || pre || post;
    }

    public static void hasMakeActions(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: OPatchOverCASUtil::hasMakeActions(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches)");
        if (rollbackPatches != null) {
            for (PatchObject rb : rollbackPatches) {
                if (!rb.hasApplicableMakeActions(oh)) continue;
                OPatchEnv.setPrePostMakePresent(true);
                break;
            }
        }
        if (applyPatches != null) {
            for (PatchObject ap : applyPatches) {
                if (!ap.hasApplicableMakeActions(oh)) continue;
                OPatchEnv.setPrePostMakePresent(true);
                break;
            }
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCASUtil::hasMakeActions(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches)");
    }

    public static void serializeFullDBCasRepo(String value) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: OPatchOverCASUtil::serializeFullDBCasRepo(String value)");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        try {
            serializer.serializeStringValue(OPatchEnv.getPrereqResultFileLoc(OPatchEnv.getOracleHome()) + File.separator + "fulldbcasrepo_SDK.txt", value);
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("serializeFullDBCasRepo error: " + e2.getMessage());
            OLogger.printStackTrace(e2);
            throw new OPatchException(e2.getMessage());
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCASUtil::serializeFullDBCasRepo(String value)");
    }

    public static String deserializeFullDBCasRepo() {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: OPatchOverCASUtil::deserializeFullDBCasRepo()");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        String value = null;
        try {
            value = serializer.deserializeStringValue(OPatchEnv.getPrereqResultFileLoc(OPatchEnv.getOracleHome()) + File.separator + "fulldbcasrepo_SDK.txt");
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("deserializeFullDBCasRepo error: " + e2.getMessage());
            OLogger.printStackTrace(e2);
            throw new OPatchException(e2.getMessage());
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCASUtil::deserializeFullDBCasRepo()");
        return value;
    }

    public static void cleanupFullDBCasRepoStatus(String oracleHomePath) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: OPatchOverCASUtil::cleanupFullDBCasRepoStatus()");
        if (OPatchEnv.isOPatchSDKMode()) {
            String cacheLoc = OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fulldbcasrepo_SDK.txt";
            Path cacheLocFile = WrapperFactory.getNioServiceWrapper().getPath(cacheLoc, new String[0]);
            if (Files.exists(cacheLocFile, new LinkOption[0]) && Files.isWritable(cacheLocFile)) {
                OLogger.justlog(OLogger.INFO, "Deleting cached file " + cacheLocFile.getFileName().toString());
                try {
                    Files.deleteIfExists(cacheLocFile);
                }
                catch (IOException e2) {
                    OLogger.debug(e2.getMessage());
                }
            }
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCASUtil::cleanupFullDBCasRepoStatus()");
    }
}

