/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.Stack;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import model.common.OUIComponent;
import model.common.Patch;
import oracle.opatch.Bug;
import oracle.opatch.InventoryInstance;
import oracle.opatch.InventoryWrapper;
import oracle.opatch.OPatch;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchInventory;
import oracle.opatch.PatchObject;
import oracle.opatch.Platform;
import oracle.opatch.UpdateComponent;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class LsInventoryToXML {
    private static DocumentBuilderFactory factoryObj = null;
    private static DocumentBuilder builderObj = null;
    private static Document docObj = null;
    private static OutputStream foutObject = null;
    private static Element commonRoot = null;
    private static DOMSource source = null;
    private static Stack stackIndent = null;
    private static int indentValue = 0;
    private static String rootElement = "INVENTORY";
    private static final String indent = "\n   ";
    static String ORACLE_HOME_NAME = "";
    static String ORACLE_HOME_PATH = "";
    static boolean CRS = false;
    static String LOCAL_NODE = "";
    static String[] NODE_LIST = new String[0];
    static InstalledComponent[] INSTALLED_COMPONENTS = new InstalledComponent[0];
    static OneOffEntry[] ONE_OFF_ENTRIES = new OneOffEntry[0];
    static OPatchSDK.OracleHome[] ORACLE_HOME_LIST = new OPatchSDK.OracleHome[0];

    private LsInventoryToXML() {
    }

    private static String getIndentString(int value) {
        StringBuffer indentBuff = new StringBuffer();
        indentBuff.append(indent);
        for (int i2 = 1; i2 < value; ++i2) {
            indentBuff.append("   ");
        }
        return indentBuff.toString();
    }

    protected static void error(String msg) {
        System.out.println("ERROR: " + msg);
        OPatch.exit(1);
    }

    protected static void process(OutputStream outStream, String oracleHomeName, String oracleHomePath, boolean isCRS, String localNode, String[] nodeList, InstalledComponent[] comps, OneOffEntry[] oneOffs, OPatchSDK.OracleHome[] oracleHomes) {
        LsInventoryToXML.createXML(oracleHomePath, outStream);
    }

    public static void createXML(String oracleHomePath, OutputStream outStream) {
        Class[] allClasses = new Class[]{Patch.class, OUIComponent.class, InventoryInstance.class};
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])allClasses);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        InventoryInstance instance = new InventoryInstance(oracleHomePath);
        try {
            Marshaller marshall = context.createMarshaller();
            marshall.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            marshall.marshal((Object)new JAXBElement(new QName("InventoryInstance"), instance.getClass(), (Object)instance), outStream);
        }
        catch (Throwable tt) {
            System.out.println(" Failed to marshal to xml: " + tt.getMessage());
            tt.printStackTrace();
        }
    }

    public static void writeFile(InventoryWrapper iw, String fileName) throws IOException {
        OutputStream fos = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]), new OpenOption[0]);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        XMLEncoder xmlEncoder = new XMLEncoder(bos);
        xmlEncoder.writeObject(iw);
        xmlEncoder.close();
    }

    protected static void commitXML() {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
        }
        catch (TransformerConfigurationException e2) {
            OLogger.printStackTrace(e2);
            LsInventoryToXML.error("problem in trying to commit to the xml file specified");
        }
        StreamResult output1 = new StreamResult(foutObject);
        try {
            transformer.transform(source, output1);
        }
        catch (TransformerException e3) {
            OLogger.printStackTrace(e3);
            LsInventoryToXML.error("problem in trying to commit to the xml file specified");
        }
        catch (RuntimeException e4) {
            OLogger.printStackTrace(e4);
        }
    }

    protected static void buildComponents(Element homeElement) {
        Element compsElement = docObj.createElement("COMPS");
        homeElement.appendChild(compsElement);
        stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
        Text txt = docObj.createTextNode((String)stackIndent.peek());
        compsElement.appendChild(txt);
        InstalledComponent[] comps = INSTALLED_COMPONENTS;
        String compIntName = "";
        String compExtName = "";
        String desc = "";
        boolean isTopLevel = false;
        String topLevelDesc = "false";
        String[] versions = new String[]{"1.0", "1.1"};
        InstalledComponent[] mergedComps = InstalledComponent.mergeComponents(comps);
        int len = mergedComps.length;
        for (int i2 = 0; i2 < len; ++i2) {
            InstalledComponent ic = mergedComps[i2];
            if (ic != null) {
                compIntName = ic.getID();
                compExtName = ic.getName();
                desc = ic.getDesc();
                isTopLevel = ic.isTopLevel();
                topLevelDesc = ic.getTopLevelDesc();
                versions = ic.getVersions();
                Element compElement = docObj.createElement("COMP");
                compElement.setAttribute("INT_NAME", compIntName);
                compElement.setAttribute("EXT_NAME", compExtName);
                compElement.setAttribute("DESC", desc);
                compElement.setAttribute("TOP_LEVEL", topLevelDesc);
                compsElement.appendChild(compElement);
                int versionsLen = versions != null ? versions.length : 0;
                stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
                txt = docObj.createTextNode((String)stackIndent.peek());
                compElement.appendChild(txt);
                for (int j2 = 0; j2 < versionsLen; ++j2) {
                    String version = versions[j2];
                    Element versionElement = docObj.createElement("VERSION");
                    txt = docObj.createTextNode(version);
                    versionElement.appendChild(txt);
                    compElement.appendChild(versionElement);
                    if (j2 == versionsLen - 1) continue;
                    txt = docObj.createTextNode((String)stackIndent.peek());
                    compElement.appendChild(txt);
                }
                --indentValue;
                stackIndent.pop();
                txt = docObj.createTextNode((String)stackIndent.peek());
                compElement.appendChild(txt);
            }
            if (i2 == len - 1) continue;
            txt = docObj.createTextNode((String)stackIndent.peek());
            compsElement.appendChild(txt);
        }
        --indentValue;
        stackIndent.pop();
        txt = docObj.createTextNode((String)stackIndent.peek());
        compsElement.appendChild(txt);
        txt = docObj.createTextNode((String)stackIndent.peek());
        homeElement.appendChild(txt);
    }

    protected static void parseLsInvXML_all() {
        LsInventoryToXML.buildOPatchHeader();
        Element hostElement = LsInventoryToXML.buildHost();
        for (int i2 = 0; i2 < ORACLE_HOME_LIST.length; ++i2) {
            OPatchSDK.OracleHome oracleHome = ORACLE_HOME_LIST[i2];
            String homeName = oracleHome.getName();
            String homePath = oracleHome.getLocation();
            Element homeElement = docObj.createElement("HOME");
            hostElement.appendChild(homeElement);
            homeElement.setAttribute("NAME", homeName);
            homeElement.setAttribute("LOC", homePath);
            if (i2 == ORACLE_HOME_LIST.length - 1) continue;
            Text txt = docObj.createTextNode((String)stackIndent.peek());
            hostElement.appendChild(txt);
        }
        --indentValue;
        stackIndent.pop();
        Text txt = docObj.createTextNode((String)stackIndent.peek());
        hostElement.appendChild(txt);
        txt = docObj.createTextNode("\n");
        commonRoot.appendChild(txt);
    }

    private static void doSanityCheck(OutputStream fout) {
        if (fout == null) {
            fout = System.out;
        }
        foutObject = fout;
        stackIndent = new Stack();
        LsInventoryToXML.initDOMParserInformation();
    }

    private static void initDOMParserInformation() {
        factoryObj = DocumentBuilderFactory.newInstance();
        if (factoryObj == null) {
            LsInventoryToXML.error("cannot output to xml file as the factory object is null");
        }
        try {
            builderObj = factoryObj.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            LsInventoryToXML.error("Parser configuration error " + e2.getMessage());
        }
        try {
            docObj = builderObj.newDocument();
        }
        catch (Exception e3) {
            LsInventoryToXML.error("Unable to build the document object " + e3.getMessage());
        }
    }

    private static Node buildOneOff(String oracleHomePath, OneOffEntry oneOff, Element oneOffListElem) throws RuntimeException {
        Element patchStart;
        String patchID = oneOff.getID();
        String patchLocation = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchID);
        String rollbackable = oneOff.getRollbackableDesc();
        Date appliedDate = oneOff != null ? oneOff.getAppliedDate() : new Date();
        String appliedTime = appliedDate.toString();
        PatchObject po = null;
        try {
            po = PatchObject.getInstance(oracleHomePath, patchID);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
        catch (Exception e3) {
            throw new RuntimeException(e3.getMessage(), e3);
        }
        Element e4 = patchStart = docObj.createElement("INTERIM_PATCH".toUpperCase());
        e4.setAttribute("REF_ID", patchID);
        e4.setAttribute("ROLLBACKABLE", rollbackable);
        e4.setAttribute("APPLIED_TIME", appliedTime);
        oneOffListElem.appendChild(patchStart);
        stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
        Text txt = docObj.createTextNode((String)stackIndent.peek());
        patchStart.appendChild(txt);
        LsInventoryToXML.buildPatchInventory(po, patchStart);
        LsInventoryToXML.buildActions(po, patchStart);
        --indentValue;
        stackIndent.pop();
        txt = docObj.createTextNode((String)stackIndent.peek());
        patchStart.appendChild(txt);
        return patchStart;
    }

    private static void buildActions(PatchObject po, Node patchStart) {
        Text txt = null;
        Node actionsXMLElement = null;
        Document actionsXML = null;
        Element actionNode = docObj.createElement("oneoff_actions");
        patchStart.appendChild(actionNode);
        PatchComponent[] patchComps = po.getPatchComponents();
        if (patchComps.length != 0) {
            stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
        }
        for (int i2 = 0; i2 < patchComps.length; ++i2) {
            txt = docObj.createTextNode((String)stackIndent.peek());
            actionNode.appendChild(txt);
            PatchComponent pc = patchComps[i2];
            String compName = pc.getName();
            String compVer = pc.getVersion();
            String optStr = pc.getRequiredOrOptionalDesc();
            Element compNode = docObj.createElement("COMP");
            actionNode.appendChild(compNode);
            Element e2 = compNode;
            e2.setAttribute("INT_NAME", compName);
            e2.setAttribute("VERSION", compVer);
            e2.setAttribute("opt_req", optStr);
            stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
            txt = docObj.createTextNode((String)stackIndent.peek());
            compNode.appendChild(txt);
            PatchAction[] patchActs = po.getPatchActionsForComponent(pc);
            for (int j2 = 0; j2 < patchActs.length; ++j2) {
                PatchAction pa = patchActs[j2];
                StringReader actionsReader = new StringReader(pa.getRawActionEntry());
                try {
                    DocumentBuilder actionBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    actionsXML = actionBuilder.parse(new InputSource(actionsReader));
                }
                catch (Exception excep) {
                    LsInventoryToXML.error("cannot parse action xml strings\n" + excep);
                }
                try {
                    actionsXMLElement = docObj.importNode(actionsXML.getDocumentElement(), true);
                }
                catch (DOMException excep) {
                    LsInventoryToXML.error("cannot import action node to the main XML tree\n" + excep);
                }
                compNode.appendChild(actionsXMLElement);
                if (j2 == patchActs.length - 1) {
                    --indentValue;
                    stackIndent.pop();
                }
                txt = docObj.createTextNode((String)stackIndent.peek());
                compNode.appendChild(txt);
            }
            if (i2 == patchComps.length - 1) {
                --indentValue;
                stackIndent.pop();
            }
            txt = docObj.createTextNode((String)stackIndent.peek());
            actionNode.appendChild(txt);
        }
    }

    private static void buildPatchInventory(PatchObject po, Node patchStart) {
        Element xmlPatchId;
        String patchID = po.getPatchID();
        String patchIdentifier = po.getPatchInventory().getPSENumber();
        String year = po.getCreationYear();
        String month = po.getCreationMonth();
        String day = po.getCreationDay();
        String time = po.getCreationTime();
        String zone = po.getCreationZone();
        String pType = po.getPatchType();
        String pFamily = po.getProductFamily();
        boolean isMiniPatchset = po.getPatchInventory().isMiniPatchSet();
        Element startInventory = docObj.createElement("oneoff_inventory");
        patchStart.appendChild(startInventory);
        stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
        Text txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        Element e2 = xmlPatchId = docObj.createElement("reference_id");
        e2.setAttribute("number", patchID);
        startInventory.appendChild(xmlPatchId);
        if (patchIdentifier != null && !patchIdentifier.equals("")) {
            txt = docObj.createTextNode((String)stackIndent.peek());
            startInventory.appendChild(txt);
            Element xmlPatchIdentifier = docObj.createElement("unique_patch_id");
            txt = docObj.createTextNode(patchIdentifier);
            startInventory.appendChild(xmlPatchIdentifier);
            xmlPatchIdentifier.appendChild(txt);
        }
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        Element patchType = docObj.createElement("patch_type");
        startInventory.appendChild(patchType);
        e2 = patchType;
        e2.setAttribute("value", pType);
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        Element productFamily = docObj.createElement("product_family");
        startInventory.appendChild(productFamily);
        e2 = productFamily;
        e2.setAttribute("value", pFamily);
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        Element xmlPatchInfo = docObj.createElement("date_of_patch");
        startInventory.appendChild(xmlPatchInfo);
        e2 = xmlPatchInfo;
        e2.setAttribute("year", year);
        e2.setAttribute("month", month);
        e2.setAttribute("day", day);
        e2.setAttribute("time", time);
        e2.setAttribute("zone", zone);
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        Element bugInfo = docObj.createElement("base_bugs");
        startInventory.appendChild(bugInfo);
        stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
        txt = docObj.createTextNode((String)stackIndent.peek());
        bugInfo.appendChild(txt);
        Bug[] bugs = po.getBugsToFix();
        for (int i2 = 0; i2 < bugs.length; ++i2) {
            Element bugDetail;
            Bug bug = bugs[i2];
            String bugID = bug.getBugID();
            String bugDesc = bug.getDesc();
            e2 = bugDetail = docObj.createElement("bug");
            e2.setAttribute("number", bugID);
            e2.setAttribute("description", bugDesc);
            bugInfo.appendChild(bugDetail);
            if (i2 >= bugs.length - 1) continue;
            txt = docObj.createTextNode((String)stackIndent.peek());
            bugInfo.appendChild(txt);
        }
        --indentValue;
        stackIndent.pop();
        txt = docObj.createTextNode((String)stackIndent.peek());
        bugInfo.appendChild(txt);
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        ArrayList productList = po.getProductsList();
        Element products = docObj.createElement("products");
        startInventory.appendChild(products);
        if (productList != null && productList.size() != 0) {
            stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
            txt = docObj.createTextNode((String)stackIndent.peek());
            products.appendChild(txt);
            for (int i3 = 0; i3 < productList.size(); ++i3) {
                Element product1 = docObj.createElement("product");
                products.appendChild(product1);
                stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
                txt = docObj.createTextNode((String)stackIndent.peek());
                product1.appendChild(txt);
                PatchInventory.NameVersionPair nv = (PatchInventory.NameVersionPair)productList.get(i3);
                String p2 = nv.getName();
                Element pName = docObj.createElement("name");
                product1.appendChild(pName);
                e2 = pName;
                e2.setAttribute("value", p2);
                txt = docObj.createTextNode((String)stackIndent.peek());
                product1.appendChild(txt);
                ArrayList arrayVer = nv.getVersions();
                for (int j2 = 0; j2 < arrayVer.size(); ++j2) {
                    String v = (String)arrayVer.get(j2);
                    Element vName = docObj.createElement("version");
                    product1.appendChild(vName);
                    e2 = vName;
                    e2.setAttribute("value", v);
                    if (j2 >= arrayVer.size() - 1) continue;
                    txt = docObj.createTextNode((String)stackIndent.peek());
                    product1.appendChild(txt);
                }
                --indentValue;
                stackIndent.pop();
                txt = docObj.createTextNode((String)stackIndent.peek());
                product1.appendChild(txt);
                if (i3 == productList.size() - 1) continue;
                txt = docObj.createTextNode((String)stackIndent.peek());
                products.appendChild(txt);
            }
            --indentValue;
            stackIndent.pop();
            txt = docObj.createTextNode((String)stackIndent.peek());
            products.appendChild(txt);
            txt = docObj.createTextNode((String)stackIndent.peek());
            startInventory.appendChild(txt);
        } else {
            txt = docObj.createTextNode((String)stackIndent.peek());
            startInventory.appendChild(txt);
        }
        Element patchApplicable = docObj.createElement("applicable_product");
        startInventory.appendChild(patchApplicable);
        e2 = patchApplicable;
        e2.setAttribute("value", po.getProductType());
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        Element reqCompsElement = docObj.createElement("required_components");
        startInventory.appendChild(reqCompsElement);
        stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
        txt = docObj.createTextNode((String)stackIndent.peek());
        reqCompsElement.appendChild(txt);
        PatchComponent[] comps = po.getPatchComponents();
        for (int i4 = 0; i4 < comps.length; ++i4) {
            PatchComponent pc = comps[i4];
            String name = pc.getName();
            String ver = pc.getVersion();
            String req = pc.getRequiredOrOptionalDesc();
            Element compElement = docObj.createElement("COMP");
            compElement.setAttribute("internal_name", name);
            compElement.setAttribute("VERSION", ver);
            compElement.setAttribute("opt_req", req);
            reqCompsElement.appendChild(compElement);
            if (i4 == comps.length - 1) continue;
            txt = docObj.createTextNode((String)stackIndent.peek());
            reqCompsElement.appendChild(txt);
        }
        --indentValue;
        stackIndent.pop();
        txt = docObj.createTextNode((String)stackIndent.peek());
        reqCompsElement.appendChild(txt);
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        if (isMiniPatchset) {
            ArrayList uc = po.getPatchInventory().getUpdateCompsList();
            Element updateComps = docObj.createElement("update_components");
            startInventory.appendChild(updateComps);
            stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
            txt = docObj.createTextNode((String)stackIndent.peek());
            updateComps.appendChild(txt);
            for (int i5 = 0; uc != null && i5 < uc.size(); ++i5) {
                UpdateComponent updateComp = (UpdateComponent)uc.get(i5);
                String updateCompName = updateComp.getCompName();
                String fromVersion = updateComp.getFromVersion();
                String toVersion = updateComp.getToVersion();
                boolean isRequired = updateComp.isRequired();
                String req = updateComp.getReqOptString();
                Element updateCompElement = docObj.createElement("update");
                updateCompElement.setAttribute("internal_name", updateCompName);
                updateCompElement.setAttribute("from_version", fromVersion);
                updateCompElement.setAttribute("to_version", toVersion);
                updateCompElement.setAttribute("opt_req", req);
                updateComps.appendChild(updateCompElement);
                if (i5 == uc.size() - 1) continue;
                txt = docObj.createTextNode((String)stackIndent.peek());
                updateComps.appendChild(txt);
            }
            --indentValue;
            stackIndent.pop();
            txt = docObj.createTextNode((String)stackIndent.peek());
            updateComps.appendChild(txt);
        }
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        Element platformNode = docObj.createElement("os_platforms");
        startInventory.appendChild(platformNode);
        Platform[] platforms = po.getPlatforms();
        if (platforms.length != 0) {
            stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
            txt = docObj.createTextNode((String)stackIndent.peek());
            platformNode.appendChild(txt);
        }
        for (int i6 = 0; i6 < platforms.length; ++i6) {
            Element platformDetail;
            Platform p3 = platforms[i6];
            String name = p3.getID();
            String desc = p3.getDesc();
            e2 = platformDetail = docObj.createElement("platform");
            e2.setAttribute("name", name);
            e2.setAttribute("id", desc);
            platformNode.appendChild(platformDetail);
            if (i6 == platforms.length - 1) {
                --indentValue;
                stackIndent.pop();
            }
            txt = docObj.createTextNode((String)stackIndent.peek());
            platformNode.appendChild(txt);
        }
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        Element executables = docObj.createElement("executables");
        startInventory.appendChild(executables);
        String[] exes = po.getExecutables();
        if (exes.length != 0) {
            stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
            txt = docObj.createTextNode((String)stackIndent.peek());
            executables.appendChild(txt);
        }
        for (int i7 = 0; i7 < exes.length; ++i7) {
            Element executable;
            String path = exes[i7];
            e2 = executable = docObj.createElement("executable");
            e2.setAttribute("path", path);
            executables.appendChild(executable);
            if (i7 == exes.length - 1) {
                --indentValue;
                stackIndent.pop();
            }
            txt = docObj.createTextNode((String)stackIndent.peek());
            executables.appendChild(txt);
        }
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        String shutdown = po.getShutdownString();
        Element instShutDown = docObj.createElement("instance_shutdown");
        startInventory.appendChild(instShutDown);
        txt = docObj.createTextNode(shutdown);
        instShutDown.appendChild(txt);
        --indentValue;
        stackIndent.pop();
        txt = docObj.createTextNode((String)stackIndent.peek());
        startInventory.appendChild(txt);
        txt = docObj.createTextNode((String)stackIndent.peek());
        patchStart.appendChild(txt);
    }

    protected static void parseLsInvXML() {
        Text txt = null;
        LsInventoryToXML.buildOPatchHeader();
        Element hostElement = LsInventoryToXML.buildHost();
        Element homeElement = LsInventoryToXML.buildHome(hostElement);
        LsInventoryToXML.buildComponents(homeElement);
        int len = ONE_OFF_ENTRIES.length;
        Element oneOffListElem = docObj.createElement("ONEOFF_LIST");
        homeElement.appendChild(oneOffListElem);
        if (len > 0) {
            stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
            txt = docObj.createTextNode((String)stackIndent.peek());
            oneOffListElem.appendChild(txt);
            for (int i2 = 0; i2 < len; ++i2) {
                OneOffEntry oneOff = ONE_OFF_ENTRIES[i2];
                Node oneOffElem = LsInventoryToXML.buildOneOff(ORACLE_HOME_PATH, oneOff, oneOffListElem);
                oneOffListElem.appendChild(oneOffElem);
                if (i2 == len - 1) continue;
                txt = docObj.createTextNode((String)stackIndent.peek());
                oneOffListElem.appendChild(txt);
            }
            --indentValue;
            stackIndent.pop();
            txt = docObj.createTextNode((String)stackIndent.peek());
            oneOffListElem.appendChild(txt);
        }
        --indentValue;
        stackIndent.pop();
        txt = docObj.createTextNode((String)stackIndent.peek());
        homeElement.appendChild(txt);
        --indentValue;
        stackIndent.pop();
        txt = docObj.createTextNode((String)stackIndent.peek());
        hostElement.appendChild(txt);
        txt = docObj.createTextNode("\n");
        commonRoot.appendChild(txt);
    }

    protected static void buildOPatchHeader() {
        stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
        Text txt = docObj.createTextNode(indent);
        commonRoot.appendChild(txt);
        Element headerChild = docObj.createElement("HEADER");
        commonRoot.appendChild(headerChild);
        stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
        txt = docObj.createTextNode((String)stackIndent.peek());
        headerChild.appendChild(txt);
        Element ohChild = docObj.createElement("ORACLE_HOME");
        headerChild.appendChild(ohChild);
        txt = docObj.createTextNode(OPatchEnv.hOracleHome);
        ohChild.appendChild(txt);
        txt = docObj.createTextNode((String)stackIndent.peek());
        headerChild.appendChild(txt);
        Element cInvChild = docObj.createElement("CENTRAL_INVENTORY");
        headerChild.appendChild(cInvChild);
        txt = docObj.createTextNode(OPatchEnv.hCentralInv);
        cInvChild.appendChild(txt);
        txt = docObj.createTextNode((String)stackIndent.peek());
        headerChild.appendChild(txt);
        Element opatchVersionChild = docObj.createElement("OPATCH_VERSION");
        headerChild.appendChild(opatchVersionChild);
        txt = docObj.createTextNode(OPatchEnv.hOPatchVer);
        opatchVersionChild.appendChild(txt);
        txt = docObj.createTextNode((String)stackIndent.peek());
        headerChild.appendChild(txt);
        Element ouiVersionChild = docObj.createElement("OUI_VERSION");
        headerChild.appendChild(ouiVersionChild);
        txt = docObj.createTextNode(OPatchEnv.hOUIVer);
        ouiVersionChild.appendChild(txt);
        txt = docObj.createTextNode((String)stackIndent.peek());
        headerChild.appendChild(txt);
        Element ouiLocationChild = docObj.createElement("OUI_LOCATION");
        headerChild.appendChild(ouiLocationChild);
        txt = docObj.createTextNode(OPatchEnv.hOUILoc);
        ouiLocationChild.appendChild(txt);
        txt = docObj.createTextNode((String)stackIndent.peek());
        headerChild.appendChild(txt);
        Element logLocationChild = docObj.createElement("LOG");
        headerChild.appendChild(logLocationChild);
        txt = docObj.createTextNode(OPatchEnv.hLogLoc);
        logLocationChild.appendChild(txt);
        stackIndent.pop();
        --indentValue;
        txt = docObj.createTextNode((String)stackIndent.peek());
        headerChild.appendChild(txt);
        txt = docObj.createTextNode((String)stackIndent.peek());
        commonRoot.appendChild(txt);
    }

    protected static Element buildHost() {
        Element host = docObj.createElement("HOST");
        commonRoot.appendChild(host);
        stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
        Text txt = docObj.createTextNode((String)stackIndent.peek());
        host.appendChild(txt);
        return host;
    }

    protected static Element buildHome(Element host) {
        int nodesLen;
        Element home = docObj.createElement("HOME");
        String isCRS = CRS ? "T" : "F";
        home.setAttribute("NAME", ORACLE_HOME_NAME);
        home.setAttribute("LOC", ORACLE_HOME_PATH);
        home.setAttribute("CRS", isCRS);
        host.appendChild(home);
        stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
        Text txt = docObj.createTextNode((String)stackIndent.peek());
        home.appendChild(txt);
        Element nodeList = docObj.createElement("NODE_LIST");
        home.appendChild(nodeList);
        int n2 = nodesLen = NODE_LIST != null ? NODE_LIST.length : 0;
        if (nodesLen > 0) {
            stackIndent.push(LsInventoryToXML.getIndentString(++indentValue));
            txt = docObj.createTextNode((String)stackIndent.peek());
            nodeList.appendChild(txt);
            for (int i2 = 0; i2 < nodesLen; ++i2) {
                String node = NODE_LIST[i2];
                Element nodeElem = null;
                if (i2 == 0) {
                    nodeElem = docObj.createElement("LOCAL_NODE");
                    node = LOCAL_NODE;
                } else {
                    nodeElem = docObj.createElement("NODE");
                }
                nodeElem.setAttribute("NAME", node);
                nodeList.appendChild(nodeElem);
                if (i2 == nodesLen - 1) continue;
                txt = docObj.createTextNode((String)stackIndent.peek());
                nodeList.appendChild(txt);
            }
            stackIndent.pop();
            --indentValue;
            txt = docObj.createTextNode((String)stackIndent.peek());
            nodeList.appendChild(txt);
            txt = docObj.createTextNode((String)stackIndent.peek());
            home.appendChild(txt);
        } else {
            txt = docObj.createTextNode((String)stackIndent.peek());
            home.appendChild(txt);
        }
        if (OPatchEnv.isLsinv_all()) {
            txt = docObj.createTextNode((String)stackIndent.peek());
            host.appendChild(txt);
        }
        return home;
    }

    private static void initData(String oracleHomeName, String oracleHomePath, boolean crs, String localNode, String[] nodeList, InstalledComponent[] comps, OneOffEntry[] oneOffs, OPatchSDK.OracleHome[] oracleHomes) {
        int i2;
        if (oracleHomeName != null) {
            ORACLE_HOME_NAME = oracleHomeName;
        }
        if (oracleHomePath != null) {
            ORACLE_HOME_PATH = oracleHomePath;
        }
        CRS = crs;
        if (localNode != null) {
            LOCAL_NODE = localNode;
        }
        if (nodeList != null && nodeList.length > 1) {
            NODE_LIST = new String[nodeList.length - 1];
            for (i2 = 1; i2 < nodeList.length; ++i2) {
                LsInventoryToXML.NODE_LIST[i2 - 1] = nodeList[i2];
            }
        }
        if (comps != null) {
            INSTALLED_COMPONENTS = new InstalledComponent[comps.length];
            for (i2 = 0; i2 < comps.length; ++i2) {
                InstalledComponent comp;
                LsInventoryToXML.INSTALLED_COMPONENTS[i2] = comp = comps[i2];
            }
        }
        if (oneOffs != null) {
            ONE_OFF_ENTRIES = new OneOffEntry[oneOffs.length];
            for (i2 = 0; i2 < oneOffs.length; ++i2) {
                OneOffEntry entry;
                LsInventoryToXML.ONE_OFF_ENTRIES[i2] = entry = oneOffs[i2];
            }
        }
        if (oracleHomes != null) {
            ORACLE_HOME_LIST = oracleHomes;
        }
    }
}

