/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import oracle.opatch.IOPatchSession;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.cas.BranchInfo;
import oracle.opatch.cas.FailureType;
import oracle.opatch.cas.OPatchCASException;
import oracle.opatch.cas.TagUIInfo;
import oracle.opatch.cas.client.CASClientFactory;
import oracle.opatch.opatchlogger.OLogger;

public class ListSession
implements IOPatchSession {
    private boolean hasOUI = false;

    @Override
    public boolean isOUIBased() {
        return this.hasOUI;
    }

    @Override
    public void process(String oracleHome) {
        if (OPatchEnv.isHelp()) {
            if (this.helpPresent()) {
                this.displayHelp();
            }
            return;
        }
        OLogger.printlnOnLog(MessageFormat.format("ListSession process on cas_repo \"{0}\". ", oracleHome));
        try {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<Path> values = new ArrayList<Path>();
            LinkedList<Object> branchInfo = new LinkedList();
            LinkedList<Object> tagUIInfo = new LinkedList();
            LinkedList<BranchInfo> branchList = new LinkedList<BranchInfo>();
            LinkedList<BranchInfo> viewList = new LinkedList<BranchInfo>();
            String masterKey = "master";
            OPatchOverCAS.INSTANCE.initializeCAS(oracleHome);
            branchInfo = CASClientFactory.getCASClient().listBranch(keys, values);
            boolean i2 = false;
            StringBuffer buff = new StringBuffer("View information:\n");
            buff.append("----------------------------------------------------------------\n");
            for (BranchInfo branchInfo2 : branchInfo) {
                String key = branchInfo2.getBranchKey();
                if (key.equals("CLI") || key.equals("SDK")) continue;
                if (!key.equals(masterKey)) {
                    if (OPatchEnv.getCasViewId() != null && key.equals(OPatchEnv.getCasViewId())) {
                        viewList.add(branchInfo2);
                    }
                    if (OPatchEnv.getCasTagId() != null && branchInfo2.getTagKey().equals(OPatchEnv.getCasTagId())) {
                        viewList.add(branchInfo2);
                    }
                }
                if (OPatchEnv.getCasTagId() != null || OPatchEnv.getCasViewId() != null) continue;
                if (key.equals(masterKey)) {
                    branchList.add(branchInfo2);
                    continue;
                }
                viewList.add(branchInfo2);
            }
            for (BranchInfo branchInfo3 : branchList) {
                buff.append(branchInfo3.toString() + "\n");
                if (!masterKey.equals(branchInfo3.getBranchKey())) continue;
                tagUIInfo = CASClientFactory.getCASClient().listTagsFromBranch(masterKey);
                for (TagUIInfo tagUIInfo2 : tagUIInfo) {
                    buff.append(tagUIInfo2.toString() + "\n");
                }
            }
            for (BranchInfo branchInfo4 : viewList) {
                buff.append(branchInfo4.toString() + "\n");
            }
            OLogger.print(buff.toString());
        }
        catch (OPatchCASException t) {
            if (t.getFailureType() == FailureType.NO_OP_EXCEPTION) {
                return;
            }
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
    }

    public boolean helpPresent() {
        return true;
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "lsviews_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.log(OLogger.INFO, helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

