/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.JarActionEntity;
import oracle.opatch.JarActionEntityTree;
import oracle.opatch.MultiJarUtil;
import oracle.opatch.OPatchEnv;
import oracle.opatch.Rules;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.DeltaFileProcessor;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.wrappers.WrapperFactory;

public class JarActionHelper {
    protected static Map<DeleteJarAction, Boolean> isRequiredCacheForApply;
    protected static Map<DeleteJarAction, String> isRequiredDescCacheForApply;
    protected static Map<DeleteJarAction, Boolean> isRequiredCacheForRollback;
    protected static Map<DeleteJarAction, String> isRequiredDescCacheForRollback;

    protected static HashMap apply(String oracleHomePath, String patchLocation, JarActionEntity jarActionEntity) {
        int i2;
        StringBuffer buff = new StringBuffer("JarActionHelper::apply() called");
        OLogger.debug(buff.toString());
        JarActionEntityTree.TreeNode root = JarActionEntityTree.getRoot();
        HashMap<String, JarActionEntity> failedMap = new HashMap<String, JarActionEntity>();
        ArrayList failed = new ArrayList();
        if (root == null || root.isLeaf()) {
            buff = new StringBuffer("The jar action tree has not been contructed.");
            OLogger.debug(buff);
            return failedMap;
        }
        boolean cont = Rules.SystemWrite_continue();
        ArrayList topLevelJars = root.getChilds();
        if (topLevelJars == null) {
            return failedMap;
        }
        for (i2 = 0; i2 < topLevelJars.size(); ++i2) {
            JarActionEntityTree.TreeNode patchingNode;
            JarActionEntityTree.TreeNode tn = (JarActionEntityTree.TreeNode)topLevelJars.get(i2);
            String jarName = tn.getJarName();
            String jarPath = tn.getJarPath();
            String patchingJarFilePath = JarActionHelper.getTopLevelJarFilePath(oracleHomePath, jarPath, jarName);
            String curJarPath = jarActionEntity.getJarPath();
            if (!curJarPath.startsWith(File.separator)) {
                curJarPath = File.separator + curJarPath;
            }
            if (!(patchingNode = new JarActionEntityTree.TreeNode(0, jarActionEntity.getRootJarName(), curJarPath, null)).equals(tn)) continue;
            try {
                Path srcJar = WrapperFactory.getNioServiceWrapper().getPath(patchingJarFilePath, new String[0]);
                if (!Files.exists(srcJar, new LinkOption[0])) {
                    buff = new StringBuffer("apply() failed. Parent file not exist: \"");
                    buff.append(patchingJarFilePath);
                    buff.append("\"");
                    OLogger.printlnOnLog(buff.toString());
                    throw new IOException(buff.toString());
                }
                String scratchLocation = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID());
                String dstJarFile = MultiJarUtil.patchingBaseOnJarTree(tn, patchingJarFilePath, scratchLocation, patchLocation, "", patchingJarFilePath, failed);
                if (cont) {
                    Path patchedJar = WrapperFactory.getNioServiceWrapper().getPath(dstJarFile, new String[0]);
                    if (!Files.exists(patchedJar, new LinkOption[0])) {
                        buff = new StringBuffer("apply() failed. Applied jar file not be produced: \"");
                        buff.append(dstJarFile);
                        buff.append("\"");
                        OLogger.printlnOnLog(buff.toString());
                        throw new IOException(buff.toString());
                    }
                    if (!failed.isEmpty()) {
                        buff = new StringBuffer("apply() failed. Some of the clubbed jar actions have failed");
                        OLogger.printlnOnLog(buff.toString());
                    } else {
                        buff = new StringBuffer("Copy applied Jar file from \"");
                        buff.append(dstJarFile);
                        buff.append("\" to \"" + patchingJarFilePath + "\"");
                        OLogger.debug(buff.toString());
                        MultiJarUtil.copyFile(dstJarFile, patchingJarFilePath, true);
                    }
                } else {
                    buff = new StringBuffer("Skipping the Jar Action Apply due to no sys_mod");
                    OLogger.debug(buff);
                }
                DeltaFileProcessor deltaFileProcessor = OUSession.getDeltaFileProcessor();
                deltaFileProcessor.addNApplyDeltaFiles(patchingJarFilePath, jarActionEntity);
            }
            catch (Exception e2) {
                buff = new StringBuffer("Apply for Jar file \"ORACLE_HOME" + File.separator);
                buff.append(tn.getEntryName());
                buff.append("\" failed");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                MultiJarUtil.getAllLeavesForNode(tn, failed, MultiJarUtil.JarOperation.APPLY, true, e2.getMessage());
            }
            break;
        }
        for (i2 = 0; i2 < failed.size(); ++i2) {
            JarActionEntity ja = (JarActionEntity)failed.get(i2);
            failedMap.put(ja.getClassName(), ja);
        }
        return failedMap;
    }

    protected static HashMap rollback(String oracleHomePath, String cookedPatchID, JarActionEntity jarActionEntity) {
        int i2;
        StringBuffer buff = new StringBuffer("JarActionHelper::rollback() called");
        OLogger.debug(buff.toString());
        HashMap<String, JarActionEntity> failedMap = new HashMap<String, JarActionEntity>();
        ArrayList failed = new ArrayList();
        JarActionEntityTree.TreeNode root = JarActionEntityTree.getRoot();
        if (root == null || root.isLeaf()) {
            return failedMap;
        }
        boolean cont = Rules.SystemWrite_continue();
        ArrayList topLevelJars = root.getChilds();
        for (i2 = 0; i2 < topLevelJars.size(); ++i2) {
            JarActionEntityTree.TreeNode rollbackNode;
            JarActionEntityTree.TreeNode tn = (JarActionEntityTree.TreeNode)topLevelJars.get(i2);
            String jarName = tn.getJarName();
            String jarPath = tn.getJarPath();
            String patchingJarFilePath = JarActionHelper.getTopLevelJarFilePath(oracleHomePath, jarPath, jarName);
            String curJarPath = jarActionEntity.getJarPath();
            if (!curJarPath.startsWith(File.separator)) {
                curJarPath = File.separator + curJarPath;
            }
            if (!(rollbackNode = new JarActionEntityTree.TreeNode(0, jarActionEntity.getRootJarName(), curJarPath, null)).equals(tn)) continue;
            try {
                Path srcJar = WrapperFactory.getNioServiceWrapper().getPath(patchingJarFilePath, new String[0]);
                if (!Files.exists(srcJar, new LinkOption[0])) {
                    buff = new StringBuffer("rollback() failed. Parent file not exist: \"");
                    buff.append(patchingJarFilePath);
                    buff.append("\"");
                    OLogger.printlnOnLog(buff.toString());
                    throw new IOException(buff.toString());
                }
                String scratchLocation = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, cookedPatchID);
                String backForRollBackPath = OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID);
                String rollbackedJar = MultiJarUtil.rollbackBaseOnJarTree(tn, patchingJarFilePath, scratchLocation, backForRollBackPath, "", failed);
                if (cont) {
                    Path patchedJar = WrapperFactory.getNioServiceWrapper().getPath(rollbackedJar, new String[0]);
                    if (!Files.exists(patchedJar, new LinkOption[0])) {
                        buff = new StringBuffer("rollback() failed. Rollbacked Jar file not be produced: \"");
                        buff.append(rollbackedJar);
                        buff.append("\"");
                        OLogger.printlnOnLog(buff.toString());
                        throw new IOException(buff.toString());
                    }
                    if (!failed.isEmpty()) {
                        buff = new StringBuffer("rollback() failed. Some of the clubbed jar actions have failed");
                        OLogger.printlnOnLog(buff.toString());
                    } else {
                        buff = new StringBuffer("Copy rollbacked Jar file from \"");
                        buff.append(rollbackedJar);
                        buff.append("\" to \"" + patchingJarFilePath + "\"");
                        OLogger.debug(buff.toString());
                        MultiJarUtil.copyFile(rollbackedJar, patchingJarFilePath, true);
                    }
                } else {
                    buff = new StringBuffer("Skipping the Jar Action Rollback due to no sys_mod");
                    OLogger.debug(buff);
                }
                DeltaFileProcessor deltaFileProcessor = OUSession.getDeltaFileProcessor();
                deltaFileProcessor.addNRollbackDeltaFiles(patchingJarFilePath, jarActionEntity);
            }
            catch (Exception e2) {
                buff = new StringBuffer("Rollback for Jar file \"ORACLE_HOME" + File.separator);
                buff.append(tn.getEntryName());
                buff.append("\" failed");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                MultiJarUtil.getAllLeavesForNode(tn, failed, MultiJarUtil.JarOperation.ROLLBACK, true, e2.getMessage());
            }
            break;
        }
        for (i2 = 0; i2 < failed.size(); ++i2) {
            JarActionEntity ja = (JarActionEntity)failed.get(i2);
            failedMap.put(ja.getClassName(), ja);
        }
        return failedMap;
    }

    protected static HashMap verify(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("JarActionHelper::verify() called");
        OLogger.debug(buff.toString());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        JarActionEntityTree.TreeNode root = JarActionEntityTree.getRoot();
        if (root == null || root.isLeaf()) {
            buff = new StringBuffer("The jar action tree has not been contructed.");
            OLogger.debug(buff);
            return result;
        }
        MultiJarUtil.clearEntryExistFlagRecursively(root);
        ArrayList topLevelJars = root.getChilds();
        for (int i2 = 0; i2 < topLevelJars.size(); ++i2) {
            JarActionEntityTree.TreeNode tn = (JarActionEntityTree.TreeNode)topLevelJars.get(i2);
            try {
                String jarName = tn.getJarName();
                String jarPath = tn.getJarPath();
                String patchingJarFilePath = JarActionHelper.getTopLevelJarFilePath(oracleHomePath, jarPath, jarName);
                buff = new StringBuffer("Verify clubbed jar actions for target jar file \"");
                buff.append(patchingJarFilePath);
                buff.append("\"");
                OLogger.debug(buff.toString());
                Path srcJar = WrapperFactory.getNioServiceWrapper().getPath(patchingJarFilePath, new String[0]);
                if (!Files.exists(srcJar, new LinkOption[0])) {
                    buff = new StringBuffer("verify() failed. Parent file not exist: \"");
                    buff.append(patchingJarFilePath);
                    buff.append("\"");
                    OLogger.printlnOnLog(buff.toString());
                    throw new IOException(buff.toString());
                }
                String scratchLocation = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID());
                MultiJarUtil.verifyBaseOnJarTree(tn, result, patchingJarFilePath, scratchLocation, patchLocation, "");
                continue;
            }
            catch (IOException e2) {
                buff = new StringBuffer("Verify for Jar file \"ORACLE_HOME" + File.separator);
                buff.append(tn.getEntryName());
                buff.append("\" failed");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                ArrayList failed = new ArrayList();
                MultiJarUtil.getAllLeavesForNode(tn, failed, MultiJarUtil.JarOperation.VERIFY, true, e2.getMessage());
                for (int j2 = 0; j2 < failed.size(); ++j2) {
                    JarActionEntity ja = (JarActionEntity)failed.get(j2);
                    result.put(ja.getClassName(), new Boolean(false));
                }
            }
        }
        return result;
    }

    protected static String getTopLevelJarFilePath(String oracleHome, String jarPath, String jarName) {
        StringBuffer completeFile = new StringBuffer(oracleHome);
        if (!oracleHome.endsWith(File.separator)) {
            completeFile.append(File.separator);
        }
        completeFile.append(MultiJarUtil.combineEntry(jarPath, jarName));
        return completeFile.toString();
    }

    public static void cleanUpDeleteJarActionCache() {
        isRequiredCacheForApply = null;
        isRequiredDescCacheForApply = null;
        isRequiredCacheForRollback = null;
        isRequiredDescCacheForRollback = null;
    }

    public static void initDeleteJarActionCache() {
        if (isRequiredCacheForApply == null) {
            isRequiredCacheForApply = new HashMap<DeleteJarAction, Boolean>();
        }
        if (isRequiredDescCacheForApply == null) {
            isRequiredDescCacheForApply = new HashMap<DeleteJarAction, String>();
        }
        if (isRequiredCacheForRollback == null) {
            isRequiredCacheForRollback = new HashMap<DeleteJarAction, Boolean>();
        }
        if (isRequiredDescCacheForRollback == null) {
            isRequiredDescCacheForRollback = new HashMap<DeleteJarAction, String>();
        }
    }
}

