/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchingModel;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class InitReadMeAction
extends PatchAction
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3274365384114696148L;
    private String readMeFile;
    private boolean realEmptyAction;
    StringBuffer fileContent;

    public InitReadMeAction() {
        this.readMeFile = null;
        this.realEmptyAction = true;
        this.fileContent = new StringBuffer();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public InitReadMeAction(String readMeFileLoc) {
        block8: {
            super(-1);
            this.readMeFile = null;
            this.realEmptyAction = true;
            this.fileContent = new StringBuffer();
            if (PatchingModel.returnModelCode(OPatchEnv.getOracleHome()) == 2) {
                this.noOp = true;
                return;
            }
            try {
                this.readMeFile = readMeFileLoc;
                if (!Files.exists(WrapperFactory.getNioServiceWrapper().getPath(this.readMeFile, new String[0]), new LinkOption[0])) {
                    this.noOp = true;
                    break block8;
                }
                this.noOp = false;
                this.realEmptyAction = false;
                try {
                    int len;
                    InputStream in = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(this.readMeFile, new String[0]), new OpenOption[0]);
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        for (int i2 = 0; i2 < len; ++i2) {
                            this.fileContent.append((char)buf[i2]);
                        }
                    }
                    in.close();
                }
                catch (Exception e2) {
                    OLogger.error("OUI-67011", new Object[]{this.readMeFile.toString()});
                    throw e2;
                }
            }
            catch (Exception e3) {
                OLogger.debug(new StringBuffer("InitReadMeAction::InitReadMeAction(): IOException, set to no-op"));
                this.noOp = true;
            }
        }
    }

    @Override
    protected void makeNoOp() {
        this.noOp = true;
    }

    public boolean isRealEmpty() {
        return this.realEmptyAction;
    }

    protected void catFile() {
        if (this.noOp) {
            OLogger.debug(new StringBuffer("InitReadMeAction::catFile() is a no-op"));
        } else {
            StringBuffer tmpB = new StringBuffer("Contents of init script readme file: ");
            tmpB.append(this.readMeFile.toString());
            OLogger.debug(tmpB);
            OLogger.info("OUI-67103", new Object[]{this.fileContent.toString()});
        }
    }

    public void process() {
        if (!this.realEmptyAction) {
            this.noOp = false;
        }
        this.catFile();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("readMeFile = ");
        buff.append(this.readMeFile);
        buff.append("\nnoOp = ");
        buff.append(this.noOp);
        buff.append("\nfileContent = ");
        buff.append(this.fileContent);
        return buff.toString();
    }

    @Override
    public String getChildPath() {
        return "";
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        return WrapperFactory.getNioServiceWrapper().getPath(this.readMeFile, new String[0]).toAbsolutePath().toString();
    }

    @Override
    public String getActionName() {
        return "InitReadMeAction";
    }

    @Override
    public String getActionDesc() {
        return "Display the init readme.";
    }
}

