/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import oracle.opatch.OPatchEnv;
import oracle.opatch.Version;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

public class HelpSession {
    public void process() {
        this.displayHelp();
    }

    public void displayHelp(String helpFileName) {
        StringBuffer helpM = new StringBuffer("\n");
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.startsWith("/")) continue;
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFileName});
            OLogger.println(msg);
        }
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        if (OPatchEnv.isFmwHelp()) {
            this.displayHelp("fmw_help.txt");
        }
        boolean isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"));
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && isObrepo) {
            this.displayHelp("obrepo_help.txt");
        } else {
            this.displayHelp("opatch_help.txt");
        }
    }

    public String getVersion() {
        return new Version().getOPatchVersion();
    }
}

