/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import oracle.opatch.opatchlogger.OLogger;

public class HeapMemory {
    static final int mb = 0x100000;

    public static void printVerboseUsage() {
        Runtime runtime = Runtime.getRuntime();
        OLogger.println("##### Heap utilization statistics [MB] #####");
        OLogger.println("Used Memory:" + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L);
        OLogger.println("Free Memory:" + runtime.freeMemory() / 0x100000L);
        OLogger.println("Total Memory:" + runtime.totalMemory() / 0x100000L);
        OLogger.println("Max Memory:" + runtime.maxMemory() / 0x100000L);
    }

    public static void printHeapUsed() {
        Runtime runtime = Runtime.getRuntime();
        OLogger.println("##### Used Heap Memory [MB]:" + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L);
    }

    public static long getHeapUsedMB() {
        Runtime runtime = Runtime.getRuntime();
        return (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
    }

    public static void logMemoryInfo() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        OLogger.justlog(OLogger.INFO, "Runtime args: " + runtimeMXBean.getInputArguments());
        Runtime runtime = Runtime.getRuntime();
        OLogger.justlog(OLogger.INFO, "Heap in use : " + (runtime.totalMemory() - runtime.freeMemory() >> 20) + " MB\n" + "Total memory: " + (runtime.totalMemory() >> 20) + " MB\n" + "Free memory : " + (runtime.freeMemory() >> 20) + " MB\n" + "Max memory  : " + (runtime.maxMemory() >> 20) + " MB");
    }
}

