/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.PrereqSession;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.patchsdk.OPatchZipStringResource;
import oracle.opatch.wrappers.WrapperFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CompositePatchObject {
    public static String getCompositeFilePathFromOH(String oracleHomePath, String patchID) {
        return oracleHomePath + File.separator + "inventory" + File.separator + "oneoffs" + File.separator + patchID + File.separator + "etc" + File.separator + "config" + File.separator + "composite.xml";
    }

    public static String getInventoryFilePathFromOH(String oracleHomePath, String patchID) {
        return oracleHomePath + File.separator + "inventory" + File.separator + "oneoffs" + File.separator + patchID + File.separator + "etc" + File.separator + "config" + File.separator + "inventory.xml";
    }

    public static boolean canIgnoreConflictWithOneOff(String oracleHomePath, OneOffEntry newElement, OneOffEntry[] prereqInputList, OneOffEntry oneoff) {
        ArrayList<OneOffEntry> normalList;
        ArrayList<OneOffEntry> compositeList;
        block30: {
            OneOffEntry[] inputList = new OneOffEntry[]{};
            compositeList = new ArrayList<OneOffEntry>();
            normalList = new ArrayList<OneOffEntry>();
            if (newElement == null || oneoff == null) {
                return false;
            }
            boolean canProceed = true;
            boolean bl = canProceed = !newElement.getIsComposite() || !oneoff.getIsComposite();
            if (canProceed) {
                boolean bl2 = canProceed = canProceed && (newElement.getIsComposite() || oneoff.getIsComposite());
            }
            if (!canProceed) {
                return false;
            }
            try {
                OneOffEntry consOneOff;
                PatchObject pObj;
                int j2;
                String parentPath;
                String[] constituents;
                String compositeXMLLocation;
                int i2;
                if (!OPatchEnv.getSessionType().equals("util")) {
                    for (i2 = 0; i2 < prereqInputList.length; ++i2) {
                        if (prereqInputList[i2].getIsComposite()) {
                            compositeXMLLocation = prereqInputList[i2].getCompositeFileLocation();
                            constituents = CompositePatchObject.getConstituentList(compositeXMLLocation);
                            parentPath = new File(prereqInputList[i2].getRelativePatchLocation()).getParent();
                            parentPath = WrapperFactory.getNioServiceWrapper().getPath(parentPath, new String[0]).toAbsolutePath().normalize().toString();
                            for (j2 = 0; j2 < constituents.length; ++j2) {
                                pObj = PatchObject.getInstance(parentPath + File.separator + constituents[j2]);
                                consOneOff = pObj.toOneOffEntry(oracleHomePath);
                                compositeList.add(consOneOff);
                            }
                            continue;
                        }
                        normalList.add(prereqInputList[i2]);
                    }
                    normalList.removeAll(compositeList);
                    break block30;
                }
                inputList = OPatchUtilHelper.getPatchesToApply(oracleHomePath, "");
                for (i2 = 0; i2 < inputList.length; ++i2) {
                    if (inputList[i2].getIsComposite()) {
                        compositeXMLLocation = inputList[i2].getCompositeFileLocation();
                        constituents = CompositePatchObject.getConstituentList(compositeXMLLocation);
                        parentPath = new File(inputList[i2].getRelativePatchLocation()).getParent();
                        parentPath = WrapperFactory.getNioServiceWrapper().getPath(parentPath, new String[0]).toAbsolutePath().normalize().toString();
                        for (j2 = 0; j2 < constituents.length; ++j2) {
                            pObj = PatchObject.getInstance(parentPath + File.separator + constituents[j2]);
                            consOneOff = pObj.toOneOffEntry(oracleHomePath);
                            compositeList.add(consOneOff);
                        }
                        continue;
                    }
                    normalList.add(inputList[i2]);
                }
                normalList.removeAll(compositeList);
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
            }
        }
        if (normalList.size() == 0) {
            return false;
        }
        if (compositeList.size() == 0) {
            return false;
        }
        OneOffEntry[] compositeSubPatches = new OneOffEntry[compositeList.size()];
        compositeList.toArray(compositeSubPatches);
        OneOffEntry[] normalPatches = new OneOffEntry[normalList.size()];
        normalList.toArray(normalPatches);
        ArrayList<OneOffEntry> overlayList = new ArrayList<OneOffEntry>();
        ArrayList<ArrayList<OneOffEntry>> mapList = new ArrayList<ArrayList<OneOffEntry>>();
        for (int i3 = 0; i3 < compositeSubPatches.length; ++i3) {
            overlayList = new ArrayList();
            ArrayList values = new ArrayList();
            OneOffEntry key = compositeSubPatches[i3];
            block11: for (int j3 = 0; j3 < normalPatches.length; ++j3) {
                String[] overlays = normalPatches[j3].getOverLayPatchIDs();
                for (int k2 = 0; k2 < overlays.length; ++k2) {
                    if (!key.getID().equals(overlays[k2])) continue;
                    overlayList.add(normalPatches[j3]);
                    continue block11;
                }
            }
            mapList.add(overlayList);
        }
        OneOffEntry rep = null;
        OneOffEntry repCopy = null;
        if (!oneoff.getIsComposite()) {
            rep = oneoff;
        } else if (!newElement.getIsComposite()) {
            rep = newElement;
        }
        try {
            rep = repCopy = PrereqAPI.getInstalledOneOff(oracleHomePath, rep.getID());
        }
        catch (Throwable t) {
            return false;
        }
        if (rep == null) {
            return false;
        }
        String[] overlays = rep.getOverLayPatchIDs();
        boolean oneoffFound = false;
        for (int i4 = compositeSubPatches.length - 1; i4 >= 0; --i4) {
            List compositeOverLay = (List)mapList.get(i4);
            if (!compositeOverLay.contains(rep) || rep.getIsComposite()) continue;
            oneoffFound = true;
            for (int j4 = i4 + 1; j4 <= compositeSubPatches.length - 1; ++j4) {
                for (int k3 = 0; k3 < overlays.length; ++k3) {
                    if (!overlays[k3].equals(compositeSubPatches[j4].getID())) continue;
                    return false;
                }
            }
        }
        if (oneoffFound) {
            return true;
        }
        ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
        try {
            for (int i5 = 0; i5 < normalPatches.length; ++i5) {
                if (normalPatches[i5] == null || !conflictHandler.isBugSuperset(new OneOffEntry[]{rep}, normalPatches[i5].getBugIDsFixed(), new String[1])) continue;
                return true;
            }
        }
        catch (Exception e3) {
            StringBuffer errorBuff = new StringBuffer();
            errorBuff.append("Composite patch conflicts with existing one-off patches.");
            errorBuff.append("\n");
            errorBuff.append(e3.getMessage());
            OLogger.printlnOnLog(errorBuff.toString());
            OLogger.printStackTrace(e3);
            return false;
        }
        return false;
    }

    public static ArrayList checkCompositeStructure(Path startingDir, ArrayList xmlInfo) {
        String dirPath = startingDir.toString();
        Path oneOffInventoryXMLFile = WrapperFactory.getNioServiceWrapper().getPath(PatchObject.getInventoryFilePath(dirPath), new String[0]);
        if (Files.exists(oneOffInventoryXMLFile, new LinkOption[0])) {
            xmlInfo.set(0, new Integer((Integer)xmlInfo.get(0) + 1));
            Document document = PatchObjectUtil.parseXMLFile(oneOffInventoryXMLFile);
            Node inventory_node = document.getFirstChild();
            NodeList children_of_inventory = inventory_node.getChildNodes();
            boolean constituentExists = false;
            int j2 = 0;
            for (j2 = 0; j2 < children_of_inventory.getLength(); ++j2) {
                if (!children_of_inventory.item(j2).getNodeName().equals("constituent")) continue;
                constituentExists = true;
            }
            if (!constituentExists) {
                xmlInfo.set(1, new Integer((Integer)xmlInfo.get(1) + 1));
            }
            return xmlInfo;
        }
        ArrayList<Path> ArrlistOfFiles = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(startingDir);){
            for (Path entry : stream) {
                ArrlistOfFiles.add(entry);
            }
        }
        catch (IOException e2) {
            OLogger.printlnOnLog(e2.getMessage());
        }
        for (Path listOfFiles : ArrlistOfFiles) {
            String currentFile = listOfFiles.toString();
            Path potentialInventoryXMLFile = WrapperFactory.getNioServiceWrapper().getPath(PatchObject.getInventoryFilePath(currentFile), new String[0]);
            Path potentialActionsXMLFile = WrapperFactory.getNioServiceWrapper().getPath(PatchObject.getActionFilePath(currentFile), new String[0]);
            Path potentialCompositeXMLFile = WrapperFactory.getNioServiceWrapper().getPath(PatchObject.getCompositeFilePath(currentFile), new String[0]);
            if (!(!Files.isDirectory(listOfFiles, new LinkOption[0]) || Files.exists(potentialInventoryXMLFile, new LinkOption[0]) && Files.exists(potentialActionsXMLFile, new LinkOption[0]))) {
                xmlInfo.set(4, "false");
            }
            if (Files.exists(potentialInventoryXMLFile, new LinkOption[0])) {
                xmlInfo.set(0, new Integer((Integer)xmlInfo.get(0) + 1));
                Document document = PatchObjectUtil.parseXMLFile(potentialInventoryXMLFile);
                Node inventory_node = document.getFirstChild();
                NodeList children_of_inventory = inventory_node.getChildNodes();
                boolean constituentExists = false;
                int j3 = 0;
                for (j3 = 0; j3 < children_of_inventory.getLength(); ++j3) {
                    if (!children_of_inventory.item(j3).getNodeName().equals("constituent")) continue;
                    constituentExists = true;
                }
                if (!constituentExists) {
                    xmlInfo.set(1, new Integer((Integer)xmlInfo.get(1) + 1));
                }
            }
            if (!Files.exists(potentialCompositeXMLFile, new LinkOption[0])) continue;
            xmlInfo.set(2, new Integer((Integer)xmlInfo.get(2) + 1));
            xmlInfo.set(3, potentialCompositeXMLFile.toString());
        }
        return xmlInfo;
    }

    public static String validateComposite(String compositePatchLocation) {
        Path compositePatchFile = WrapperFactory.getNioServiceWrapper().getPath(compositePatchLocation, new String[0]);
        ArrayList<Path> ArrlistOfFiles = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(compositePatchFile);){
            for (Path entry : stream) {
                ArrlistOfFiles.add(entry);
            }
        }
        catch (IOException e2) {
            OLogger.printlnOnLog(e2.getMessage());
        }
        if (ArrlistOfFiles.isEmpty()) {
            return "";
        }
        ArrayList values = new ArrayList();
        values.add(new Integer(0));
        values.add(new Integer(0));
        values.add(new Integer(0));
        values.add("");
        values.add("true");
        values = CompositePatchObject.checkCompositeStructure(compositePatchFile, values);
        int numInventoryXml = (Integer)values.get(0);
        int numInventoryXmlWithoutCompositeMetadata = (Integer)values.get(1);
        int numCompositeXmlFiles = (Integer)values.get(2);
        String compositeXmlFilePath = (String)values.get(3);
        String doesPatchHaveAllInventoryandActionXMLs = (String)values.get(4);
        if (numCompositeXmlFiles == 1 && numInventoryXmlWithoutCompositeMetadata == 0 && doesPatchHaveAllInventoryandActionXMLs.equals("true")) {
            String[] constituentList = CompositePatchObject.getConstituentList(compositeXmlFilePath);
            if (constituentList.length != numInventoryXml) {
                String errorMsg = OLogger.getString("OUI-67925");
                throw new RuntimeException(errorMsg);
            }
            return compositeXmlFilePath;
        }
        if (numCompositeXmlFiles == 0 && numInventoryXml == numInventoryXmlWithoutCompositeMetadata) {
            return "";
        }
        String errorMsg = "";
        if (numCompositeXmlFiles > 1) {
            errorMsg = errorMsg + OLogger.getString("OUI-67908");
        }
        if (numCompositeXmlFiles == 0 && numInventoryXml != numInventoryXmlWithoutCompositeMetadata) {
            errorMsg = errorMsg + OLogger.getString("OUI-67924");
        }
        if (numCompositeXmlFiles == 1 && numInventoryXmlWithoutCompositeMetadata > 0) {
            errorMsg = errorMsg + OLogger.getString("OUI-67923");
        }
        if (doesPatchHaveAllInventoryandActionXMLs.equals("false")) {
            errorMsg = errorMsg + OLogger.getString("OUI-67950");
        }
        throw new RuntimeException(errorMsg);
    }

    public static Boolean validateComposite(Map map) {
        Boolean isComposite = false;
        Map compositeMap = (Map)map.get(OPatchZipStringResource.COMPOSITE);
        Map patchesMap = (Map)map.get(OPatchZipStringResource.PATCHESMAP);
        Map inventoryMap = (Map)map.get(OPatchZipStringResource.INVENTORY);
        Map actionMap = (Map)map.get(OPatchZipStringResource.ACTION);
        int compositeXMLNum = compositeMap.size();
        int invNum = inventoryMap.size();
        int actionNum = actionMap.size();
        int subPatchesNum = patchesMap.size();
        int constituentNotExistsNum = 0;
        Iterator inventoryIterator = inventoryMap.values().iterator();
        while (inventoryIterator.hasNext()) {
            ByteArrayInputStream inventoryInputStream = new ByteArrayInputStream((byte[])inventoryIterator.next());
            Document document = PatchObjectUtil.parseXMLFile(inventoryInputStream);
            Node inventory_node = document.getFirstChild();
            NodeList children_of_inventory = inventory_node.getChildNodes();
            boolean constituentExists = false;
            int j2 = 0;
            for (j2 = 0; j2 < children_of_inventory.getLength(); ++j2) {
                if (!children_of_inventory.item(j2).getNodeName().equals("constituent")) continue;
                constituentExists = true;
            }
            if (constituentExists) continue;
            ++constituentNotExistsNum;
        }
        if (compositeXMLNum == 1 && constituentNotExistsNum == 0 && subPatchesNum == invNum && subPatchesNum == actionNum) {
            isComposite = true;
        }
        return isComposite;
    }

    public static String getCompositeFilePath(String compositePatchLocation) {
        Path compositePatchFile = WrapperFactory.getNioServiceWrapper().getPath(compositePatchLocation, new String[0]);
        ArrayList<Path> ArrlistOfFiles = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(compositePatchFile);){
            for (Path entry : stream) {
                ArrlistOfFiles.add(entry);
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        int numCompositeXmlFiles = 0;
        String compositeXmlFilePath = "";
        if (ArrlistOfFiles == null) {
            return compositeXmlFilePath;
        }
        for (Path listOfFiles : ArrlistOfFiles) {
            String currentConstituent = listOfFiles.toString();
            if (!Files.isDirectory(listOfFiles, new LinkOption[0])) continue;
            String compDir = PatchObject.getCompositeFilePath(currentConstituent);
            Path compositeXmlFile = WrapperFactory.getNioServiceWrapper().getPath(compDir, new String[0]);
            if (compositeXmlFile.toString().equals("") || !Files.exists(compositeXmlFile, new LinkOption[0])) continue;
            try {
                compositeXmlFilePath = compositeXmlFile.toAbsolutePath().normalize().toString();
                if (++numCompositeXmlFiles <= 1) continue;
                String errorMsg = OLogger.getString("OUI-67908");
                throw new IllegalAccessException(errorMsg);
            }
            catch (IllegalAccessException e3) {
                OLogger.printStackTrace(e3);
            }
        }
        return compositeXmlFilePath;
    }

    public static String[] getConstituentList(String compositeFileLocation) {
        if (compositeFileLocation == null || compositeFileLocation.isEmpty()) {
            return new String[0];
        }
        Path compositePatchFile = WrapperFactory.getNioServiceWrapper().getPath(compositeFileLocation, new String[0]);
        if (compositeFileLocation.equals("") || !Files.exists(compositePatchFile, new LinkOption[0])) {
            return new String[0];
        }
        Document document = PatchObjectUtil.parseXMLFile(compositePatchFile);
        Node composite_node = document.getFirstChild();
        NodeList children_of_composite = composite_node.getChildNodes();
        int j2 = 0;
        for (j2 = 0; j2 < children_of_composite.getLength() && !children_of_composite.item(j2).getNodeName().equals("sequence"); ++j2) {
        }
        Node sequence_node = children_of_composite.item(j2);
        NodeList patch_list = sequence_node.getChildNodes();
        ArrayList<String> all_constituents = new ArrayList<String>();
        for (int i2 = 0; i2 < patch_list.getLength(); ++i2) {
            if (patch_list.item(i2).getNodeName().equals("#text") || patch_list.item(i2).getNodeName().equals("#comment")) continue;
            Element cur_node = (Element)patch_list.item(i2);
            all_constituents.add(cur_node.getAttribute("id"));
        }
        String[] constituentsInOrder = new String[all_constituents.size()];
        all_constituents.toArray(constituentsInOrder);
        return constituentsInOrder;
    }

    public static PatchObject[] getCompositeSubPatches(String patchLoc) {
        ArrayList<PatchObject> pObjsList = new ArrayList<PatchObject>();
        if (PQSession.isComposite(patchLoc)) {
            int k2;
            String compositeXMLLoc = CompositePatchObject.getCompositeFilePath(patchLoc);
            String[] subPatchIDs = CompositePatchObject.getConstituentList(compositeXMLLoc);
            HashMap<String, PatchObject> allSubPatches = new HashMap<String, PatchObject>();
            for (k2 = 0; k2 < subPatchIDs.length; ++k2) {
                String subPatchLoc = patchLoc + File.separator + subPatchIDs[k2];
                PatchObject pObject = OPatchUtilHelper.loadAndInitPatchObject(patchLoc, subPatchLoc);
                allSubPatches.put(pObject.getPatchID(), pObject);
            }
            for (k2 = 0; k2 < subPatchIDs.length; ++k2) {
                PatchObject correctSubPatch = (PatchObject)allSubPatches.get(subPatchIDs[k2]);
                if (correctSubPatch == null) {
                    String errorMsg = OLogger.getString("S_OPATCH_GET_COMPOSITE_ERROR", new Object[]{patchLoc});
                    RuntimeException e2 = new RuntimeException(errorMsg);
                    throw e2;
                }
                pObjsList.add(correctSubPatch);
            }
        }
        return pObjsList.toArray(new PatchObject[pObjsList.size()]);
    }

    public static String[] getConstituentList(InputStream compositeInputStream) {
        if (compositeInputStream == null) {
            return new String[0];
        }
        Document document = PatchObjectUtil.parseXMLFile(compositeInputStream);
        Node composite_node = document.getFirstChild();
        NodeList children_of_composite = composite_node.getChildNodes();
        int j2 = 0;
        for (j2 = 0; j2 < children_of_composite.getLength() && !children_of_composite.item(j2).getNodeName().equals("sequence"); ++j2) {
        }
        Node sequence_node = children_of_composite.item(j2);
        NodeList patch_list = sequence_node.getChildNodes();
        ArrayList<String> all_constituents = new ArrayList<String>();
        for (int i2 = 0; i2 < patch_list.getLength(); ++i2) {
            if (patch_list.item(i2).getNodeName().equals("#text") || patch_list.item(i2).getNodeName().equals("#comment")) continue;
            Element cur_node = (Element)patch_list.item(i2);
            all_constituents.add(cur_node.getAttribute("id"));
        }
        String[] constituentsInOrder = new String[all_constituents.size()];
        all_constituents.toArray(constituentsInOrder);
        return constituentsInOrder;
    }

    public static String getActiveConstituentFromCompositeXml(String compositeXmlLoc) {
        String[] listOfConstituents = CompositePatchObject.getConstituentList(compositeXmlLoc);
        if (listOfConstituents.length == 0) {
            return "";
        }
        return listOfConstituents[listOfConstituents.length - 1];
    }

    public static OneOffEntry[] getConstituentsInOrder(String compositePatchLocation, String oracleHomePath, String sessionName) {
        String compositeFileName = CompositePatchObject.getCompositeFilePath(compositePatchLocation);
        Path compositePatchFile = WrapperFactory.getNioServiceWrapper().getPath(compositeFileName, new String[0]);
        Document document = PatchObjectUtil.parseXMLFile(compositePatchFile);
        Node composite_node = document.getFirstChild();
        NodeList children_of_composite = composite_node.getChildNodes();
        int j2 = 0;
        for (j2 = 0; j2 < children_of_composite.getLength() && !children_of_composite.item(j2).getNodeName().equals("sequence"); ++j2) {
        }
        Node sequence_node = children_of_composite.item(j2);
        NodeList patch_list = sequence_node.getChildNodes();
        ArrayList<PatchObject> all_constituents = new ArrayList<PatchObject>();
        for (int i2 = 0; i2 < patch_list.getLength(); ++i2) {
            if (patch_list.item(i2).getNodeName().equals("#text") || patch_list.item(i2).getNodeName().equals("#comment")) continue;
            Element cur_node = (Element)patch_list.item(i2);
            all_constituents.add(OPatchUtilHelper.loadAndInitPatchObject(sessionName, compositePatchLocation + File.separator + cur_node.getAttribute("id") + File.separator));
        }
        OneOffEntry[] oneOffsInOrder = new OneOffEntry[all_constituents.size()];
        for (int i3 = 0; i3 < all_constituents.size(); ++i3) {
            oneOffsInOrder[i3] = ((PatchObject)all_constituents.get(i3)).toOneOffEntry(oracleHomePath);
        }
        return oneOffsInOrder;
    }

    public static void checkUniqueUIDs(OneOffEntry[] subPatches) {
        HashMap<String, String> setOfUIDs = new HashMap<String, String>();
        for (int i2 = 0; i2 < subPatches.length; ++i2) {
            String currentUID = subPatches[i2].getPSENumber();
            String patchID = subPatches[i2].getID();
            if (currentUID == null || currentUID.equals("")) {
                String errorMsg = "The subpatch " + patchID + " has no unique patch id." + " This composite patch has incorrect metadata and should not be applied.";
                OPatchStateManagerFactory.getInstance().setErrorCode(50);
                throw new RuntimeException(errorMsg);
            }
            if (setOfUIDs.containsKey(currentUID)) {
                String errorMsg = "This subpatch " + patchID + " has the same unique patch id as " + "the subpatch " + setOfUIDs.get(currentUID) + ". This composite patch has incorrect metadata" + " and should not be applied.";
                OPatchStateManagerFactory.getInstance().setErrorCode(50);
                throw new RuntimeException(errorMsg);
            }
            setOfUIDs.put(currentUID, patchID);
        }
    }

    public static void checkUIDs(OneOffEntry[] subPatches) {
        HashMap setOfUIDs = new HashMap();
        ArrayList<String> subPatchList = new ArrayList<String>();
        for (int i2 = 0; i2 < subPatches.length; ++i2) {
            String currentUID = subPatches[i2].getPSENumber();
            String patchID = subPatches[i2].getID();
            if (currentUID != null && !currentUID.equals("")) continue;
            subPatchList.add(patchID);
        }
        String listOfSubpatches = "";
        if (subPatchList.size() > 0) {
            for (int i3 = 0; i3 < subPatchList.size(); ++i3) {
                listOfSubpatches = listOfSubpatches + "," + subPatchList.get(i3);
            }
            listOfSubpatches = listOfSubpatches.substring(1);
            OLogger.warn("OUI-67932", new Object[]{listOfSubpatches});
        }
    }

    public static ArrayList getCompositesOrder(String patchid, String compositeFileName) {
        Path compositePatchFile = WrapperFactory.getNioServiceWrapper().getPath(compositeFileName, new String[0]);
        if (compositeFileName == null || compositeFileName.isEmpty() || !Files.exists(compositePatchFile, new LinkOption[0])) {
            String errorMsg = OLogger.getString("OUI-67909", new Object[]{patchid});
            OPatchStateManagerFactory.getInstance().setErrorCode(32);
            throw new RuntimeException(errorMsg);
        }
        Document document = PatchObjectUtil.parseXMLFile(compositePatchFile);
        Node composite_node = document.getFirstChild();
        NodeList children_of_composite = composite_node.getChildNodes();
        int j2 = 0;
        for (j2 = 0; j2 < children_of_composite.getLength() && !children_of_composite.item(j2).getNodeName().equals("sequence"); ++j2) {
        }
        Node sequence_node = children_of_composite.item(j2);
        NodeList patch_list = sequence_node.getChildNodes();
        ArrayList<String> all_constituents = new ArrayList<String>();
        for (int i2 = 0; i2 < patch_list.getLength(); ++i2) {
            if (patch_list.item(i2).getNodeName().equals("#text") || patch_list.item(i2).getNodeName().equals("#comment")) continue;
            Element cur_node = (Element)patch_list.item(i2);
            String sample = cur_node.getAttribute("id");
            all_constituents.add(sample);
        }
        return all_constituents;
    }

    public static ArrayList getCompositeAutoRBOrder(String activeField, String oracleHomePath) {
        String compositeFileName = CompositePatchObject.getCompositeFilePathFromOH(oracleHomePath, activeField);
        return CompositePatchObject.getCompositesOrder(activeField, compositeFileName);
    }

    public static OneOffEntry[] GetNonIdenticalPatch(OneOffEntry[] patchesToApply, String oracleHomePath) throws Exception {
        ArrayList<OneOffEntry> output = new ArrayList<OneOffEntry>();
        OneOffEntry[] OHOneOffs = null;
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable e2) {
            OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        int index = 0;
        for (int i2 = 0; i2 < patchesToApply.length; ++i2) {
            boolean found = false;
            for (int j2 = 0; j2 < OHOneOffs.length; ++j2) {
                if (!patchesToApply[i2].getID().equals(OHOneOffs[j2].getID())) continue;
                if (i2 == index) {
                    found = true;
                    ++index;
                    if (CompositePatchObject.compareDate(patchesToApply[i2].getCreationDate(), OHOneOffs[j2].getCreationDate()) >= 0L) continue;
                    String errorMsg = OLogger.getString("OUI-67902", new Object[]{patchesToApply[i2].getID(), patchesToApply[i2].getCreationDate()});
                    OPatchStateManagerFactory.getInstance().setErrorCode(32);
                    throw new Exception(errorMsg);
                }
                String errorMsg = OLogger.getString("OUI-67903", new Object[]{patchesToApply[i2].getID()});
                OPatchStateManagerFactory.getInstance().setErrorCode(32);
                throw new Exception(errorMsg);
            }
            if (found) continue;
            output.add(patchesToApply[i2]);
        }
        OneOffEntry[] outputResult = new OneOffEntry[output.size()];
        output.toArray(outputResult);
        return outputResult;
    }

    public static OneOffEntry[] GetIdenticalPatch(OneOffEntry[] patchesToApply, String oracleHomePath) throws Exception {
        ArrayList<OneOffEntry> output = new ArrayList<OneOffEntry>();
        OneOffEntry[] OHOneOffs = null;
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable e2) {
            OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        int index = 0;
        for (int i2 = 0; i2 < patchesToApply.length; ++i2) {
            boolean found = false;
            for (int j2 = 0; j2 < OHOneOffs.length; ++j2) {
                if (!patchesToApply[i2].getID().equals(OHOneOffs[j2].getID())) continue;
                if (i2 == index) {
                    found = true;
                    ++index;
                    if (CompositePatchObject.compareDate(patchesToApply[i2].getCreationDate(), OHOneOffs[j2].getCreationDate()) >= 0L) continue;
                    String errorMsg = OLogger.getString("OUI-67902", new Object[]{patchesToApply[i2].getID(), patchesToApply[i2].getCreationDate()});
                    OPatchStateManagerFactory.getInstance().setErrorCode(32);
                    throw new Exception(errorMsg);
                }
                String errorMsg = OLogger.getString("OUI-67903", new Object[]{patchesToApply[i2].getID()});
                OPatchStateManagerFactory.getInstance().setErrorCode(32);
                throw new Exception(errorMsg);
            }
            if (!found) continue;
            output.add(patchesToApply[i2]);
        }
        OneOffEntry[] outputResult = new OneOffEntry[output.size()];
        output.toArray(outputResult);
        return outputResult;
    }

    private static long compareDate(String s1, String s2) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy, HH:mm:ss 'hrs'");
        StringTokenizer tokenizer1 = new StringTokenizer(s1, " ");
        StringTokenizer tokenizer2 = new StringTokenizer(s2, " ");
        StringBuffer timebuff1 = new StringBuffer(tokenizer1.nextToken());
        StringBuffer timebuff2 = new StringBuffer(tokenizer2.nextToken());
        String z1 = "";
        String z2 = "";
        try {
            timebuff1.append(" ");
            timebuff1.append(tokenizer1.nextToken());
            timebuff1.append(" ");
            timebuff1.append(tokenizer1.nextToken());
            timebuff1.append(" ");
            timebuff1.append(tokenizer1.nextToken());
            timebuff1.append(" ");
            timebuff1.append(tokenizer1.nextToken());
            z1 = tokenizer1.nextToken();
            timebuff2.append(" ");
            timebuff2.append(tokenizer2.nextToken());
            timebuff2.append(" ");
            timebuff2.append(tokenizer2.nextToken());
            timebuff2.append(" ");
            timebuff2.append(tokenizer2.nextToken());
            timebuff2.append(" ");
            timebuff2.append(tokenizer2.nextToken());
            z2 = tokenizer2.nextToken();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
        long l1 = 0L;
        try {
            df.setTimeZone(TimeZone.getTimeZone(z1));
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
        }
        try {
            l1 = df.parse(timebuff1.toString()).getTime();
        }
        catch (Exception e4) {
            OLogger.printStackTrace(e4);
        }
        long l2 = 0L;
        try {
            df.setTimeZone(TimeZone.getTimeZone(z2));
        }
        catch (Exception e5) {
            OLogger.printStackTrace(e5);
        }
        try {
            l2 = df.parse(timebuff2.toString()).getTime();
        }
        catch (Exception e6) {
            OLogger.printStackTrace(e6);
        }
        return l1 - l2;
    }

    public static void updateActiveXMLField(OneOffEntry[] identicalPatches, String oracleHomePath, String activePatch) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            RuntimeException rte = new RuntimeException(e2.getMessage());
            rte.setStackTrace(e2.getStackTrace());
            throw rte;
        }
        for (int i2 = 0; i2 < identicalPatches.length; ++i2) {
            RuntimeException rte;
            String fileName = CompositePatchObject.getInventoryFilePathFromOH(oracleHomePath, identicalPatches[i2].getID());
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
            Document doc = null;
            try {
                doc = docBuilder.parse(f2.toFile());
            }
            catch (SAXException e3) {
                rte = new RuntimeException(e3.getMessage());
                rte.setStackTrace(e3.getStackTrace());
                throw rte;
            }
            catch (IOException e4) {
                rte = new RuntimeException(e4.getMessage());
                rte.setStackTrace(e4.getStackTrace());
                throw rte;
            }
            Element root = doc.getDocumentElement();
            NodeList metadataList = root.getChildNodes();
            boolean constituentExists = false;
            for (int j2 = 0; j2 < metadataList.getLength(); ++j2) {
                Node metadataItem = metadataList.item(j2);
                String name = metadataItem.getNodeName();
                if (!name.equals("constituent")) continue;
                constituentExists = true;
                Element productTypeElement = (Element)metadataItem;
                String activeField = productTypeElement.getAttribute("active");
                productTypeElement.setAttribute("active", activeField + "," + activePatch);
                break;
            }
            if (!constituentExists) {
                Element childElement = doc.createElement("constituent");
                childElement.setAttribute("active", identicalPatches[i2].getID() + "," + activePatch);
                root.appendChild(childElement);
            }
            CompositePatchObject.saveXMLDocument(fileName, doc);
        }
    }

    public static boolean saveXMLDocument(String fileName, Document doc) {
        Transformer transformer;
        OutputStream fos;
        Path xmlOutputFile = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
        try {
            fos = Files.newOutputStream(xmlOutputFile, new OpenOption[0]);
        }
        catch (IOException e2) {
            OLogger.println("Error occurred: " + e2.getMessage());
            return false;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e3) {
            OLogger.println("Transformer configuration error: " + e3.getMessage());
            return false;
        }
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(fos);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e4) {
            OLogger.println("Error transform: " + e4.getMessage());
        }
        return true;
    }

    public static String getActiveField(String oracleHomePath, String patchID) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            docBuilder = factory.newDocumentBuilder();
            String fileName = CompositePatchObject.getInventoryFilePathFromOH(oracleHomePath, patchID);
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
            Document doc = docBuilder.parse(f2.toFile());
            Element root = doc.getDocumentElement();
            NodeList metadataList = root.getChildNodes();
            boolean constituentExists = false;
            for (int j2 = 0; j2 < metadataList.getLength(); ++j2) {
                Node metadataItem = metadataList.item(j2);
                String name = metadataItem.getNodeName();
                if (!name.equals("constituent")) continue;
                constituentExists = true;
                Element productTypeElement = (Element)metadataItem;
                String activeField = productTypeElement.getAttribute("active");
                return activeField;
            }
            return null;
        }
        catch (Exception e2) {
            OLogger.printlnOnLog(e2.getMessage());
            return null;
        }
    }

    public static String getActiveConstituent(String fileName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            docBuilder = factory.newDocumentBuilder();
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
            Document doc = docBuilder.parse(f2.toFile());
            Element root = doc.getDocumentElement();
            NodeList metadataList = root.getChildNodes();
            boolean constituentExists = false;
            for (int j2 = 0; j2 < metadataList.getLength(); ++j2) {
                Node metadataItem = metadataList.item(j2);
                String name = metadataItem.getNodeName();
                if (!name.equals("constituent")) continue;
                constituentExists = true;
                Element productTypeElement = (Element)metadataItem;
                String activeField = productTypeElement.getAttribute("active");
                String[] listActive = activeField.split(",");
                return listActive[listActive.length - 1];
            }
        }
        catch (ParserConfigurationException e2) {
            OLogger.printStackTrace(e2);
            return null;
        }
        catch (SAXException e3) {
            OLogger.printStackTrace(e3);
            return null;
        }
        catch (IOException e4) {
            OLogger.printStackTrace(e4);
            return null;
        }
        return null;
    }

    public static String getActiveConstituent(String oracleHomePath, String patchID) {
        String fileName = CompositePatchObject.getInventoryFilePathFromOH(oracleHomePath, patchID);
        return CompositePatchObject.getActiveConstituent(fileName);
    }

    public static String getActiveConstituent(InputStream inventoryStream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(inventoryStream);
            Element root = doc.getDocumentElement();
            NodeList metadataList = root.getChildNodes();
            boolean constituentExists = false;
            for (int j2 = 0; j2 < metadataList.getLength(); ++j2) {
                Node metadataItem = metadataList.item(j2);
                String name = metadataItem.getNodeName();
                if (!name.equals("constituent")) continue;
                constituentExists = true;
                Element productTypeElement = (Element)metadataItem;
                String activeField = productTypeElement.getAttribute("active");
                String[] listActive = activeField.split(",");
                return listActive[listActive.length - 1];
            }
        }
        catch (ParserConfigurationException e2) {
            OLogger.printStackTrace(e2);
            return null;
        }
        catch (SAXException e3) {
            OLogger.printStackTrace(e3);
            return null;
        }
        catch (IOException e4) {
            OLogger.printStackTrace(e4);
            return null;
        }
        return null;
    }

    public static String[] getConstituentsToRollback(String oracleHomePath, String patchID) {
        try {
            String fileName = CompositePatchObject.getCompositeFilePathFromOH(oracleHomePath, patchID);
            Path compFile = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
            if (!Files.exists(compFile, new LinkOption[0])) {
                String[] basePatchID = new String[]{patchID};
                return basePatchID;
            }
            Document document = PatchObjectUtil.parseXMLFile(compFile);
            Node composite_node = document.getFirstChild();
            NodeList children_of_composite = composite_node.getChildNodes();
            int j2 = 0;
            for (j2 = 0; j2 < children_of_composite.getLength() && !children_of_composite.item(j2).getNodeName().equals("sequence"); ++j2) {
            }
            Node sequence_node = children_of_composite.item(j2);
            NodeList patch_list = sequence_node.getChildNodes();
            ArrayList<String> constituentsRollback = new ArrayList<String>();
            for (int i2 = 0; i2 < patch_list.getLength(); ++i2) {
                Element cur_node;
                String constituentID;
                if (patch_list.item(i2).getNodeName().equals("#text") || patch_list.item(i2).getNodeName().equals("#comment") || !CompositePatchObject.isConstituentRollbackable(oracleHomePath, constituentID = (cur_node = (Element)patch_list.item(i2)).getAttribute("id"))) continue;
                constituentsRollback.add(constituentID);
            }
            String[] constituentsToRollback = new String[constituentsRollback.size()];
            constituentsRollback.toArray(constituentsToRollback);
            return constituentsToRollback;
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("Exception occurred in getConstituentsToRollback.");
            OLogger.printStackTrace(e2);
            return new String[0];
        }
    }

    private static boolean isConstituentRollbackable(String oracleHomePath, String patchID) {
        String activeField = CompositePatchObject.getActiveField(oracleHomePath, patchID);
        return activeField != null && !activeField.equals("") && activeField.indexOf(",") == -1;
    }

    public static String[] getConstituentsToNotRollback(String oracleHomePath, String patchID) {
        try {
            String fileName = CompositePatchObject.getCompositeFilePathFromOH(oracleHomePath, patchID);
            Path compFile = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
            if (!Files.exists(compFile, new LinkOption[0])) {
                return new String[0];
            }
            Document document = PatchObjectUtil.parseXMLFile(compFile);
            Node composite_node = document.getFirstChild();
            NodeList children_of_composite = composite_node.getChildNodes();
            int j2 = 0;
            for (j2 = 0; j2 < children_of_composite.getLength() && !children_of_composite.item(j2).getNodeName().equals("sequence"); ++j2) {
            }
            Node sequence_node = children_of_composite.item(j2);
            NodeList patch_list = sequence_node.getChildNodes();
            ArrayList<String> constituentsNotRollback = new ArrayList<String>();
            for (int i2 = 0; i2 < patch_list.getLength(); ++i2) {
                Element cur_node;
                String constituentID;
                if (patch_list.item(i2).getNodeName().equals("#text") || patch_list.item(i2).getNodeName().equals("#comment") || CompositePatchObject.isConstituentRollbackable(oracleHomePath, constituentID = (cur_node = (Element)patch_list.item(i2)).getAttribute("id"))) continue;
                constituentsNotRollback.add(constituentID);
            }
            String[] constituentsNotToRollback = new String[constituentsNotRollback.size()];
            constituentsNotRollback.toArray(constituentsNotToRollback);
            return constituentsNotToRollback;
        }
        catch (Exception e2) {
            OLogger.printlnOnLog("Exception occurred in getConstituentsToRollback: " + e2.getMessage());
            OLogger.printStackTrace(e2);
            return new String[0];
        }
    }

    public static void subtractActiveXMLField(String oracleHomePath, String constituentID) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            RuntimeException rte = new RuntimeException(e2.getMessage());
            rte.setStackTrace(e2.getStackTrace());
            throw rte;
        }
        String fileName = CompositePatchObject.getInventoryFilePathFromOH(oracleHomePath, constituentID);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
        Document doc = null;
        try {
            doc = docBuilder.parse(f2.toFile());
        }
        catch (SAXException e3) {
            RuntimeException rte = new RuntimeException(e3.getMessage());
            rte.setStackTrace(e3.getStackTrace());
            throw rte;
        }
        catch (IOException e4) {
            RuntimeException rte = new RuntimeException(e4.getMessage());
            rte.setStackTrace(e4.getStackTrace());
            throw rte;
        }
        Element root = doc.getDocumentElement();
        NodeList metadataList = root.getChildNodes();
        boolean constituentExists = false;
        for (int j2 = 0; j2 < metadataList.getLength(); ++j2) {
            Node metadataItem = metadataList.item(j2);
            String name = metadataItem.getNodeName();
            if (!name.equals("constituent")) continue;
            constituentExists = true;
            Element productTypeElement = (Element)metadataItem;
            String activeField = productTypeElement.getAttribute("active");
            activeField = activeField.substring(0, activeField.lastIndexOf(","));
            productTypeElement.setAttribute("active", activeField);
        }
        if (!constituentExists) {
            String errorMsg = OLogger.getString("OUI-67907");
            OPatchStateManagerFactory.getInstance().setErrorCode(32);
            throw new RuntimeException(errorMsg);
        }
        CompositePatchObject.saveXMLDocument(fileName, doc);
    }

    public static HashSet[] removeDuplicateActions(OneOffEntry[] patchesToApply) {
        int i2;
        HashSet[] allActionsStored = new HashSet[patchesToApply.length];
        HashSet[] filteredPatchActions = new HashSet[patchesToApply.length];
        for (i2 = 0; i2 < patchesToApply.length; ++i2) {
            allActionsStored[i2] = new HashSet();
            PatchAction[] patchActions = patchesToApply[i2].getPatchActions();
            for (int j2 = 0; j2 < patchActions.length; ++j2) {
                allActionsStored[i2].add(patchActions[j2]);
            }
        }
        for (i2 = 0; i2 < patchesToApply.length; ++i2) {
            ArrayList<PatchAction> newPatchActions = new ArrayList<PatchAction>();
            Iterator it = allActionsStored[i2].iterator();
            filteredPatchActions[i2] = new HashSet();
            while (it.hasNext()) {
                PatchAction currentEntry = (PatchAction)it.next();
                boolean isDuplicate = false;
                for (int j3 = i2 + 1; j3 < patchesToApply.length; ++j3) {
                    if (!allActionsStored[j3].contains(currentEntry)) continue;
                    isDuplicate = true;
                    filteredPatchActions[i2].add(currentEntry);
                }
                if (isDuplicate) continue;
                newPatchActions.add(currentEntry);
            }
            PatchAction[] arrayPatchActions = new PatchAction[newPatchActions.size()];
            for (int k2 = 0; k2 < newPatchActions.size(); ++k2) {
                arrayPatchActions[k2] = (PatchAction)newPatchActions.get(k2);
            }
            patchesToApply[i2].setPatchActions(arrayPatchActions);
        }
        return filteredPatchActions;
    }

    public static void removeDuplicateActions(HashSet[] filteredPatchActions, PatchObject[] patchObjects, int compositeStartIndex, int compositeEndIndex) {
    }

    public static void isCompositeAutoRollbackable(String patchToApply, OneOffEntry[] autoRBPatches, String oracleHomePath) {
        OneOffEntry[] installedPatches;
        boolean[] isProcessed = new boolean[autoRBPatches.length];
        try {
            installedPatches = CompositePatchObject.getInstalledPatches(oracleHomePath);
        }
        catch (Throwable e2) {
            throw new RuntimeException("Problem loading installed patches in isAutoRollbackable() function.", e2);
        }
        for (int i2 = 0; i2 < isProcessed.length; ++i2) {
            isProcessed[i2] = false;
        }
        for (int k2 = 0; k2 < isProcessed.length; ++k2) {
            if (isProcessed[k2]) continue;
            if (autoRBPatches[k2].getIsComposite()) {
                int i3;
                HashSet<String> patchIDsOfComposite = new HashSet<String>();
                String activeField = autoRBPatches[k2].getActiveConstituent();
                for (i3 = 0; i3 < installedPatches.length; ++i3) {
                    if (!installedPatches[i3].getIsComposite() || !installedPatches[i3].getActiveConstituent().equals(activeField)) continue;
                    patchIDsOfComposite.add(installedPatches[i3].getID());
                }
                for (i3 = 0; i3 < autoRBPatches.length; ++i3) {
                    if (!patchIDsOfComposite.contains(autoRBPatches[i3].getID())) continue;
                    patchIDsOfComposite.remove(autoRBPatches[i3].getID());
                    isProcessed[i3] = true;
                }
                Iterator itr = patchIDsOfComposite.iterator();
                String nonSupersettedConstituents = "";
                int[] sortedPatchIDs = new int[patchIDsOfComposite.size()];
                int counter = 0;
                while (itr.hasNext()) {
                    String currentString = (String)itr.next();
                    sortedPatchIDs[counter] = Integer.parseInt(currentString);
                    ++counter;
                }
                Arrays.sort(sortedPatchIDs);
                for (int i4 = sortedPatchIDs.length - 1; i4 >= 0; --i4) {
                    nonSupersettedConstituents = nonSupersettedConstituents + sortedPatchIDs[i4] + ",";
                }
                if (nonSupersettedConstituents.length() > 0) {
                    nonSupersettedConstituents = nonSupersettedConstituents.substring(0, nonSupersettedConstituents.length() - 1);
                }
                if (patchIDsOfComposite.size() != 0) {
                    OLogger.println(OLogger.getString("OUI-67901", new Object[]{patchToApply, activeField, nonSupersettedConstituents}));
                    OPatchStateManagerFactory.getInstance().setErrorCode(67);
                    throw new PrereqFailedException("Only a part of the composite, not the whole composite, is being put up for autorollback.");
                }
                isProcessed[k2] = true;
                continue;
            }
            isProcessed[k2] = true;
        }
    }

    public static void isCompositeAutoRollbackable(String patchToApply, OneOffEntry[] conflictingPatches, OneOffEntry[] patchesNotNeeded, String oracleHomePath) {
        OneOffEntry[] installedPatches;
        boolean[] isProcessed = new boolean[conflictingPatches.length];
        try {
            installedPatches = CompositePatchObject.getInstalledPatches(oracleHomePath);
        }
        catch (Throwable e2) {
            throw new RuntimeException("Problem loading installed patches in isAutoRollbackable() function.", e2);
        }
        for (int i2 = 0; i2 < isProcessed.length; ++i2) {
            isProcessed[i2] = false;
        }
        for (int k2 = 0; k2 < isProcessed.length; ++k2) {
            if (isProcessed[k2]) continue;
            if (conflictingPatches[k2].getIsComposite()) {
                HashSet<String> patchIDsOfComposite = new HashSet<String>();
                String activeField = conflictingPatches[k2].getActiveConstituent();
                for (int i3 = 0; i3 < installedPatches.length; ++i3) {
                    if (!installedPatches[i3].getIsComposite() || !installedPatches[i3].getActiveConstituent().equals(activeField)) continue;
                    patchIDsOfComposite.add(installedPatches[i3].getID());
                }
                ArrayList<String> actualConflictingPatches = new ArrayList<String>();
                for (int j2 = 0; j2 < conflictingPatches.length; ++j2) {
                    String currentID = conflictingPatches[j2].getID();
                    if (!patchIDsOfComposite.contains(currentID)) continue;
                    actualConflictingPatches.add(currentID);
                }
                for (int i4 = 0; i4 < patchesNotNeeded.length; ++i4) {
                    if (!patchIDsOfComposite.contains(patchesNotNeeded[i4].getID())) continue;
                    patchIDsOfComposite.remove(patchesNotNeeded[i4].getID());
                    isProcessed[i4] = true;
                }
                String conflictingConstituents = "";
                int[] sortedPatchIDs = new int[actualConflictingPatches.size()];
                for (int j3 = 0; j3 < actualConflictingPatches.size(); ++j3) {
                    String currentString = (String)actualConflictingPatches.get(j3);
                    sortedPatchIDs[j3] = Integer.parseInt(currentString);
                }
                Arrays.sort(sortedPatchIDs);
                for (int i5 = sortedPatchIDs.length - 1; i5 >= 0; --i5) {
                    conflictingConstituents = conflictingConstituents + sortedPatchIDs[i5] + ",";
                }
                if (conflictingConstituents.length() > 0) {
                    conflictingConstituents = conflictingConstituents.substring(0, conflictingConstituents.length() - 1);
                }
                if (patchIDsOfComposite.size() != 0) {
                    OLogger.println(OLogger.getString("OUI-67901", new Object[]{patchToApply, activeField, conflictingConstituents}));
                    OPatchStateManagerFactory.getInstance().setErrorCode(67);
                    throw new PrereqFailedException("Only a part of the composite, not the whole composite, is being put up for autorollback.");
                }
                isProcessed[k2] = true;
                continue;
            }
            isProcessed[k2] = true;
        }
    }

    public static void isCompositeSubset(ConflictMatrixOutput interOutput, OneOffEntry[] patchesToRollbackOriginal, OneOffEntry patchToApply, String oracleHomePath, String sessionName) {
        ArrayList x;
        String key;
        int i2;
        OneOffEntry[] installedPatches;
        OneOffEntry[] patchesToRollback = new OneOffEntry[]{};
        patchesToRollback = patchesToRollbackOriginal;
        HashMap<String, ArrayList> compositeMap = new HashMap<String, ArrayList>();
        try {
            installedPatches = CompositePatchObject.getInstalledPatches(oracleHomePath);
        }
        catch (Throwable e2) {
            throw new RuntimeException("Problem loading installed patches in isAutoRollbackable() function.", e2);
        }
        int ohOneOffs = interOutput.getColumnLength();
        HashSet<String> supersetList = new HashSet<String>();
        StringBuffer supersetPatches = new StringBuffer();
        for (int j2 = 0; j2 < ohOneOffs; ++j2) {
            if (interOutput.getConflictType(0, j2) != ConflictMatrixOutput.ConflictType.BUG_SUBSET) continue;
            supersetList.add(interOutput.getColumnPatchID(0, j2));
        }
        for (i2 = 0; i2 < installedPatches.length; ++i2) {
            if (!installedPatches[i2].getIsComposite() || !supersetList.contains(installedPatches[i2].getID())) continue;
            key = installedPatches[i2].getActiveConstituent();
            if (compositeMap.containsKey(key)) {
                x = (ArrayList)compositeMap.get(key);
                x.add(installedPatches[i2]);
                compositeMap.put(key, x);
                continue;
            }
            x = new ArrayList();
            x.add(installedPatches[i2]);
            compositeMap.put(key, x);
        }
        for (i2 = 0; i2 < patchesToRollback.length; ++i2) {
            if (!patchesToRollback[i2].getIsComposite()) continue;
            key = patchesToRollback[i2].getActiveConstituent();
            if (compositeMap.containsKey(key)) {
                x = (ArrayList)compositeMap.get(key);
                x.add(patchesToRollback[i2]);
                compositeMap.put(key, x);
                continue;
            }
            x = new ArrayList();
            x.add(patchesToRollback[i2]);
            compositeMap.put(key, x);
        }
        Collection values = compositeMap.values();
        Iterator iter = values.iterator();
        String listOfSupersets = "";
        while (iter.hasNext()) {
            ArrayList currentListOfComposites = (ArrayList)iter.next();
            OneOffEntry combinedComposite = (OneOffEntry)((OneOffEntry)currentListOfComposites.get(0)).clone();
            combinedComposite.combineConstituent(currentListOfComposites);
            boolean bugExists = false;
            String[] compositeBugsFixed = combinedComposite.getBugIDsFixed();
            String[] patchBugsFixed = patchToApply.getBugIDsFixed();
            for (int i3 = 0; i3 < patchBugsFixed.length; ++i3) {
                bugExists = false;
                for (int j3 = 0; j3 < compositeBugsFixed.length; ++j3) {
                    if (!patchBugsFixed[i3].equals(compositeBugsFixed[j3])) continue;
                    bugExists = true;
                }
                if (!bugExists) break;
            }
            if (!bugExists) continue;
            listOfSupersets = listOfSupersets + ", " + combinedComposite.getActiveConstituent() + "";
        }
        if (!listOfSupersets.equals("")) {
            listOfSupersets = listOfSupersets.substring(1);
            OLogger.info("OUI-67072", new Object[]{patchToApply.getID(), listOfSupersets, oracleHomePath});
            if (sessionName.equals("apply")) {
                OPatchStateManagerFactory.getInstance().setErrorCode(56);
                PrereqFailedException re = new PrereqFailedException("Given patch is a subset patch.");
                throw re;
            }
        }
    }

    public static void checkCompositeNRollback(String[] patchesToRollback, String oracleHomePath) {
        int i2;
        OneOffEntry[] installedPatches;
        boolean isError = false;
        ArrayList<String> compositePatches = new ArrayList<String>();
        try {
            installedPatches = CompositePatchObject.getInstalledPatches(oracleHomePath);
        }
        catch (Throwable e2) {
            throw new RuntimeException("Problem loading installed patches in checkCompositeNRollback() function.", e2);
        }
        HashMap<String, OneOffEntry> patchesInOH = new HashMap<String, OneOffEntry>();
        for (i2 = 0; i2 < installedPatches.length; ++i2) {
            patchesInOH.put(installedPatches[i2].getID(), installedPatches[i2]);
        }
        for (i2 = 0; i2 < patchesToRollback.length; ++i2) {
            OneOffEntry currentPatch;
            if (!patchesInOH.containsKey(patchesToRollback[i2]) || !(currentPatch = (OneOffEntry)patchesInOH.get(patchesToRollback[i2])).getIsComposite()) continue;
            isError = true;
            compositePatches.add(patchesToRollback[i2]);
        }
        if (isError) {
            String errorPatches = "";
            for (int j2 = 0; j2 < compositePatches.size(); ++j2) {
                errorPatches = errorPatches + "," + compositePatches.get(j2);
            }
            errorPatches = errorPatches.substring(1);
            String errorMsg = OLogger.getString("OUI-67926", new Object[]{errorPatches});
            throw new RuntimeException(errorMsg);
        }
    }

    public static ArrayList determineCompositeIndices(OneOffEntry[] patchesToApply) {
        ArrayList<Integer> output = new ArrayList<Integer>();
        int i2 = 0;
        for (i2 = 0; i2 < patchesToApply.length; ++i2) {
            if (!patchesToApply[i2].getIsComposite()) continue;
            output.add(i2);
            break;
        }
        for (int j2 = patchesToApply.length - 1; j2 >= 0; --j2) {
            if (!patchesToApply[j2].getIsComposite()) continue;
            output.add(j2);
            break;
        }
        return output;
    }

    public static ArrayList determineCompositeIndices(PatchObject[] patchesToApply) {
        ArrayList<Integer> output = new ArrayList<Integer>();
        int i2 = 0;
        for (i2 = 0; i2 < patchesToApply.length; ++i2) {
            if (!patchesToApply[i2].getIsComposite()) continue;
            output.add(i2);
            break;
        }
        for (int j2 = patchesToApply.length - 1; j2 >= 0; --j2) {
            if (!patchesToApply[j2].getIsComposite()) continue;
            output.add(j2);
            break;
        }
        return output;
    }

    public static OneOffEntry[] getCompositeInputForCheckConflictAmongPatches(String oracleHomePath, ArrayList<OneOffEntry> oneoffs, ArrayList<OneOffEntry> subPatches) {
        String activeSubPatchID = subPatches.get(subPatches.size() - 1).getID();
        for (int i2 = 0; i2 < oneoffs.size(); ++i2) {
            int asdf;
            String[] overlays = oneoffs.get(i2).getOverLayPatchIDs();
            String[] prereqs = oneoffs.get(i2).getPrereqPatchIDs();
            String overs = "";
            for (asdf = 0; asdf < overlays.length; ++asdf) {
                overs = overs + overlays[asdf] + ",";
            }
            overs = "";
            for (asdf = 0; asdf < prereqs.length; ++asdf) {
                overs = overs + prereqs[asdf] + ",";
            }
            int highestSubPatchOverlayIndex = -1;
            for (int j2 = 0; j2 < overlays.length; ++j2) {
                for (int k2 = 0; k2 < subPatches.size(); ++k2) {
                    if (!overlays[j2].equals(subPatches.get(k2).getID()) || k2 <= highestSubPatchOverlayIndex) continue;
                    highestSubPatchOverlayIndex = k2;
                }
            }
            if (highestSubPatchOverlayIndex != -1 && highestSubPatchOverlayIndex < subPatches.size() - 1) {
                ArrayList<OneOffEntry> oneoffCheck = new ArrayList<OneOffEntry>();
                oneoffCheck.add(oneoffs.get(i2));
                for (int l2 = highestSubPatchOverlayIndex; l2 < subPatches.size(); ++l2) {
                    oneoffCheck.add(subPatches.get(l2));
                }
                OneOffEntry[] oneoffsToCheck = new OneOffEntry[oneoffCheck.size()];
                oneoffCheck.toArray(oneoffsToCheck);
                if (PrereqAPI.checkConflictAmongPatchesWithDetail(oracleHomePath, oneoffsToCheck).getResult() == PrereqResult.ExecuteStatus.PASSED) {
                    String[] newOverlays = new String[overlays.length + 1];
                    for (int j3 = 0; j3 < overlays.length; ++j3) {
                        newOverlays[j3] = overlays[j3];
                    }
                    newOverlays[newOverlays.length - 1] = activeSubPatchID;
                    oneoffs.get(i2).setOverLayPatchIDs(newOverlays);
                }
            }
            ArrayList<String> newPrereqsList = new ArrayList<String>();
            for (int j4 = 0; j4 < prereqs.length; ++j4) {
                boolean isSubPatch = false;
                for (int k3 = 0; k3 < subPatches.size(); ++k3) {
                    if (!prereqs[j4].equals(subPatches.get(k3).getID())) continue;
                    isSubPatch = true;
                }
                if (isSubPatch) continue;
                newPrereqsList.add(prereqs[j4]);
            }
            newPrereqsList.add(activeSubPatchID);
            String[] newPrereqs = new String[newPrereqsList.size()];
            newPrereqsList.toArray(newPrereqs);
            oneoffs.get(i2).setPrereqPatchIDs(newPrereqs);
        }
        OneOffEntry[] inputArray = new OneOffEntry[oneoffs.size() + 1];
        OneOffEntry combinedCompositePatch = subPatches.get(subPatches.size() - 1);
        combinedCompositePatch.combineConstituent(subPatches);
        inputArray[0] = combinedCompositePatch;
        for (int i3 = 0; i3 < oneoffs.size(); ++i3) {
            inputArray[i3 + 1] = oneoffs.get(i3);
        }
        return inputArray;
    }

    public static void printOverlaysAndPrereqs(ArrayList<OneOffEntry> patches) {
        for (int i2 = 0; i2 < patches.size(); ++i2) {
            String[] overlays = patches.get(i2).getOverLayPatchIDs();
            String[] prereqs = patches.get(i2).getPrereqPatchIDs();
            OLogger.println("patch id is " + patches.get(i2).getID());
            String overs = "";
            String pres = "";
            for (int asdf = 0; asdf < overlays.length; ++asdf) {
                overs = overs + overlays[asdf] + " ";
                pres = pres + prereqs[asdf] + " ";
            }
            OLogger.println("overlays for patch are: " + overs);
            OLogger.println("prereqs for patch are: " + pres);
        }
    }

    private static OneOffEntry[] getInstalledPatches(String oracleHomePath) throws Throwable {
        IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
        return readServices.getInstalledPatches();
    }

    public static String[] getOverrideUPIs(String compositeFileLocation) {
        if (compositeFileLocation == null || compositeFileLocation.isEmpty()) {
            return new String[0];
        }
        Path compositePatchFile = WrapperFactory.getNioServiceWrapper().getPath(compositeFileLocation, new String[0]);
        if (!Files.exists(compositePatchFile, new LinkOption[0])) {
            return new String[0];
        }
        Document document = PatchObjectUtil.parseXMLFile(compositePatchFile);
        Node composite_node = document.getFirstChild();
        NodeList children_of_composite = composite_node.getChildNodes();
        boolean no_overriding_upis = true;
        int j2 = 0;
        for (j2 = 0; j2 < children_of_composite.getLength(); ++j2) {
            if (!children_of_composite.item(j2).getNodeName().equals("replaces_upis")) continue;
            no_overriding_upis = false;
            break;
        }
        if (no_overriding_upis) {
            return new String[0];
        }
        Node upis_node = children_of_composite.item(j2);
        NodeList upi_list = upis_node.getChildNodes();
        ArrayList<String> all_upis = new ArrayList<String>();
        for (int i2 = 0; i2 < upi_list.getLength(); ++i2) {
            if (upi_list.item(i2).getNodeName().equals("#text") || upi_list.item(i2).getNodeName().equals("#comment")) continue;
            Element cur_node = (Element)upi_list.item(i2);
            all_upis.add(cur_node.getTextContent());
        }
        String[] overriding_upis = new String[all_upis.size()];
        all_upis.toArray(overriding_upis);
        return overriding_upis;
    }
}

