/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.api;

import java.util.List;

public interface PatchAutomation {
    public List<Variable> getVariables();

    public List<J2EELifecycleAction> getJ2EELifeCycleActions(PatchingPhase var1);

    public List<DeployAction> getDeployActions(PatchingPhase var1);

    public List<CommandAction> getCommandActions(PatchingPhase var1);

    public static interface CommandAction
    extends Action {
        public List<Command> getCommand();
    }

    public static interface Command {
        public String getCurrentWorkingDir();

        public List<EnvVar> getEnvVar();

        public List<String> getParameter();

        public Source getSource();

        public static interface Source {
            public String getType();

            public String getValue();
        }

        public static interface EnvVar {
            public String getName();

            public String getValue();
        }
    }

    public static interface DeployAction
    extends Action {
        public List<DeployArtifact> getDeployArtifacts();

        public String getDomain();
    }

    public static interface DeployArtifact {
        public String getDestinationPath();

        public String getFileName();

        public String getName();

        public String getRevision();

        public Boolean getBaseCompositeDeployment();
    }

    public static interface J2EELifecycleAction
    extends LifecycleAction {
        public String getDomain();

        public List<String> getApplicableEntityNames();
    }

    public static interface LifecycleAction
    extends Action {
        public List<Dependency> getDependency();

        public static interface Dependency {
            public Readme getReadme();

            public String getType();
        }
    }

    public static interface Action {
        public String getActsOn();

        public OnErrorType getOnError();

        public Readme getReadme();

        public String getRunAs();

        public ServiceStatus getServiceStatus();

        public Stripe getStripe();

        public String getTag();

        public String getType();

        public String getWhilePatching();

        public Boolean getActsOnClone();

        public Boolean getCmdRequiredPassword();
    }

    public static interface Stripe {
        public String getHomeType();

        public String getName();

        public String getTargetHome();
    }

    public static interface UserMessage {
        public String getPropertyKey();

        public String getValue();
    }

    public static interface Readme {
        public UserMessage getUserMessage();

        public List<Parameter> getParameter();

        public UserMessage getTitle();

        public UserMessage getTroubleshoot();

        public static interface Parameter {
            public String getName();

            public String getType();

            public String getValue();
        }
    }

    public static interface Variable {
        public String getName();

        public Boolean isRequired();

        public Boolean isSecured();

        public String getDefaultValue();

        public UserMessage getPromptUser();
    }

    public static enum ServiceStatus {
        UP("up"),
        LIMITED("limited"),
        DOWN("down");

        private final String value;

        private ServiceStatus(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ServiceStatus fromValue(String v) {
            for (ServiceStatus c : ServiceStatus.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    public static enum OnErrorType {
        ABORT("abort"),
        RESTORE_ABORT("restore,abort"),
        CONTINUE("continue");

        private final String value;

        private OnErrorType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static OnErrorType fromValue(String v) {
            for (OnErrorType c : OnErrorType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    public static enum PatchingPhase {
        PRE_PATCH_APPLICATION("pre-patch-application"),
        PATCH_APPLICATION("patch-application"),
        POST_PATCH_APPLICATION("post-patch-application"),
        POST_PATCH_GI_APPLICATION("post-patch-gi-application"),
        POST_PATCH_RAC_APPLICATION("post-patch-rac-application");

        private final String value;

        private PatchingPhase(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static PatchingPhase fromValue(String v) {
            for (PatchingPhase c : PatchingPhase.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

