/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.utils;

import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.reporting.Reporter;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.driver.crs.CRSDummyProductDriver;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.utils.PrintCookie;
import dbmodel.SystemInstance;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrintMultiNodeCookie {
    private static final Logger _logger = Logger.getLogger(PrintCookie.class.getName());
    public static final String LOG_FILENAME_DATE_FORMAT = "yyyy-MM-dd_hh-mm-ssa";
    public static final String DEFAULT_LOG_DIR = "cfgtoollogs";
    public static final String OPATCH_AUTO_NAMESPACE = "opatchauto";
    private static final String OPATCH_AUTO_DB_NAMESPACE = "opatchautodb";
    public static final String APPLY_COOKIE_NAMESPACE = "OOPApplyState";
    public static final String SWITCHBACK_COOKIE_NAMESPACE = "OOPRollbackState";
    public static final String SESSION_STATE_NAMESPACE = "OOPSessionState";
    private static final String CUSTOM_LOG_DIR = "-customLogDir";
    private static String oracleHome;
    private static String log;
    private static String host;
    private static CRSDummyProductDriver crsPD;
    private static String _cookie;
    private static Set<String> cookies;
    private static HashMap<String, String> hostCookieMap;
    private static String source;
    private static String dst;
    private static String sb_source;
    private static String sb_dst;
    private static String scpCmd;
    private static File oopApplySessionInfoFile;
    private static File oopRollbackSessionInfoFile;
    private static ArrayList<String> argsList;
    private static int logDirIndex;
    private static String logDir;

    public static void main(String[] args) throws OPatchAutoException {
        oracleHome = System.getProperty("OPatch.ORACLE_HOME");
        SystemInstance systemInstance = null;
        PrintMultiNodeCookie.initLogFactory(SESSION_STATE_NAMESPACE);
        host = DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost());
        argsList = new ArrayList();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        logDirIndex = argsList.indexOf(CUSTOM_LOG_DIR);
        logDir = argsList.get(logDirIndex + 1);
        boolean canDeleteSystemFile = false;
        try {
            PrintMultiNodeCookie.setupReporting();
            _logger.info("OPatchAuto version: " + OPatchAutoHelper.getInstance().getOPatchAutoVersion());
            String filePath = PrintMultiNodeCookie.getDefaultLogDirectoryLocation(logDir) + File.separator + "opatch_gi_oopcollectallstate_config.xml";
            File systemInstanceFile = null;
            File file = new File(filePath);
            _logger.info("systeminstance file path " + file.getAbsolutePath());
            if (file.exists()) {
                systemInstanceFile = file;
                canDeleteSystemFile = true;
            }
            if (systemInstanceFile != null) {
                crsPD = new CRSDummyProductDriver();
                crsPD.setDummyConfigFile(systemInstanceFile);
                systemInstance = crsPD.constructSystemInstance();
            }
            List OHList = systemInstance.getTargetsOfType(OracleHome.class);
            List hostList = systemInstance.getTargetsOfType(Host.class);
            String localHost = "";
            for (Host host : hostList) {
                if (DBPatchingHelper.isRemoteHost(host)) continue;
                localHost = host.getHostName();
                _logger.log(Level.INFO, "Local host " + localHost);
                break;
            }
            DBPatchingHelper.setupEnvironment(System.getProperty("OPatch.ORACLE_HOME"), System.getProperty("OPatch.ORACLE_HOME") + File.separator + "oraInst.loc");
            ArrayList<String> sysInstHostList = new ArrayList<String>();
            _logger.info(" System Instance OHList size " + OHList.size());
            if (OHList != null && !OHList.isEmpty()) {
                for (int i = 0; i < OHList.size(); ++i) {
                    OracleHome OH = (OracleHome)OHList.get(i);
                    for (Host sysInstHost : OH.getHosts()) {
                        _logger.info(" OH  hostname " + sysInstHost.getHostName());
                        String hostName = sysInstHost.getHostName();
                        _logger.log(Level.INFO, "OH path " + OH.getPath());
                        String ohLocation = OH.getPath();
                        if (!hostName.contentEquals(localHost)) {
                            sysInstHostList.add(sysInstHost.getHostName());
                            source = ohLocation + DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
                            source = source.replace("$HOST_NAME", hostName);
                            dst = ohLocation + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + hostName + "_" + "oopsessioninfo.ser";
                            scpCmd = "scp " + OH.getOwner() + "@" + hostName + ":" + source + " " + dst;
                            _logger.log(Level.INFO, "scp command " + scpCmd);
                            Credential cred = null;
                            boolean isOK = DBPatchingUtil.scpCookieFile(scpCmd, OH.getOwner(), cred);
                            if (!isOK) {
                                _logger.fine("Unable to scp apply cookie file from host " + hostName);
                            }
                            if ((oopApplySessionInfoFile = new File(dst)).exists()) {
                                Reporting.report((String)("\nCollect OOP session info for host " + hostName + " and home " + ohLocation + "\n"));
                                _logger.info("Start OOP Apply cookie print for host " + hostName + " and home " + ohLocation);
                                Reporting.report((String)("The OOP apply session file path is  " + oopApplySessionInfoFile.getAbsolutePath()));
                                PrintMultiNodeCookie.printOOPSessionCookie(oopApplySessionInfoFile, hostName + ":" + source);
                                _logger.info("End OOP Apply cookie print for host " + hostName + " and home " + ohLocation);
                            }
                            sb_source = ohLocation + DBCommonPatchingConstants.OOP_SESSION_INFO_FILE_SWITCHBACK;
                            sb_source = sb_source.replace("$HOST_NAME", hostName);
                            sb_dst = ohLocation + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + hostName + "_" + "oopsessioninfo_switchback.ser";
                            scpCmd = "scp " + OH.getOwner() + "@" + hostName + ":" + sb_source + " " + sb_dst;
                            _logger.log(Level.INFO, "scp switchback command " + scpCmd);
                            isOK = DBPatchingUtil.scpCookieFile(scpCmd, OH.getOwner(), cred);
                            if (!isOK) {
                                _logger.fine("Unable to scp switchback cookie file from host " + hostName);
                            }
                            if (!(oopRollbackSessionInfoFile = new File(sb_dst)).exists()) continue;
                            _logger.info("Start OOP Switchback cookie print for host " + hostName + " and home " + ohLocation);
                            Reporting.report((String)("The OOP switchback session file path is  " + oopRollbackSessionInfoFile.getAbsolutePath()));
                            PrintMultiNodeCookie.printOOPSessionCookie(oopRollbackSessionInfoFile, hostName + ":" + sb_source);
                            _logger.info("End OOP switchback cookie print for host " + hostName + " and home " + ohLocation);
                            continue;
                        }
                        source = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
                        source = source.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
                        oopApplySessionInfoFile = new File(ohLocation + source);
                        if (oopApplySessionInfoFile.exists()) {
                            Reporting.report((String)("\nCollect OOP session info for host " + hostName + " and home " + ohLocation + "\n"));
                            _logger.info("Start OOP Apply cookie print for host " + hostName + " and home " + ohLocation);
                            Reporting.report((String)("The OOP apply session file path is  " + oopApplySessionInfoFile.getAbsolutePath()));
                            PrintMultiNodeCookie.printOOPSessionCookie(oopApplySessionInfoFile, hostName + ":" + oopApplySessionInfoFile.getAbsolutePath());
                            _logger.info("End OOP Apply cookie print for host " + hostName + " and home " + ohLocation);
                        }
                        sb_source = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE_SWITCHBACK;
                        sb_source = sb_source.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
                        oopRollbackSessionInfoFile = new File(ohLocation + sb_source);
                        if (!oopRollbackSessionInfoFile.exists()) continue;
                        _logger.info("Start OOP Switchback cookie print for host " + hostName + " and home " + ohLocation);
                        Reporting.report((String)("The OOP switchback session file path is  " + oopRollbackSessionInfoFile.getAbsolutePath()));
                        PrintMultiNodeCookie.printOOPSessionCookie(oopRollbackSessionInfoFile, hostName + ":" + oopRollbackSessionInfoFile.getAbsolutePath());
                        _logger.info("End OOP switchback cookie print for host " + hostName + " and home " + ohLocation);
                    }
                }
            }
            if (canDeleteSystemFile) {
                systemInstanceFile.delete();
            }
        }
        catch (Exception e) {
            Reporting.report((String)e.getMessage());
        }
    }

    private static void setupReporting() throws OPatchAutoException {
        Reporter defaultReporter = Reporting.getDefaultReporter();
    }

    public static void initLogFactory(String fileName) {
        log = PrintMultiNodeCookie.getDefaultLogFileLocation(oracleHome, fileName);
        LogFactory logFactory = LogFactory.getFactory();
        logFactory.setupLogging(log, "INFO", true, new String[0]);
        Reporting.report((String)("The OOP session state log file path is  " + log + "\n"));
    }

    public static String getDefaultLogDir(String home) {
        return home.trim() + File.separator + DEFAULT_LOG_DIR + File.separator + OPATCH_AUTO_NAMESPACE;
    }

    public static String getDefaultLogFileLocation(String home, String fileName) {
        return PrintMultiNodeCookie.getDefaultLogDir(home) + File.separator + fileName + OPatchAutoHelper.getCurrentDateTimeStamp((String)LOG_FILENAME_DATE_FORMAT) + ".log";
    }

    public static void printOOPSessionCookie(File oopSessionCookieFile, String hostPath) throws OPatchAutoException {
        OOPSessionCookie cookie = null;
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        boolean found = false;
        try {
            inputStream = new FileInputStream(oopSessionCookieFile);
            objectInputStream = new ObjectInputStream(inputStream);
            cookie = (OOPSessionCookie)objectInputStream.readObject();
            if (cookie == null) {
                _logger.info("cookie is null");
            } else if (hostCookieMap.size() == 0) {
                hostCookieMap.put(hostPath, cookie.toString());
                _logger.info(hostPath + " cookie:");
                _logger.info(cookie.toString());
            } else {
                for (Map.Entry<String, String> entry : hostCookieMap.entrySet()) {
                    if (!entry.getValue().contentEquals(cookie.toString())) continue;
                    _logger.info(hostPath + " cookie is same as " + entry.getKey());
                    found = true;
                    break;
                }
                if (!found) {
                    hostCookieMap.put(hostPath, cookie.toString());
                    _logger.info(hostPath + " cookie:");
                    _logger.info(cookie.toString());
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            _logger.info("cookie exception");
            throw new OPatchAutoException((Throwable)e);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException((Throwable)e);
            }
        }
    }

    private static String getDefaultLogDirectoryLocation(String logDir) {
        return logDir.trim() + File.separator + OPATCH_AUTO_DB_NAMESPACE;
    }

    static {
        log = "";
        host = "";
        _cookie = "";
        cookies = new HashSet<String>();
        hostCookieMap = new HashMap();
        source = "";
        dst = "";
        sb_source = "";
        sb_dst = "";
        scpCmd = "";
    }
}

