/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.utils.remote.IRemoteCommandResult;
import com.oracle.glcm.patch.auto.db.utils.remote.RemoteCommandExecutor;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Topology;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TargetRootSessionValidator
implements IValidator,
IRemoteCommandResult {
    private Logger logger = Logger.getLogger(TargetRootSessionValidator.class.getName());
    private List<Thread> remoteHandlers = new ArrayList<Thread>();
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
    private Map<Home, String> outPutMap = new ConcurrentHashMap<Home, String>();

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        block9: {
            this.logger.log(Level.FINE, "Reading target root session info file to compare root id with catalog session id.");
            String rootSessionid = (String)params.get(ValidationParamKey.SESSION_ID.ordinal());
            Topology topology = (Topology)params.get(ValidationParamKey.PSEUDO_TOPOLOGY.ordinal());
            boolean isSdbMode = false;
            if (params.get(ValidationParamKey.SDB_OPTION.ordinal()) != null) {
                isSdbMode = (Boolean)params.get(ValidationParamKey.SDB_OPTION.ordinal());
            }
            boolean isResume = false;
            if (params.get(OPatchAutoCommand.resume.ordinal()) != null) {
                isResume = (Boolean)params.get(OPatchAutoCommand.resume.ordinal());
            }
            try {
                if (isSdbMode && isResume) {
                    Set hosts = topology.getHosts();
                    for (Host host : hosts) {
                        if (host.isRemote()) {
                            this.verifyRootSessionOnRemote(host, rootSessionid);
                            continue;
                        }
                        this.verifyRootSessionOnLocal(host, rootSessionid);
                    }
                    this.startRemoteExecution();
                    if (!this.multipleValidationResult.isEmpty()) {
                        List<ValidationResult> resultList = this.multipleValidationResult.getValidationResultList();
                        for (ValidationResult result : resultList) {
                            if (result.getStatus() != ValidationResult.ValidationStatus.FAILED) continue;
                            return this.multipleValidationResult;
                        }
                    }
                    break block9;
                }
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Validation not required"));
                return this.multipleValidationResult;
            }
            catch (OPatchAutoException e) {
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.TARGET_ROOT_SESSION_ID_CHECK, (Object)e));
            }
        }
        return this.multipleValidationResult;
    }

    private void startRemoteExecution() {
        for (Thread t : this.remoteHandlers) {
            t.start();
        }
        for (Thread t : this.remoteHandlers) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                this.logger.warning("InterruptedException: " + e.getMessage());
            }
        }
    }

    private void verifyRootSessionOnLocal(Host host, String rootSessionId) {
        for (Home home : host.getHomes()) {
            this.logger.info("checking root session info details for home : " + home.getLocation() + " in current host");
            GISystemCall.ExecReturn ret = this.executeCommand(host, home, rootSessionId);
            if (!ret.isOK()) {
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"DBValidationController.target.root.session.id.failed", (Object[])new Object[]{home.getLocation(), host.getHost(), ret.getErrorMessage()}));
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.TARGET_ROOT_SESSION_ID_CHECK, "Not able to retrieve root session info details"));
                continue;
            }
            this.logger.finest("Root session info of home: " + home.getLocation() + ":" + ret.getNormalMessage());
            this.outPutMap.put(home, ret.getNormalMessage());
        }
    }

    private GISystemCall.ExecReturn executeCommand(Host host, Home home, String rootSessionId) {
        String commandToExecute = this.getCommandToExecute(home, rootSessionId);
        GISystemCall.ExecReturn ret = GISystemCall.process(commandToExecute, host.getUsername(), host.getPassword());
        return ret;
    }

    private void verifyRootSessionOnRemote(Host host, String rootSessionId) {
        RemoteCommandExecutor remoteHandler = new RemoteCommandExecutor(host, this);
        Iterator itr = host.getHomes().iterator();
        HashMap<Home, String> commandList = new HashMap<Home, String>();
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                Home home = (Home)itr.next();
                this.logger.info("validating root session info file in the home : " + home.getLocation() + " in host:" + host.getHost());
                String command = this.getCommandToExecute(home, rootSessionId);
                commandList.put(home, command);
            }
            if (!commandList.isEmpty()) {
                remoteHandler.setCommandToExecuteInHomes(commandList);
                Thread t = new Thread(remoteHandler);
                this.remoteHandlers.add(t);
            } else {
                this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "No target to verify"));
            }
        } else {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "No target to verify"));
        }
    }

    private String getCommandToExecute(Home home, String rootSessionId) {
        String OH_Path = home.getLocation();
        StringBuilder perlPath = new StringBuilder();
        String PERL_PATH = File.separator + "perl" + File.separator + "bin" + File.separator + "perl ";
        perlPath.append(OH_Path).append(PERL_PATH);
        String command = perlPath + OH_Path + File.separator + "OPatch" + File.separator + "auto" + File.separator + "database" + File.separator + "bin" + File.separator + "RootSessionValidation.pl -parentid " + rootSessionId + " -customConfigDir " + SessionData.getConfigDir();
        return command;
    }

    @Override
    public void notifyResult(int resultID, String resultMsg, Host host, Home home, Thread executedThread, Object payload) {
        ValidationResult validationResult = null;
        if (resultID == 0) {
            this.logger.info("Root session info of home: " + home.getLocation() + ", in " + host.getHost() + " :" + resultMsg);
            this.outPutMap.put(home, resultMsg);
        } else {
            validationResult = new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.TARGET_ROOT_SESSION_ID_CHECK, resultMsg);
            this.logger.info("Validation failed: " + DBValidationFailureReason.TARGET_ROOT_SESSION_ID_CHECK.name());
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"DBValidationController.target.root.session.id.failed", (Object[])new Object[]{home.getLocation(), host.getHost(), resultMsg}));
            this.multipleValidationResult.addValidationResult(validationResult);
        }
    }
}

