/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SDBOptionsValidator
implements IValidator {
    private static final Logger logger = Logger.getLogger(SDBOptionsValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        logger.log(Level.FINE, "Invoking SDBOptions validation to check whether user supplied options are correct or not.");
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        String dgOptionStr = (String)params.get(ValidationParamKey.DG_OPTION.ordinal());
        List<String> dgOptions = PatchActionUtil.convertStringToList(dgOptionStr);
        String shardGrpStr = (String)params.get(ValidationParamKey.SHARD_GROUP.ordinal());
        List<String> shardGroupOptions = PatchActionUtil.convertStringToList(shardGrpStr);
        String shardSpcStr = (String)params.get(ValidationParamKey.SHARD_SPACE.ordinal());
        List<String> shardSpaceOptions = PatchActionUtil.convertStringToList(shardSpcStr);
        String shardingType = PatchActionUtil.getShardingType(systemInst);
        ArrayList<String> catalogShardGrps = new ArrayList<String>();
        ArrayList<String> catalogShardSpcs = new ArrayList<String>();
        ArrayList<String> catalogDataguards = new ArrayList<String>();
        ArrayList databases = new ArrayList();
        databases.addAll(systemInst.getTargetsOfType(SIDatabase.class));
        databases.addAll(systemInst.getTargetsOfType(RACDatabase.class));
        boolean isPrimary = false;
        boolean isOgg = PatchActionUtil.isOgg(systemInst);
        for (AbstractBaseTarget database : databases) {
            RACDatabase racdb;
            ShardProperty shardProp = null;
            isPrimary = false;
            if (database instanceof SIDatabase) {
                SIDatabase sidb = (SIDatabase)database;
                shardProp = sidb.getShardProperty();
                if (shardProp.getDrsetNumber() != null && sidb.getPrimary()) {
                    isPrimary = true;
                }
            } else if (database instanceof RACDatabase && (shardProp = (racdb = (RACDatabase)database).getShardProperty()).getDrsetNumber() != null && racdb.getPrimary()) {
                isPrimary = true;
            }
            if (null != shardProp && !catalogShardGrps.contains(shardProp.getShardGroupName())) {
                catalogShardGrps.add(shardProp.getShardGroupName());
            }
            if (null != shardProp && !catalogShardSpcs.contains(shardProp.getShardSpaceName())) {
                catalogShardSpcs.add(shardProp.getShardSpaceName());
            }
            if (!isPrimary || catalogDataguards.contains(shardProp.getShardName())) continue;
            catalogDataguards.add(shardProp.getShardName());
        }
        if (shardingType.equalsIgnoreCase("user-defined") && !StringUtil.isNullOrEmpty((String)shardGrpStr)) {
            return this.displayOptionErrorMsg(multipleValidationResult, "", "SHARDGROUP_NOT_APPLICABLE_FOR_USER_DEFINED", DBValidationFailureReason.SHARDGROUP_NOT_APPLICABLE_FOR_USER_DEFINED);
        }
        if (!isOgg && !StringUtil.isNullOrEmpty((String)shardGrpStr)) {
            return this.displayOptionErrorMsg(multipleValidationResult, "", "SHARDGROUP_NOT_APPLICABLE_FOR_DG", DBValidationFailureReason.SHARDGROUP_NOT_APPLICABLE_FOR_DG);
        }
        if (isOgg && !StringUtil.isNullOrEmpty((String)dgOptionStr)) {
            return this.displayOptionErrorMsg(multipleValidationResult, dgOptionStr, "DG_NOT_APPLICABLE_FOR_OGG", DBValidationFailureReason.DG_NOT_APPLICABLE_FOR_OGG);
        }
        ArrayList<String> invalidShdGrpList = new ArrayList<String>();
        if (!(StringUtil.isNullOrEmpty((String)shardGrpStr) || catalogShardGrps == null || catalogShardGrps.isEmpty() || shardGroupOptions == null || shardGroupOptions.isEmpty())) {
            this.collectInvalidOptionList(shardGroupOptions, catalogShardGrps, invalidShdGrpList);
        }
        ArrayList<String> invalidShdSpcList = new ArrayList<String>();
        if (!(StringUtil.isNullOrEmpty((String)shardSpcStr) || catalogShardSpcs == null || catalogShardSpcs.isEmpty() || shardSpaceOptions == null || shardSpaceOptions.isEmpty())) {
            this.collectInvalidOptionList(shardSpaceOptions, catalogShardSpcs, invalidShdSpcList);
        }
        ArrayList<String> invalidDgList = new ArrayList<String>();
        if (!(StringUtil.isNullOrEmpty((String)dgOptionStr) || catalogDataguards == null || catalogDataguards.isEmpty() || dgOptions == null || dgOptions.isEmpty())) {
            this.collectInvalidOptionList(dgOptions, catalogDataguards, invalidDgList);
        }
        if (invalidShdGrpList != null && invalidShdGrpList.size() > 0) {
            return this.displayOptionErrorMsg(multipleValidationResult, ((Object)invalidShdGrpList).toString(), "INVALID_SHARD_GROUPS", DBValidationFailureReason.INVALID_SHARD_GROUPS);
        }
        if (invalidShdSpcList != null && invalidShdSpcList.size() > 0) {
            return this.displayOptionErrorMsg(multipleValidationResult, ((Object)invalidShdSpcList).toString(), "INVALID_SHARD_SPACES", DBValidationFailureReason.INVALID_SHARD_SPACES);
        }
        if (invalidDgList != null && invalidDgList.size() > 0) {
            return this.displayOptionErrorMsg(multipleValidationResult, ((Object)invalidDgList).toString(), "INVALID_DATA_GUARDS", DBValidationFailureReason.INVALID_DATA_GUARDS);
        }
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private void collectInvalidOptionList(List<String> cmdLineOptions, List<String> catalogEntries, List<String> invalidOptionsList) {
        for (String cmdLineOption : cmdLineOptions) {
            boolean isPresent = false;
            for (String catalogEntry : catalogEntries) {
                if (!cmdLineOption.equalsIgnoreCase(catalogEntry)) continue;
                isPresent = true;
                break;
            }
            if (isPresent) continue;
            invalidOptionsList.add(cmdLineOption);
        }
    }

    private MultipleValidationResult displayOptionErrorMsg(MultipleValidationResult multipleValidationResult, String value, String text, DBValidationFailureReason validationFailureReason) {
        String message = BundleUtils.getMessage(SDBOptionsValidator.class, text, value);
        Reporting.report((String)message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, validationFailureReason, null));
        return multipleValidationResult;
    }
}

