/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatchauto.core.binary.SessionPatches;

public class PatchTypeValidation
implements IValidator {
    Logger logger = Logger.getLogger(PatchTypeValidation.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.FINE, "Checking for patch type");
        String patchLocation = (String)params.get(ValidationParamKey.PATCH_LOC.ordinal());
        SessionPatches.PatchType patchType = SessionPatches.getPatchType((String)patchLocation);
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        String message = null;
        if (SessionPatches.PatchType.SYSTEM_PATCH.equals((Object)patchType)) {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
            message = "Incoming patch is System Patch.";
        } else {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INVALID_PATCH_TYPE, patchLocation));
            StringBuilder str = new StringBuilder("Patch Validation: FAILED\n");
            String report = BundleUtils.getMessage(PatchTypeValidation.class, "INVALID_PATCH_TYPE", new Object[0]);
            Reporting.report((String)report);
            str.append(report);
            message = str.toString();
        }
        this.logger.log(Level.INFO, message);
        return multipleValidationResult;
    }
}

