/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.data.ValidPlatforms;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.SystemInstance;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class PatchApplicableValidator
implements IValidator {
    Logger logger = Logger.getLogger(PatchApplicableValidator.class.getName());
    static List<String> genericPlatformIDList = new ArrayList<String>();

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Invoking rule to check if the Oracle Home has a platform that is one of the supported platform for the given patch.");
        OPatchAutoCommand operation = (OPatchAutoCommand)params.get(ValidationParamKey.OPERATION.ordinal());
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        if (operation.isApply()) {
            PatchPackagesBag patchPackageBag = (PatchPackagesBag)params.get(ValidationParamKey.PATCHPACKAGESBAG.ordinal());
            if (patchPackageBag == null) {
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
                return multipleValidationResult;
            }
            PatchTarget patchTarget = (PatchTarget)params.get(ValidationParamKey.PATCH_TARGET.ordinal());
            SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
            List ohs = systemInst.getTargetsOfType(OracleHome.class);
            String home = patchTarget.getHome().getLocation();
            String platform = "";
            for (OracleHome oh : ohs) {
                if (!oh.getPath().equalsIgnoreCase(home)) continue;
                platform = oh.getARUId();
                break;
            }
            String message = null;
            ArrayList<OPatchPatchInfo> patchList = SessionData.getInstance().getAnalyzedPatchList(home);
            if (patchList != null && !patchList.isEmpty()) {
                for (OPatchPatchInfo patchInfo : patchList) {
                    if (patchInfo.getSupportedPlatForms() == null || patchInfo.getSupportedPlatForms().isEmpty()) {
                        this.logger.log(Level.WARNING, "The patch " + patchInfo.getPatchID() + "doesn't have supported platforms set.");
                        continue;
                    }
                    if (!Collections.disjoint(genericPlatformIDList, patchInfo.getSupportedPlatForms())) {
                        this.logger.log(Level.INFO, "The patch " + patchInfo.getPatchID() + "can be applied on any platform.");
                        continue;
                    }
                    if (!Collections.disjoint(genericPlatformIDList, patchInfo.getSupportedPlatForms()) || platform == null || patchInfo.getSupportedPlatForms().contains(platform)) continue;
                    Integer platformId = Integer.decode(platform);
                    message = "The oracle home " + home + " has a platform " + ValidPlatforms.getDescription(platformId) + " that is not one of the " + "supported platform for the given patch: " + this.getDescription(patchInfo.getSupportedPlatForms());
                    this.logger.log(Level.INFO, message);
                    Reporting.report((String)message);
                    multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INVALID_PLATFORM, home));
                    return multipleValidationResult;
                }
            }
        }
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private List<String> getDescription(List<String> platformIds) {
        ArrayList<String> platforms = new ArrayList<String>();
        for (String platform : platformIds) {
            platforms.add(ValidPlatforms.getDescription(Integer.decode(platform)));
        }
        return platforms;
    }

    static {
        genericPlatformIDList.add("0");
        genericPlatformIDList.add("289");
        genericPlatformIDList.add("2000");
    }
}

