/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.util.PatchPlanUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.sysman.oii.oiii.OiiiVersion;

public class GIAppplicabilityValidation
implements IValidator {
    Logger logger = Logger.getLogger(GIAppplicabilityValidation.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        List oracleHomes = (List)params.get(ValidationParamKey.ORACLE_HOMES.ordinal());
        String invPtrLoc = (String)params.get(ValidationParamKey.INV_PTR_LOC.ordinal());
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        for (String oh : oracleHomes) {
            if (oh != null) {
                oh = PatchPlanUtils.removeFileSeperatorAtEnd(oh);
            }
            if (this.checkOUIVersionGreaterThanReqVersion(oh)) {
                String str = BundleUtils.getMessage(GIAppplicabilityValidation.class, "OPATCHAUTO_OUI_MIN_VERSION", oh);
                Reporting.report((String)str);
                this.logger.log(Level.INFO, str);
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.OUI_NOT_COMPATIBLE, oh));
                return multipleValidationResult;
            }
            ValidationResult validationResult = this.checkApplicableForGIPatching(oh, invPtrLoc);
            if (!validationResult.getStatus().equals((Object)ValidationResult.ValidationStatus.FAILED)) continue;
            multipleValidationResult.addValidationResult(validationResult);
            return multipleValidationResult;
        }
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private boolean checkOUIVersionGreaterThanReqVersion(String oh) {
        OiiiVersion desiredVer = new OiiiVersion("11.2.0.2.0");
        OiiiVersion curOUIVer = new OiiiVersion(OUIDriver.getOUIVersion());
        return desiredVer.laterThan(curOUIVer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult checkApplicableForGIPatching(String oh, String invPtrLoc) {
        String message;
        ClusterInformationLoader ins = null;
        OiiiVersion desiredVer = new OiiiVersion("11.2.0.2.0");
        ValidationResult validationResult = null;
        try {
            ins = ClusterInformationLoader.getInstance();
        }
        catch (Throwable t) {
            message = BundleUtils.getMessage(GIAppplicabilityValidation.class, "NO_CRS", new Object[0]);
            Reporting.report((String)message);
            validationResult = new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_CRS, oh);
            this.logger.log(Level.FINE, "Throwable occured: " + t.getMessage());
        }
        finally {
            String ctrInvLoc = PatchPlanner.getInstance().getOPlanEnv().getCentralInvLoc(invPtrLoc);
            String invLocCommand = "rm -rf " + ctrInvLoc + File.separator + "locks";
            byte[] pwd = null;
            GISystemCall.process(invLocCommand, "root", pwd);
        }
        if (ins.isGridEnv()) {
            try {
                String crsVer = ins.getCrsVersion(ins.isStackRunning());
                OiiiVersion crsCompVer = new OiiiVersion(crsVer);
                if (desiredVer.laterThan(crsCompVer)) {
                    String str = BundleUtils.getMessage(GIAppplicabilityValidation.class, "OPATCHAUTO_CRS_MIN_VERSION", crsVer);
                    this.logger.log(Level.INFO, str);
                    Reporting.report((String)str);
                    validationResult = new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.CRS_VERSION_NOT_SUPPORTED, oh);
                    return validationResult;
                }
            }
            catch (Throwable t) {
                message = BundleUtils.getMessage(GIAppplicabilityValidation.class, "NO_CRS", new Object[0]);
                Reporting.report((String)message);
                validationResult = new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_CRS, oh);
                this.logger.log(Level.FINE, "Throwable occured: " + t.getMessage());
            }
        } else {
            StringBuilder str = new StringBuilder("Grid Infrastructure NOT detected on current system.");
            message = BundleUtils.getMessage(GIAppplicabilityValidation.class, "NO_CRS", new Object[0]);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, str.toString());
            validationResult = new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_CRS, oh);
            return validationResult;
        }
        return validationResult == null ? (validationResult = new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null)) : validationResult;
    }
}

