/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.common.Host;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.sysman.oii.oiii.OiiiVersion;

public class DBStatusValidation
implements IValidator {
    Logger logger = Logger.getLogger(DBStatusValidation.class.getName());
    private List<OracleHome> sessionHomes = new ArrayList<OracleHome>();
    private List<OracleHome> sessionNAHomes = new ArrayList<OracleHome>();
    private String homeType;

    public DBStatusValidation(String homeType) {
        this.homeType = homeType;
    }

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        boolean passed;
        boolean homeListCreated;
        ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        boolean isOOPEnabled = (Boolean)params.get(ValidationParamKey.OOP_ENABLED.ordinal());
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        if (isOOPEnabled) {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
            return multipleValidationResult;
        }
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        OracleHome oraclehome = oracleHomes.get(0);
        List hostList = oraclehome.getHosts();
        String nodeName = null;
        Iterator iterator = hostList.iterator();
        if (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            nodeName = host.getName();
        }
        if (!(homeListCreated = this.populateHomesList(configGraph, nodeName))) {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.FAILED_COLLECT_TOP_COMPONENTS, this.sessionNAHomes));
            return multipleValidationResult;
        }
        boolean remotePatching = (Boolean)params.get(ValidationParamKey.REMOTE_PATCHING.ordinal());
        if (!remotePatching && !(passed = this.isDBRunningOnSharedHome(nodeName, multipleValidationResult))) {
            return multipleValidationResult;
        }
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private boolean isDBRunningOnSharedHome(String nodeName, MultipleValidationResult multipleValidationResult) {
        StringBuffer buff = new StringBuffer();
        boolean passed = true;
        StringBuilder message = new StringBuilder();
        ArrayList<OracleHome> sharedHomeList = new ArrayList<OracleHome>();
        for (OracleHome home : this.sessionHomes) {
            List hosts = home.getHosts();
            if (!home.getIsShared()) continue;
            buff = new StringBuffer("Resources of shared database home \"" + home.getPath() + "\" are running on following remote node(s) : ");
            ArrayList<String> runningNodes = new ArrayList<String>();
            for (Host host : hosts) {
                if (nodeName.equals(host.getHostName())) continue;
                String homePath = home.getPath();
                boolean isDBUp = false;
                byte[] pass = null;
                isDBUp = this.homeType.equals("crs") ? DBPatchingUtil.isDatabaseUp(homePath, System.getProperty("user.name"), pass, host.getHostName()) : DBPatchingUtil.isDatabaseUp(homePath, System.getProperty("user.name"), pass, null);
                if (!isDBUp) continue;
                passed = false;
                runningNodes.add(host.getHostName());
                sharedHomeList.add(home);
            }
            if (passed) continue;
            buff.append(runningNodes.toString() + ".\n");
            message.append(buff.toString());
        }
        if (!passed) {
            this.logger.log(Level.FINE, message.toString());
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.DB_RUNNING_OTHER_NODES_SHARED_HOME, sharedHomeList));
        }
        return passed;
    }

    private boolean populateHomesList(ConfigGraph configGraph, String nodeName) {
        StringBuffer buff = new StringBuffer();
        List<OracleHome> ohList = configGraph.getTargets(OracleHome.class);
        OiiiVersion minVersionSpt = new OiiiVersion("11.2.0.2.0");
        for (OracleHome oh : ohList) {
            List hosts = oh.getHosts();
            ArrayList<String> hostNames = new ArrayList<String>();
            for (Host host : hosts) {
                hostNames.add(host.getNodeName().toLowerCase());
            }
            buff = new StringBuffer("Collected hosts names are " + hostNames.toString());
            buff.append(" Local node name is [ ");
            buff.append(nodeName);
            buff.append(" ]\n");
            this.logger.log(Level.FINE, buff.toString());
            if (!hostNames.contains(nodeName.toLowerCase())) continue;
            String path = oh.getPath();
            String hometype = oh.getHomeType();
            String owner = oh.getOwner();
            List topLevelComps = oh.getTopLevelOUI();
            StringBuffer configInfo = new StringBuffer();
            OUIComponent comp = null;
            if (topLevelComps.size() > 0) {
                comp = (OUIComponent)topLevelComps.get(0);
            }
            configInfo.append(hometype + "_home" + path + "\t");
            if (comp == null || comp.getVersion() == null || comp.getVersion().equals("")) {
                String msg = BundleUtils.getMessage(DBStatusValidation.class, "NO_TOP", path);
                this.logger.log(Level.INFO, msg);
                Reporting.report((String)msg);
                return false;
            }
            configInfo.append("version=" + comp.getVersion() + "\t");
            configInfo.append("owner=" + owner);
            if (minVersionSpt.laterThan(new OiiiVersion(comp.getVersion()))) {
                buff = new StringBuffer("Oracle Home \"" + path + "\"");
                buff.append(" version [ ");
                buff.append(comp.getVersion());
                buff.append(" ] is earlier than ");
                buff.append("11.2.0.2.0");
                buff.append(" and it is not supported by 'opatchauto'. ");
                buff.append("Please patch this home manually and separately.");
                Reporting.report((String)buff.toString());
                this.logger.log(Level.INFO, buff.toString());
                this.sessionNAHomes.add(oh);
                continue;
            }
            if (!hometype.equalsIgnoreCase("rac") && !hometype.equalsIgnoreCase("sidb")) continue;
            if (!this.sessionHomes.isEmpty()) {
                ListIterator<OracleHome> iterator = this.sessionHomes.listIterator();
                while (iterator.hasNext()) {
                    OracleHome oh1 = iterator.next();
                    if (oh1.getPath().equals(oh.getPath())) continue;
                    iterator.add(oh);
                }
                continue;
            }
            this.sessionHomes.add(oh);
        }
        return true;
    }
}

