/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class CluvfyValidator
implements IValidator {
    Logger logger = Logger.getLogger(CluvfyValidator.class.getName());
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
    private final List<String> remoteNodes = SessionData.getInstance().getRemoteList();
    private final boolean isLocalCRSUp = SessionData.getInstance().isLocalCRSUp();

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Running cluvfy validation");
        ClusterInformationLoader.CrsType crsType = ClusterInformationLoader.getInstance().getCRSType();
        this.logger.info("CRS Type is detected to be " + crsType);
        if (crsType.equals((Object)ClusterInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY)) {
            this.logger.info("Grid home is a software-only installation");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "cluvfy Validations will be skipped for a software-only home."));
            return this.multipleValidationResult;
        }
        if (!this.isLocalCRSUp) {
            this.logger.info("Local node CRS is not running.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "cluvfy Validations will be skipped where grid is down on the local node."));
            return this.multipleValidationResult;
        }
        ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        List<Host> hostModelList = configGraph.getTargets(Host.class);
        this.logger.info("Size of the host list is : " + hostModelList.size());
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        String crsHome = null;
        String crsOwner = null;
        boolean isSiha = false;
        for (OracleHome oracleHome : oracleHomes) {
            if (oracleHome.getHomeType().equals("crs")) {
                crsHome = oracleHome.getPath();
                crsOwner = oracleHome.getOwner();
                break;
            }
            if (!oracleHome.getHomeType().equals("siha")) continue;
            crsHome = oracleHome.getPath();
            crsOwner = oracleHome.getOwner();
            isSiha = true;
            break;
        }
        this.logger.info("Is SIHA: " + isSiha);
        if (isSiha) {
            this.logger.info("This is a SIHA environment.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Cluvfy Validation will be skipped for a SIHA."));
            return this.multipleValidationResult;
        }
        String localHost = "";
        for (Host host : hostModelList) {
            if (DBPatchingHelper.isRemoteHost(host)) continue;
            localHost = host.getHostName();
            break;
        }
        if (crsHome == null) {
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "CRS Home not being patched in this session."));
            return this.multipleValidationResult;
        }
        if (!isSiha && this.remoteNodes.size() < 1) {
            this.logger.info("Grid is a single node cluster installation");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Cluvfy Validation will be skipped for a single node GI."));
            return this.multipleValidationResult;
        }
        OPatchAutoCommand oPatchAutoCommand = (OPatchAutoCommand)params.get(ValidationParamKey.OPERATION.ordinal());
        boolean firstNode = this.isFirstNodeOfPatching(crsHome, oPatchAutoCommand.isRollback());
        this.logger.info("First node of patching :" + firstNode);
        if (!firstNode) {
            this.logger.info("This is not the first node of GI patching.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Cluvfy Validation will be skipped for non-first nodes."));
            return this.multipleValidationResult;
        }
        boolean minCluvfyVersion = this.checkMinCluvfyVersion(crsHome, crsOwner);
        if (!minCluvfyVersion) {
            this.logger.info("This home does not have the minimum required cluvfy version.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Cluvfy Validation will be skipped for older versions of cluvfy."));
            return this.multipleValidationResult;
        }
        String reason = null;
        DBValidationFailureReason reasonCode = null;
        GISystemCall.ExecReturn ret = this.runCluvfyCmd(crsHome, crsOwner);
        if (ret == null) {
            reason = "Failed to run cluvfy command.";
            reasonCode = DBValidationFailureReason.GI_PATCHING_STATE_NOT_CLEAN;
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, reasonCode, reason));
        }
        if (ret.isOK()) {
            this.logger.info("Cluvfy Validator successfully executed");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, " Validation Successful"));
        } else {
            reason = "Validations run by the cluvfy command have failed:\n" + ret.getNormalMessage() + "\n" + ret.getErrorMessage() + "\n";
            Reporting.report((String)reason);
            reasonCode = DBValidationFailureReason.GI_PATCHING_STATE_NOT_CLEAN;
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, reasonCode, reason));
        }
        return this.multipleValidationResult;
    }

    private boolean isFirstNodeOfPatching(String crsHome, boolean rollback) {
        boolean first = false;
        HashMap<String, String> hostPatchMap = SessionData.getInstance().getHostPatchDataMap(crsHome);
        return DBPatchingHelper.isFirstNodeOfPatchingForAnyPatch(crsHome, hostPatchMap, rollback);
    }

    private boolean checkMinCluvfyVersion(String crsHome, String owner) {
        boolean versionOK = false;
        String cluvfyFullVersion = "";
        String minVersion = "21.3.0.0.0";
        String commandToExecute = crsHome + File.separator + "bin" + File.separator + "cluvfy -version";
        Credential credential = null;
        try {
            GISystemCall.ExecReturn ret = GISystemCall.process(commandToExecute, owner, credential);
            if (!ret.isOK()) {
                this.logger.info("Failed to check cluvfy version.");
                return false;
            }
            String version = "";
            String[] lines = ret.getNormalMessage().split("\\r?\\n");
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].indexOf("Full version ") == -1) continue;
                version = lines[i];
                break;
            }
            cluvfyFullVersion = version.substring(13);
            this.logger.info("cluvfy Full version is " + cluvfyFullVersion + "\n");
            versionOK = DBPatchingUtil.isVersionEqalOrlater(cluvfyFullVersion, minVersion);
        }
        catch (Exception e) {
            this.logger.info("Failed to check cluvfy version. Hence, cluvfy validations will not be run.");
            return false;
        }
        return versionOK;
    }

    public GISystemCall.ExecReturn runCluvfyCmd(String crsHome, String owner) {
        this.logger.info("Performing cluvfy validations.");
        Credential credential = null;
        String commandToExecute = crsHome + File.separator + "bin" + File.separator + "cluvfy stage -pre patch _opatch_check";
        try {
            GISystemCall.ExecReturn ret = GISystemCall.process(commandToExecute, owner, credential);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }
}

