/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSObjectValidator;
import dbmodel.SystemInstance;
import dbmodel.db_crs.CRSCluster;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRSversionGreaterValidator
implements IValidator {
    Logger logger = Logger.getLogger(CRSversionGreaterValidator.class.getName());
    private String strMinCRSversion = null;

    public CRSversionGreaterValidator(String strMinCRSversion) {
        this.strMinCRSversion = strMinCRSversion;
    }

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.FINE, "Invoking rule to ensure that CRS version is greater than " + this.strMinCRSversion);
        CRSObjectValidator crsObjectValidator = new CRSObjectValidator();
        crsObjectValidator.setClazz(CRSversionGreaterValidator.class);
        MultipleValidationResult crsObjectValidationResult = crsObjectValidator.validate(params);
        if (this.getFailureResult(crsObjectValidationResult)) {
            return crsObjectValidationResult;
        }
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        CRSCluster crs = (CRSCluster)systemInst.getTop();
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        if (crs.getVersion().trim().compareToIgnoreCase(this.strMinCRSversion) >= 0) {
            this.logger.log(Level.FINE, "CRS version is greater than the minimum required version");
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
            return multipleValidationResult;
        }
        String message = null;
        this.logger.log(Level.INFO, "Current CRS version is less than the minimum version required.");
        message = BundleUtils.getMessage(CRSversionGreaterValidator.class, "CRS_VERSION_NOT_SUPPORTED", this.strMinCRSversion);
        Reporting.report((String)message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.CRS_VERSION_NOT_SUPPORTED, null));
        return multipleValidationResult;
    }

    private boolean getFailureResult(MultipleValidationResult multipleValidationResult) {
        for (ValidationResult validationResult : multipleValidationResult.getValidationResultList()) {
            if (validationResult.getStatus() != ValidationResult.ValidationStatus.FAILED) continue;
            return true;
        }
        return false;
    }
}

