/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.data.ValidPlatforms;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRSPlatformValidator
implements IValidator {
    Logger logger = Logger.getLogger(CRSPlatformValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Ensuring that all the homes have the same platform and the ARUid is one of the recognized ARUids.");
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        AbstractBaseTarget crs = systemInst.getTop();
        ArrayList<BaseClass> list = new ArrayList<BaseClass>();
        list.add((BaseClass)crs);
        List homes = systemInst.getAllHomes();
        String message = null;
        String formattedMsg = null;
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        if (homes == null || homes.isEmpty()) {
            this.logger.log(Level.INFO, " CRS " + crs + "does not have any home ");
            message = BundleUtils.getMessage(this.getClass(), "CRS_NO_HOME", BundleUtils.makeStringOutOfList(list));
            StringBuffer str = new StringBuffer();
            str.append("\n    ").append(message).append("\n      " + crs);
            message = str.toString();
            Reporting.report((String)message);
            this.logger.log(Level.INFO, message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.CRS_NO_HOME, crs));
            return multipleValidationResult;
        }
        String crsPlatform = null;
        ArrayList<BaseClass> missingPlatform = new ArrayList<BaseClass>();
        ArrayList<OracleHome> invalidPlatform = new ArrayList<OracleHome>();
        ArrayList<BaseClass> unequalPlatform = new ArrayList<BaseClass>();
        for (OracleHome home : homes) {
            String platform = home.getARUId();
            if (platform == null || platform.trim().length() == 0) {
                this.logger.log(Level.INFO, "ARU_ID info missing for home at path " + home.getPath());
                missingPlatform.add((BaseClass)home);
                continue;
            }
            if (!ValidPlatforms.isValid(platform)) {
                this.logger.log(Level.INFO, "ARU_ID for home at path " + home.getPath() + " is not a valid ARU_ID.");
                invalidPlatform.add(home);
                continue;
            }
            if (crsPlatform == null) {
                crsPlatform = platform.trim();
                continue;
            }
            if (crsPlatform.compareTo(platform) == 0) continue;
            this.logger.log(Level.INFO, "ARU_ID for the homes in this crs cluster are not equal. ");
            unequalPlatform.add((BaseClass)home);
        }
        StringBuilder errorStr = new StringBuilder();
        if (!missingPlatform.isEmpty()) {
            message = BundleUtils.getMessage(CRSPlatformValidator.class, "ARU_ID_NOT_SET", BundleUtils.makeStringOutOfList(missingPlatform));
            formattedMsg = this.getMessage(missingPlatform, message);
            errorStr.append("          " + message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.ARU_ID_NOT_SET, missingPlatform));
            this.logger.log(Level.INFO, "Missing platform =" + formattedMsg);
        }
        if (!invalidPlatform.isEmpty()) {
            message = BundleUtils.getMessage(CRSPlatformValidator.class, "INVALID_PLATFORM", BundleUtils.makeStringOutOfList(missingPlatform));
            formattedMsg = this.getMessage(invalidPlatform, message);
            errorStr.append("          " + message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INVALID_PLATFORM, missingPlatform));
            this.logger.log(Level.INFO, "Invalid platform =" + formattedMsg);
        }
        if (!unequalPlatform.isEmpty()) {
            message = BundleUtils.getMessage(CRSPlatformValidator.class, "UNEQUAL_PLATFORM", BundleUtils.makeStringOutOfList(unequalPlatform));
            formattedMsg = this.getMessage(unequalPlatform, message);
            errorStr.append("          " + message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.UNEQUAL_PLATFORM, missingPlatform));
            this.logger.log(Level.INFO, "unequal platform =" + formattedMsg);
        }
        this.logger.log(Level.INFO, " CRSplatformValid result =" + errorStr.toString());
        if (!multipleValidationResult.isEmpty()) {
            Reporting.report((String)errorStr.toString());
            return multipleValidationResult;
        }
        message = " All CRS homes have the same platform ARUid and this ARUid is valid";
        this.logger.log(Level.INFO, message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private String getMessage(List<? extends BaseClass> list, String message) {
        StringBuffer str = new StringBuffer();
        str.append("\n    ").append(message);
        if (list == null || list.isEmpty()) {
            message = str.toString();
        }
        for (BaseClass baseClass : list) {
            str.append("\n      " + baseClass);
        }
        return str.toString();
    }
}

