/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.summary;

import com.oracle.glcm.patch.auto.db.product.summary.Summary;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTarget;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementWrapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class SummaryTargetList {
    @XmlElementWrapper(name="summary-target-list")
    private LinkedHashMap<SummaryTarget, Summary> targetSummarySet = new LinkedHashMap();

    public void updateTargetList(SummaryTarget target, int status, String summaryDetails) {
        Summary summary = this.targetSummarySet.get(target);
        if (summary == null) {
            summary = new Summary();
            summary.setStatus(status);
            summary.setSummaryDetails(summaryDetails);
        } else {
            if (summary.getSummaryDetails().trim().equals(summaryDetails.trim())) {
                return;
            }
            if (summary.getStatus() == 1 && status != 1) {
                return;
            }
            String summaryToAppend = summary.getSummaryDetails();
            if (status == 1 && summary.getStatus() != 1) {
                summaryToAppend = "";
                summary.setStatus(status);
            }
            StringBuilder consolidateSummary = new StringBuilder(summaryToAppend);
            consolidateSummary.append("\n");
            consolidateSummary.append(summaryDetails);
            summary.setSummaryDetails(consolidateSummary.toString());
        }
        this.targetSummarySet.put(target, summary);
    }

    public void updateSDBTargetList(SummaryTarget target, int status, String summaryDetails) {
        Summary summary = this.targetSummarySet.get(target);
        if (summary == null) {
            summary = new Summary();
            summary.setStatus(status);
            summary.setSummaryDetails(summaryDetails);
        } else {
            if (summary.getSummaryDetails().trim().equals(summaryDetails.trim())) {
                return;
            }
            if (status == 2) {
                summary.setSummaryDetails(summaryDetails);
            } else {
                StringBuilder consolidateSummary = new StringBuilder(summary.getSummaryDetails());
                consolidateSummary.append(summaryDetails);
                summary.setSummaryDetails(consolidateSummary.toString());
            }
        }
        this.targetSummarySet.put(target, summary);
    }

    public Map<SummaryTarget, Summary> getSummaryList() {
        return (Map)this.targetSummarySet.clone();
    }
}

