/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.summary;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class AdminPolicyManagedHomeDetails
implements Serializable {
    private static final long serialVersionUID = 1011L;
    private static final String HOME_INFORMATION_SER = "homeInformation.ser";
    private String filePath = null;
    private Map<String, String> homeListSkipped = new TreeMap<String, String>();
    private static final Logger _log = Logger.getLogger(AdminPolicyManagedHomeDetails.class.getName());

    public AdminPolicyManagedHomeDetails() {
        try {
            String baseLoc = OPatchAutoHelper.getOPatchAutoHome();
            this.filePath = baseLoc + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + HOME_INFORMATION_SER;
        }
        catch (OPatchAutoException e) {
            this.filePath = File.separator + "tmp" + File.separator + HOME_INFORMATION_SER;
        }
    }

    public void addSkippedHomeToList(String home, String config) {
        this.homeListSkipped.put(home, config);
    }

    public void addSkippedHomeToList(Map<String, String> dbInfo) {
        this.homeListSkipped.putAll(dbInfo);
    }

    public void storeInformation() {
        if (this.homeListSkipped != null && !this.homeListSkipped.isEmpty()) {
            try {
                if (!new File(this.filePath).exists()) {
                    String crsOwner = OUIDriver.checkFileOwner((File)new File(PatchPlanner.getInstance().getOPlanEnv().getOracleHome(), "oraInst.loc"));
                    DBPatchingUtil.createNewFile(this.filePath, crsOwner, null);
                }
                FileOutputStream fileOut = new FileOutputStream(this.filePath);
                ObjectOutputStream out = new ObjectOutputStream(fileOut);
                out.writeObject(this.homeListSkipped);
                out.close();
                fileOut.close();
            }
            catch (IOException i) {
                _log.warning("File creation failed");
            }
        }
    }

    public void retrieveInformation() {
        try {
            FileInputStream fileIn = new FileInputStream(this.filePath);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            this.homeListSkipped = (Map)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException i) {
            _log.fine("File reading failed");
            return;
        }
        catch (ClassNotFoundException c) {
            _log.fine("Class not found");
            return;
        }
        this.close();
    }

    private void close() {
        File tmpFile = new File(this.filePath);
        tmpFile.deleteOnExit();
    }

    public Map<String, String> getHomeInformation() {
        TreeMap<String, String> homeList = new TreeMap<String, String>();
        if (this.homeListSkipped != null) {
            homeList.putAll(this.homeListSkipped);
        }
        return homeList;
    }
}

