/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.patchlevel;

import com.oracle.glcm.patch.auto.db.framework.SessionData;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class OracleHomePatchLevel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(OracleHomePatchLevel.class.getName());
    private Map<String, List<OPatchPatchInfo>> oracleHomePatchLevel = new ConcurrentHashMap<String, List<OPatchPatchInfo>>();

    public void addOracleHomePatchLevel(String oracleHome, List<OPatchPatchInfo> patchBeans) {
        this.oracleHomePatchLevel.put(oracleHome, patchBeans);
    }

    public Map<String, List<OPatchPatchInfo>> getOracleHomePatchLevel() {
        return this.oracleHomePatchLevel;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        logger.info("Reading OH patch level");
        for (String oh : this.oracleHomePatchLevel.keySet()) {
            builder.append("\nFor Oracle Home: " + oh);
            builder.append(" following are the patch levels: ");
            builder.append(" \n=========================================================================");
            List<OPatchPatchInfo> patchInfos = this.oracleHomePatchLevel.get(oh);
            for (OPatchPatchInfo info : patchInfos) {
                builder.append("\nPatch ID: " + info.getPatchID());
                builder.append("\nUnique Patch ID: " + info.getUniquePatchID());
                builder.append("\nSQL Patch: " + info.isSQLPatch());
                if (!info.isSQLPatch()) continue;
                logger.info("Writing to session data");
                try {
                    SessionData sessionData = SessionData.getInstance();
                    logger.info("Created session data");
                    if (sessionData == null) {
                        logger.info("session data is NULL");
                        continue;
                    }
                    sessionData.setSqlPatchAvailable(true);
                    logger.info("Finished writing to session data");
                }
                catch (Exception e) {
                    logger.info("INFO: Failed initializing session data");
                }
            }
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        OracleHomePatchLevel oracleHomePatchLevel = (OracleHomePatchLevel)obj;
        Set<Map.Entry<String, List<OPatchPatchInfo>>> entrySet = oracleHomePatchLevel.getOracleHomePatchLevel().entrySet();
        for (Map.Entry<String, List<OPatchPatchInfo>> entry : entrySet) {
            List<OPatchPatchInfo> patchInfoList = this.oracleHomePatchLevel.get(entry.getKey());
            if (patchInfoList.size() == entry.getValue().size()) {
                if (patchInfoList.containsAll((Collection)entry.getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

