/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.patch;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackageFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.product.intg.DBPatchPlanIntgFactory;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import com.oracle.glcm.patch.auto.db.product.patch.FilterPatchDirectories;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import dbmodel.patchmodel.Bundle;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.GenericSingletonPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchPackage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.opatch.opatchsdk.OPatchException;

public class BundlePatchObject {
    private static final byte CRS = 0;
    private static final byte DATABASE = 1;
    private List<File> dbPatchList = new ArrayList<File>();
    private List<File> crsPatchList = new ArrayList<File>();
    private List<String> dbPatchIDList = new ArrayList<String>();
    private List<String> crsPatchIDList = new ArrayList<String>();
    private PatchPackagesBag bag = null;

    public BundlePatchObject(PatchInfo patchInfo) throws IllegalAccessException, Exception {
        boolean isPatchID;
        boolean bl = isPatchID = !StringUtil.isNullOrEmpty((String)patchInfo.getPatchId());
        if (isPatchID) {
            this.createPatchBagForPatchID(patchInfo);
        } else {
            this.createPatchBagForPatchLocation(patchInfo);
        }
        ArrayList<GenericPatch> crsPatches = new ArrayList();
        ArrayList<GenericPatch> racPatches = new ArrayList();
        crsPatches = this.bag.getPatchesForTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString());
        racPatches = this.bag.getPatchesForTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString());
        this.processPatchForTargetType(crsPatches, (byte)0);
        this.processPatchForTargetType(racPatches, (byte)1);
    }

    private void createPatchBagForPatchID(PatchInfo patchInfo) throws IOException, PatchPackageException, OPatchException {
        String[] patchIDList;
        DBPatchPlanIntgFactory intgFactory = new DBPatchPlanIntgFactory();
        PatchPackageFactory ppf = PatchPackageFactory.getInstance(intgFactory);
        this.bag = ppf.getPatchPackageBagInstance();
        for (String patchID : patchIDList = patchInfo.getPatchId().split(",")) {
            PatchPackage patchPkg = ppf.getPatchPackage(patchID, "", null, false);
            this.bag.add(patchPkg);
        }
    }

    private void createPatchBagForPatchLocation(PatchInfo patchInfo) throws IOException, PatchPackageException, OPatchException {
        boolean isPhBaseDir = !StringUtil.isNullOrEmpty((String)patchInfo.getPatchBaseDirectory());
        File[] patchDir_list = null;
        if (isPhBaseDir) {
            File parent_directory = new File(patchInfo.getPatchBaseDirectory());
            patchDir_list = parent_directory.listFiles(new FilterPatchDirectories());
        } else {
            patchDir_list = new File[]{new File(patchInfo.getPatchLocation())};
        }
        DBPatchPlanIntgFactory intgFactory = new DBPatchPlanIntgFactory();
        PatchPackageFactory ppf = PatchPackageFactory.getInstance(intgFactory);
        this.bag = ppf.getPatchPackageBagInstance();
        for (File patch_dir : patchDir_list) {
            String subPatchLoc = patch_dir.getCanonicalPath();
            this.prcoessPatch(subPatchLoc, ppf);
        }
    }

    private void prcoessPatch(String patchLoc, PatchPackageFactory ppf) throws PatchPackageException, OPatchException {
        ArrayList<GenericPatch> singles = new ArrayList<GenericPatch>();
        PatchPackage pp = ppf.getPatchPackageFromDir(new File(patchLoc));
        if (pp instanceof Bundle) {
            singles.addAll(((Bundle)pp).getSubPatches());
        } else if (pp instanceof CompositePatch) {
            singles.addAll(((CompositePatch)pp).getSubPatches());
        } else if (pp instanceof OPatchSingleton) {
            singles.add((GenericPatch)pp);
        } else {
            throw new PatchPackageException("Invalid patch type");
        }
        this.bag.add(pp);
        for (int i = 0; i < singles.size(); ++i) {
            GenericPatch ent = (GenericPatch)singles.get(i);
            String memLoc = ent.getPatchLocation();
            if (new File(memLoc).exists()) continue;
            throw new PatchPackageException("The location \"" + memLoc + "\" of sub patch does not exist.");
        }
    }

    private void processPatchForTargetType(List<GenericPatch> targetPatches, byte targetType) throws OPatchException {
        for (int i = 0; i < targetPatches.size(); ++i) {
            GenericPatch subPatches = targetPatches.get(i);
            if (subPatches instanceof CompositePatch) {
                CompositePatch comp = (CompositePatch)subPatches;
                List cpatches = comp.getSubPatches();
                for (GenericSingletonPatch singlePatch : cpatches) {
                    if (targetType == 0) {
                        this.crsPatchList.add(new File(singlePatch.getPatchLocation()));
                        this.crsPatchIDList.add(singlePatch.getPatchID());
                        continue;
                    }
                    this.dbPatchList.add(new File(singlePatch.getPatchLocation()));
                    this.dbPatchIDList.add(singlePatch.getPatchID());
                }
                continue;
            }
            if (targetType == 0) {
                this.crsPatchList.add(new File(subPatches.getPatchLocation()));
                this.crsPatchIDList.add(subPatches.getPatchID());
                continue;
            }
            this.dbPatchList.add(new File(subPatches.getPatchLocation()));
            this.dbPatchIDList.add(subPatches.getPatchID());
        }
    }

    public PatchPackagesBag getPatchPackagesBag() {
        return this.bag;
    }

    public List<File> getRACPatchList() {
        return this.dbPatchList;
    }

    public List<File> getCRSPatchList() {
        return this.crsPatchList;
    }

    public List<String> getCRSPatchIDList() {
        ArrayList<String> patchList = new ArrayList<String>();
        patchList.addAll(this.crsPatchIDList);
        return patchList;
    }

    public List<String> getDBPatchIDList() {
        ArrayList<String> patchList = new ArrayList<String>();
        patchList.addAll(this.dbPatchIDList);
        return patchList;
    }

    public String toString() {
        StringBuffer patchDetails = new StringBuffer();
        patchDetails.append("\n Details of the patch selected for patching as follows:\n");
        if (this.crsPatchList != null && this.crsPatchList.size() > 0) {
            patchDetails.append("CRS patches:\n");
            for (File patchLoc : this.crsPatchList) {
                patchDetails.append(patchLoc.getAbsolutePath() + "\n");
            }
        }
        if (this.dbPatchList != null && this.dbPatchList.size() > 0) {
            patchDetails.append("Database patches:\n");
            for (File patchLoc : this.dbPatchList) {
                patchDetails.append(patchLoc.getAbsolutePath() + "\n");
            }
        }
        return patchDetails.toString();
    }
}

