/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo;

import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.db.product.patchlevel.PatchLevelReportingListener;
import com.oracle.glcm.patch.auto.topology.Host;
import java.util.Map;
import java.util.Set;

public class PatchLevelQuery
implements PatchLevelReportingListener {
    public static final int PATCH_LEVEL_DIFFERENT = 106;
    private String failureMessage = null;
    private boolean retrieveResultList;
    Map<Host, OracleHomePatchLevel> patchInfoMap = null;

    public PatchLevelQuery() {
    }

    public PatchLevelQuery(boolean retrieveResultList) {
        this.retrieveResultList = retrieveResultList;
    }

    public OracleHomePatchLevel getPatchInfoList(Host host) {
        if (this.patchInfoMap != null) {
            return this.patchInfoMap.get(host);
        }
        return null;
    }

    @Override
    public void notifyResult(int resultID, int messageID, String message, Object payload) {
        if (resultID == 0) {
            Map hostOHMap = (Map)payload;
            Set patchInfoSet = hostOHMap.entrySet();
            if (!this.retrieveResultList) {
                for (Map.Entry entry : patchInfoSet) {
                    OOPSessionInfoHandler.getInstance().updatePatchLevelInSessionInfo((Host)entry.getKey(), (OracleHomePatchLevel)entry.getValue());
                }
            } else {
                this.patchInfoMap = hostOHMap;
            }
        } else {
            int dbmessageID = PatchLevelQuery.getDBMessageID(messageID);
            this.failureMessage = OPatchAutoHelper.getPublishedMessage((String)Integer.toString(dbmessageID), (Object[])new Object[]{message});
        }
    }

    public static int getDBMessageID(int exitCode) {
        int dbMessageID = 0;
        switch (exitCode) {
            case 100: {
                dbMessageID = 72086;
                break;
            }
            case 101: {
                dbMessageID = 72102;
                break;
            }
            case 102: {
                dbMessageID = 72103;
                break;
            }
            case 103: {
                dbMessageID = 72104;
                break;
            }
            case 104: {
                dbMessageID = 72105;
                break;
            }
            case 105: {
                dbMessageID = 72106;
                break;
            }
        }
        return dbMessageID;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }
}

