/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.graphlib;

import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.BaseSWComponent;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.ShardedDatabase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriver;

public class SDBConfigGraph
extends ConfigGraph {
    public static Logger logger = Logger.getLogger(SDBConfigGraph.class.getName());

    public SDBConfigGraph(ConfigGraph.VertexComp c, SystemInstance si) {
        super(c, si);
    }

    public SDBConfigGraph(SystemInstance si, Host localHost) {
        super(si, localHost);
    }

    @Override
    public Host initLocalHost(SystemInstance si, Host localHost) {
        if (localHost == null) {
            logger.info("localHost is null");
            List hostList = si.getTargetsOfType(Host.class);
            try {
                InetAddress addr = InetAddress.getLocalHost();
                String localHostName = null;
                boolean found = false;
                if (addr != null) {
                    localHostName = addr.getHostName();
                    if (localHostName.indexOf(".") != -1) {
                        localHostName = localHostName.substring(0, localHostName.indexOf("."));
                    }
                    logger.info("localHostName from InetAddress.getLocalHost is" + localHostName);
                    if (localHostName != null) {
                        for (Host host : hostList) {
                            if (!host.getHostName().equalsIgnoreCase(localHostName) && !host.getNodeName().equalsIgnoreCase(localHostName)) continue;
                            localHost = host;
                            found = true;
                            break;
                        }
                    }
                }
                if (addr == null || !found || localHostName == null) {
                    Collections.sort(hostList, new ProductDriver.HostComparator());
                    localHost = (Host)hostList.get(0);
                    logger.info("Set localHost to first host in config graph " + localHost.getHostName());
                }
            }
            catch (UnknownHostException e) {
                throw new PatchPlanInternalException(e.getMessage(), e);
            }
        }
        return localHost;
    }

    @Override
    public ConfigGraph.VertexComp getVertexCompInstance(Host localHost) {
        return new SDBVertexComp(localHost);
    }

    public DefaultMutableTreeNode createSDBTreeTable(ShardedDatabase shardedDB) {
        DefaultMutableTreeNode sdbNode = new DefaultMutableTreeNode(shardedDB);
        logger.log(Level.FINEST, "SDB -> Host" + this.getConnectedTargets((AbstractBaseTarget)shardedDB, Host.class));
        for (Host host : this.getConnectedTargets((AbstractBaseTarget)shardedDB, Host.class)) {
            sdbNode.add(this.createTreeTableForHost(host));
        }
        return sdbNode;
    }

    private DefaultMutableTreeNode createTreeTableForHost(Host host) {
        DefaultMutableTreeNode hostNode = new DefaultMutableTreeNode(host);
        logger.log(Level.FINEST, "Host -> OracleOH" + this.getConnectedTargets((AbstractBaseTarget)host, OracleHome.class));
        for (OracleHome home : this.getConnectedTargets((AbstractBaseTarget)host, OracleHome.class)) {
            DefaultMutableTreeNode homeNode = new DefaultMutableTreeNode(home);
            hostNode.add(homeNode);
            logger.log(Level.FINEST, "OracleOH -> Components" + this.getConnectedTargets((AbstractBaseTarget)home, BaseSWComponent.class));
            for (BaseSWComponent component : this.getConnectedTargets((AbstractBaseTarget)home, BaseSWComponent.class)) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(component);
                homeNode.add(node);
            }
        }
        return hostNode;
    }

    @Override
    public DefaultMutableTreeNode createTreeTable() {
        AbstractBaseTarget root = this.getRootVertex();
        if (root instanceof ShardedDatabase) {
            ShardedDatabase sdb = (ShardedDatabase)root;
            return this.createSDBTreeTable(sdb);
        }
        throw new PatchPlanInternalException("The root object of this systemInstance is not a ShardedDatabase.");
    }

    public class SDBVertexComp
    extends ConfigGraph.VertexComp {
        public SDBVertexComp(Host localHost) {
            super(localHost);
        }

        @Override
        public Host getLocalHost() {
            return this.localHost;
        }

        @Override
        public int compare(AbstractBaseTarget t1, AbstractBaseTarget t2) {
            Host h2;
            Host h1;
            int cmp = 0;
            if (t1 == t2) {
                return 0;
            }
            cmp = this.compareTypes(t1, t2);
            if (cmp != 0) {
                return cmp;
            }
            if (t1 instanceof Host) {
                return this.compareHosts((Host)t1, (Host)t2);
            }
            cmp = this.compareNames(t1, t2);
            if (cmp != 0) {
                return cmp;
            }
            if (t1 instanceof OracleHome && (cmp = this.compareHosts(h1 = (Host)((OracleHome)t1).getHosts().get(0), h2 = (Host)((OracleHome)t2).getHosts().get(0))) != 0) {
                return cmp;
            }
            if (t1 instanceof RACDBInstance && (cmp = this.compareHosts(h1 = ((RACDBInstance)t1).getHost(), h2 = ((RACDBInstance)t2).getHost())) != 0) {
                return cmp;
            }
            return t1.getUniqueId().compareTo(t2.getUniqueId());
        }
    }
}

