/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.sidb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.graphlib.CRSConfigGraph;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbsysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SIDBProductDriver
extends ProductDriver {
    Logger logger = Logger.getLogger(SIDBProductDriver.class.getName());
    private SIDatabase sidb;
    private String oracleHome;

    public SIDBProductDriver(SIDatabase sidb, String oracleHome) {
        this.sidb = sidb;
        this.oracleHome = oracleHome;
    }

    public SIDBProductDriver() {
    }

    public SystemInstance buildSystemInstance() throws ProductDriverException {
        this.ti = new SystemInstance();
        if (this.sidb == null || this.oracleHome == null) {
            return this.ti;
        }
        String hostname = DBPatchingHelper.getLocalHost();
        this.logger.entering(((Object)((Object)this)).getClass().getName(), "buildSystemInstance");
        if (this.sidb.getDatabaseName() == null) {
            this.logger.warning("Database name is not provided.");
            throw new ProductDriverException();
        }
        this.sidb = this.makeStandAloneDatabase(hostname);
        this.ti.setTop((AbstractBaseTarget)this.sidb);
        this.logger.info("SIDB System Instance: " + this.ti.toString());
        return this.ti;
    }

    private SIDatabase makeStandAloneDatabase(String host) throws ProductDriverException {
        OracleHome oh = this.prepareOracleHome(host);
        oh.getInstalledSWComponents().add(this.sidb);
        this.updateSIDBVersion();
        this.ti.getEntities().add(this.sidb.getShardProperty());
        this.ti.getEntities().add(this.sidb.getShardProperty().getRegion());
        this.ti.getEntities().add(this.sidb);
        return this.sidb;
    }

    private void updateSIDBVersion() {
        if (StringUtil.isNullOrEmpty((String)this.sidb.getVersion()) || this.sidb.getVersion().equals("-1")) {
            this.sidb.setVersion(this.getVersion(this.sidb.getOracleHome()));
        }
    }

    private String getVersion(String homePath) {
        String ver = "";
        try {
            for (OracleHome oh : OUIDriver.getLocalInfo()) {
                if (!new File(homePath).getCanonicalPath().equals(new File(oh.getPath()).getCanonicalPath())) continue;
                ver = ((OUIComponent)oh.getTopLevelOUI().get(0)).getVersion();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.info("SIDB version from oui : " + ver);
        return ver;
    }

    private OracleHome prepareOracleHome(String host) throws ProductDriverException {
        OracleHome oh = this.sidb.getRuns_from();
        oh.setHomeType("sidb");
        oh.setARUId(SIDBProductDriver.getAruId(oh.getPath()));
        if (OUIDriver.isWindows()) {
            oh.setPlatform("windows");
        } else {
            oh.setPlatform("linux");
        }
        oh.setDescription("A " + oh.getType());
        oh.setName(oh.getHomeName());
        try {
            File inventoryFile = new File(oh.getPath(), "oraInst.loc");
            String invPtrLoc = OUIDriver.readCentralInventoryLocation((File)inventoryFile);
            oh.setCentralInvPtr(invPtrLoc);
            String oracleBase = OUIDriver.checkOracleBase((String)oh.getPath());
            oh.setOracleBaseLocation(oracleBase);
            String owner = OUIDriver.checkFileOwner((File)new File(oh.getPath(), "oraInst.loc"));
            oh.setOwner(owner);
        }
        catch (Exception e) {
            throw new ProductDriverException("Exception while creating oracle home : " + e.getMessage());
        }
        oh.setInstalledSWComponents(new ArrayList());
        this.ti.getEntities().add(oh);
        this.ti.getEntities().add(oh.getHosts().get(0));
        return oh;
    }

    static String getAruId(String oracleHome) throws ProductDriverException {
        String OH_PROPERTIES_XML = "inventory" + File.separator + "ContentsXML" + File.separator + "oraclehomeproperties.xml";
        File ohPropertyFile = new File(oracleHome + File.separator + OH_PROPERTIES_XML);
        if (ohPropertyFile.exists() && !ohPropertyFile.isDirectory()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(ohPropertyFile);
                doc.getDocumentElement().normalize();
                NodeList nodeList = doc.getElementsByTagName("ARU_ID");
                if (nodeList != null && nodeList.getLength() > 0) {
                    Element el = (Element)nodeList.item(0);
                    String platformID = el.getTextContent();
                    return platformID;
                }
            }
            catch (ParserConfigurationException e) {
                throw new ProductDriverException("ParserConfigurationException: " + e.getMessage());
            }
            catch (SAXException e) {
                throw new ProductDriverException("SAXException: " + e.getMessage());
            }
            catch (IOException e) {
                throw new ProductDriverException("IOException: " + e.getMessage());
            }
            catch (Exception e) {
                throw new ProductDriverException("Exception: " + e.getMessage());
            }
        }
        return null;
    }

    public void createSIDBSystemInstance(File systemInstanceFile) throws FileNotFoundException {
        SystemInstance systemInstance = new SystemInstance();
        systemInstance = systemInstance.readFile(systemInstanceFile);
        systemInstance.setTop((AbstractBaseTarget)systemInstance.getTargetsOfType(SIDatabase.class).get(0));
        this.logger.log(Level.INFO, "Creating config graph from instance for sidb");
        CRSConfigGraph configGraph = new CRSConfigGraph(systemInstance, (Host)systemInstance.getTargetsOfType(Host.class).get(0));
        PatchPlanner.getInstance().setSystemInstance(systemInstance);
        PatchPlanner.getInstance().setConfigGraph(configGraph);
    }

    public LocalInfo getLocalInfo() {
        return null;
    }
}

