/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.sdb;

import com.oracle.glcm.patch.auto.db.product.driver.sdb.SDBProductDriver;
import com.oracle.glcm.patch.auto.db.product.driver.sdb.SystemInstBuilder;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.ShardedDatabase;
import java.util.ArrayList;

public class SDBSystemInstBuilder
extends SDBProductDriver
implements SystemInstBuilder {
    public SDBSystemInstBuilder(boolean isOgg, int shardingType, SystemInstance ti) {
        this.isOgg = isOgg;
        this.shardingType = shardingType;
        this.ti = ti;
    }

    @Override
    public SystemInstance createSystemInstance() {
        ShardedDatabase sdb = new ShardedDatabase();
        ArrayList shard_spaces = new ArrayList();
        sdb.setShardSpaces(shard_spaces);
        ArrayList crs_clusters = new ArrayList();
        sdb.setCrs(crs_clusters);
        ArrayList has = new ArrayList();
        sdb.setHas(has);
        if (this.isOgg) {
            sdb.setReplicationType("Goldengate");
        } else {
            sdb.setReplicationType("Dataguard");
        }
        if (this.shardingType == 1) {
            sdb.setShardingType("system-managed");
        } else if (this.shardingType == 2) {
            sdb.setShardingType("user-defined");
        } else if (this.shardingType == 3) {
            sdb.setShardingType("composite");
        }
        this.ti.getEntities().add(sdb);
        this.ti.setTop((AbstractBaseTarget)sdb);
        return this.ti;
    }
}

