/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.GenericShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.RACDBInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.Command;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class RACOneDBShellCommand
extends GenericShellCommand {
    private static final int OLD_HOST = 1;
    private static final int NEW_HOST = 2;
    private static final String oldHostName = "oldHostname";
    private static final String newHostName = "newHostname";
    private static Logger logger = Logger.getLogger(RACOneDBShellCommand.class.getName());
    private RACDBInstance activeInstance = null;

    public RACOneDBShellCommand(CommandAction commandAction) {
        super(commandAction);
        this.automationCommands = commandAction.getCommand();
    }

    public RACOneDBShellCommand(ActionType automationAction, List<Command> automationCommands) {
        super(automationAction, automationCommands);
        this.automationCommands = automationCommands;
    }

    private String getCommandString(Command c) {
        StringBuilder str = new StringBuilder();
        for (Command.EnvVar e : c.getEnvVar()) {
            str.append(e.getName() + "=" + e.getValue() + " ");
        }
        if (c.getCurrentWorkingDir() != null) {
            str.append("cd " + c.getCurrentWorkingDir() + "; ");
        }
        Logger.getLogger(RACOneDBShellCommand.class.getName()).info("getSource(c): " + this.getSource(c));
        str.append(this.getSource(c));
        for (String arg : c.getParameter()) {
            arg = this.updateRACOneShellCommand(arg);
            str.append(" ").append(arg.trim());
        }
        return str.toString();
    }

    private String updateRACOneShellCommand(String cmd) {
        Logger.getLogger(RACOneDBShellCommand.class.getName()).info("cmd: " + cmd);
        if (cmd.equals(oldHostName)) {
            cmd = this.getRelocationHost(1);
        } else if (cmd.equals(newHostName)) {
            cmd = this.getRelocationHost(2);
        }
        logger.info("cmd: " + cmd);
        return cmd;
    }

    private String getRelocationHost(int hostType) {
        String hostName = null;
        block0 : switch (hostType) {
            case 1: {
                hostName = this.activeInstance.getHost().getHostName();
                break;
            }
            case 2: {
                List dbInst = this.activeInstance.getDbRAC().getDbInstances();
                for (RACDBInstance inst : dbInst) {
                    if (inst == this.activeInstance) continue;
                    hostName = inst.getHost().getHostName();
                    break block0;
                }
                break;
            }
        }
        logger.info("hostName: " + hostName);
        return hostName;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        ArrayList<String> cmds = new ArrayList<String>();
        RACDBInstance currentInstance = (RACDBInstance)context.getPrimaryTarget();
        List dbInst = currentInstance.getDbRAC().getDbInstances();
        for (RACDBInstance inst : dbInst) {
            if (!"yes".equals(inst.getIsRunning())) continue;
            this.activeInstance = inst;
            break;
        }
        if (this.activeInstance == null) {
            return cmds;
        }
        Logger.getLogger(RACOneDBShellCommand.class.getName()).info("activeInstance: " + this.activeInstance);
        for (Command c : this.automationCommands) {
            String cmd = this.getCommandString(c);
            String updateCmd = this.replaceParams(cmd, context);
            cmds.add(updateCmd);
        }
        return cmds;
    }

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph configGraph, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> executionSteps = new ArrayList<ExecutionStep>();
        Logger.getLogger(RACOneDBShellCommand.class.getName()).info("actsOnlyOnTargets size: " + actsOnlyOnTargets.size());
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep es;
            RACDBInstance dbInst;
            Logger.getLogger(RACOneDBShellCommand.class.getName()).info("v: " + abstractBaseTarget);
            if (abstractBaseTarget instanceof RACDBInstance && ((dbInst = (RACDBInstance)abstractBaseTarget).getDbRAC().getDatabaseType() == null || "rac".equals(dbInst.getDbRAC().getDatabaseType())) || (es = this.getExecutionStep(configGraph, abstractBaseTarget)) == null) continue;
            executionSteps.add(es);
        }
        return executionSteps;
    }

    public static class Builder
    implements CommandBuilder<RACOneDBShellCommand> {
        @Override
        public RACOneDBShellCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || a.getType() == null || !a.getType().equals(DBCommandActionType.racOneDBshell.toString())) {
                return null;
            }
            RACOneDBShellCommand racDBcmd = new RACOneDBShellCommand((CommandAction)a);
            return racDBcmd;
        }
    }
}

