/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.GenericShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.patchmodel.GenericPatch;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class PrePostRACPatchScriptCommand
extends GenericShellCommand {
    private String type;
    private List<String> scriptList = new ArrayList<String>();
    private String script;

    private PrePostRACPatchScriptCommand(CommandAction commandAction) {
        super(commandAction);
        this.type = commandAction.getType();
    }

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph configGraph, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> executionSteps = new ArrayList<ExecutionStep>();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            if (!this.checkIfStepValid(configGraph, abstractBaseTarget)) continue;
            for (int i = 0; i < this.scriptList.size(); ++i) {
                this.script = this.scriptList.get(i);
                ExecutionStep es = this.getExecutionStep(configGraph, abstractBaseTarget);
                if (es == null) continue;
                executionSteps.add(es);
            }
        }
        return executionSteps;
    }

    private boolean checkIfStepValid(ConfigGraph g, AbstractBaseTarget t) {
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        CommandContext context = contextPopulator.populateContext(g, t, this.getHost());
        if (this.automationAction.isActsOnClone()) {
            contextPopulator.fixCloneContext(context);
        }
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        List<GenericPatch> patches = this.getPatches(oh);
        String filename = "prepatch.sh";
        if (this.type.equalsIgnoreCase("postRACPatchApplyshell") || this.type.equalsIgnoreCase("postRACPatchRollbackshell")) {
            filename = "postpatch.sh";
        }
        for (GenericPatch patch : patches) {
            Logger.getLogger(PrePostRACPatchScriptCommand.class.getName()).info("PatchRoot: " + patch.getPatchLocation());
            String path = patch.getPatchLocation() + "/custom/scripts/" + filename;
            File f = new File(path);
            if (!f.exists() || f.isDirectory() || this.scriptList.contains(path)) continue;
            this.scriptList.add(path);
        }
        Logger.getLogger(PrePostRACPatchScriptCommand.class.getName()).info("isValid: " + this.scriptList.size());
        return this.scriptList.size() > 0;
    }

    private List<GenericPatch> getPatches(OracleHome oh) {
        List<GenericPatch> patches;
        if (this.type.equalsIgnoreCase(DBCommandActionType.postRACPatchApplyshell.toString()) || this.type.equalsIgnoreCase(DBCommandActionType.preRACPatchApplyshell.toString())) {
            List<GenericPatch> patchList = !PatchPlanner.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.valueOf(oh.getHomeType()).toString()) : CommandUtils.getPatchesByOHOwnerForEM(oh);
            patches = CommandUtils.sortPatchesById(patchList);
        } else {
            patches = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.valueOf(oh.getHomeType()).toString());
        }
        return patches;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        ArrayList<String> cmds = new ArrayList<String>();
        StringBuilder cmd = new StringBuilder(this.script);
        cmd.append(" ");
        cmd.append("-dbhome");
        cmd.append(" ");
        cmd.append(oh.getPath());
        Logger.getLogger(PrePostRACPatchScriptCommand.class.getName()).info("cmd: " + cmd.toString());
        cmds.add(cmd.toString());
        return cmds;
    }

    public static class Builder
    implements CommandBuilder<PrePostRACPatchScriptCommand> {
        @Override
        public PrePostRACPatchScriptCommand getCommand(ActionType a, Strategy s) {
            if (a instanceof CommandAction && a.getType() != null && (a.getType().equals(DBCommandActionType.preRACPatchApplyshell.toString()) || a.getType().equals(DBCommandActionType.postRACPatchApplyshell.toString()) || a.getType().equals(DBCommandActionType.preRACPatchRollbackshell.toString()) || a.getType().equals(DBCommandActionType.postRACPatchRollbackshell.toString()))) {
                return new PrePostRACPatchScriptCommand((CommandAction)a);
            }
            return null;
        }
    }
}

