/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator;

import com.oracle.glcm.patch.auto.db.product.cmdtranslator.SQLCommandModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.ApplySqlAction;
import oracle.opatch.system.db.automation.jaxb.Command;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.LifecycleAction;
import oracle.opatch.system.db.automation.jaxb.ManualAction;
import oracle.opatch.system.db.automation.jaxb.OpatchAction;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.Readme;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.SqlCommand;
import oracle.opatch.system.db.automation.jaxb.Stripe;
import oracle.opatch.system.db.automation.jaxb.UserMessage;

public class CommandDetailsGenerator {
    public static final String NO_PARAM_NAME = "no name";
    public static final String NO_COMMAND = "no command";
    public static final String NO_ERROR = "no error";

    public static PatchingPhase generatePatchingPhase(PhaseType phaseType, ServiceStatus status) {
        PatchingPhase phase = new PatchingPhase();
        phase.setPhaseType(phaseType);
        phase.setServiceStatus(status);
        return phase;
    }

    public static ActionType generateActionType(ActionTypes actionTypes, HashMap<ActionTypeParams, Object> argList) {
        List dependency_Type_List;
        Map opatchActionParam;
        ActionType actionType = CommandDetailsGenerator.createActionType(actionTypes);
        actionType.setType((String)argList.get((Object)ActionTypeParams.TYPE));
        actionType.setRunAs((String)argList.get((Object)ActionTypeParams.RUN_AS));
        actionType.setServiceStatus((ServiceStatus)argList.get((Object)ActionTypeParams.SERVICE_STATUS));
        actionType.setStripe(CommandDetailsGenerator.getStripe((String)argList.get((Object)ActionTypeParams.STRIPE_NAME), (String)argList.get((Object)ActionTypeParams.STRIPE_TARGETHOME), (String)argList.get((Object)ActionTypeParams.STRIPE_HOMETYPE)));
        actionType.setActsOn((String)argList.get((Object)ActionTypeParams.ACTS_ON));
        actionType.setActsOnClone((Boolean)argList.get((Object)ActionTypeParams.ACTS_ON_CLONE));
        actionType.setTag((String)argList.get((Object)ActionTypeParams.TAG));
        UserMessage titleKey = new UserMessage();
        titleKey.setPropertyKey((String)argList.get((Object)ActionTypeParams.README_TITLE_KEY));
        UserMessage msgKey = new UserMessage();
        msgKey.setPropertyKey((String)argList.get((Object)ActionTypeParams.README_MSG_KEY));
        Readme readMe = new Readme();
        readMe.setTitle(titleKey);
        readMe.setMessage(msgKey);
        actionType.setReadme(readMe);
        if (actionTypes == ActionTypes.COMMAND_ACTION) {
            Map commandEnvDetails;
            Map commandDetails = (Map)argList.get((Object)ActionTypeParams.COMMAND_DETAILS);
            List<Command> list = CommandDetailsGenerator.getCommand(commandDetails, commandEnvDetails = (Map)argList.get((Object)ActionTypeParams.COMMAND_ENV_DETAILS));
            if (list != null) {
                for (Command command : list) {
                    ((CommandAction)actionType).getCommand().add(command);
                }
            }
            ((CommandAction)actionType).setTag((String)argList.get((Object)ActionTypeParams.COMMAND_TAG));
        }
        if (actionTypes == ActionTypes.OPATCH_ACTION && (opatchActionParam = (Map)argList.get((Object)ActionTypeParams.OPATCHACTION_PARAMETER)) != null && opatchActionParam.size() > 0) {
            for (Map.Entry entry : opatchActionParam.entrySet()) {
                OpatchAction.Parameter param = new OpatchAction.Parameter();
                if (!((String)entry.getKey()).equals(NO_PARAM_NAME)) {
                    param.setName((String)entry.getKey());
                }
                param.setValue((String)entry.getValue());
                ((OpatchAction)actionType).getParameter().add(param);
            }
        }
        if (actionTypes == ActionTypes.LIFECYCLE_ACTION && (dependency_Type_List = (List)argList.get((Object)ActionTypeParams.DEPENDENCY_TYPE)) != null) {
            for (String string : dependency_Type_List) {
                LifecycleAction.Dependency dep = new LifecycleAction.Dependency();
                dep.setType(string);
                ((LifecycleAction)actionType).getDependency().add(dep);
            }
        }
        if (actionTypes == ActionTypes.APPLY_SQL_ACTION) {
            ((ApplySqlAction)actionType).setConnectAs((String)argList.get((Object)ActionTypeParams.SQL_ACTION_CONNECT_AS));
            List sqlCommandList = (List)argList.get((Object)ActionTypeParams.SQL_ACTION_COMMANDS);
            if (sqlCommandList != null) {
                for (SQLCommandModel sQLCommandModel : sqlCommandList) {
                    String errorType;
                    SqlCommand sqlCommand = new SqlCommand();
                    if (!sQLCommandModel.getCommand().equals(NO_COMMAND)) {
                        sqlCommand.setCommand(sQLCommandModel.getCommand());
                    }
                    if ((errorType = sQLCommandModel.getErrorType()) != null && !errorType.equals(NO_ERROR)) {
                        SqlCommand.ErrorHandling errorHandling = new SqlCommand.ErrorHandling();
                        SqlCommand.ErrorHandling.FatalError error = new SqlCommand.ErrorHandling.FatalError();
                        error.setType(errorType);
                        UserMessage msg = new UserMessage();
                        msg.setPropertyKey(sQLCommandModel.getErrorMsg());
                        error.setMessage(msg);
                        errorHandling.setFatalError(error);
                        sqlCommand.setErrorHandling(errorHandling);
                    }
                    ((ApplySqlAction)actionType).getSqlCommand().add(sqlCommand);
                }
            }
        }
        if (actionTypes == ActionTypes.MANUAL_ACTION) {
            ((ManualAction)actionType).setMessagePrompt((String)argList.get((Object)ActionTypeParams.MANUAL_ACTION_MSG_PROMPT));
        }
        return actionType;
    }

    public static ActionType createActionType(ActionTypes type) {
        CommandAction actionTypeInstance = null;
        switch (type) {
            case COMMAND_ACTION: {
                actionTypeInstance = new CommandAction();
                break;
            }
            case OPATCH_ACTION: {
                actionTypeInstance = new OpatchAction();
                break;
            }
            case LIFECYCLE_ACTION: {
                actionTypeInstance = new LifecycleAction();
                break;
            }
            case APPLY_SQL_ACTION: {
                actionTypeInstance = new ApplySqlAction();
                break;
            }
            case MANUAL_ACTION: {
                actionTypeInstance = new ManualAction();
                break;
            }
        }
        return actionTypeInstance;
    }

    public static Stripe getStripe(String name, String targetHome, String homeType) {
        Stripe stripe = null;
        if (name != null) {
            stripe = new Stripe();
            stripe.setName(name);
            stripe.setTargetHome(targetHome);
            stripe.setHomeType(homeType);
        }
        return stripe;
    }

    private static List<Command> getCommand(Map<String, List<String>> commandDetails, Map<String, Map<String, String>> envDetails) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        if (commandDetails != null) {
            for (Map.Entry<String, List<String>> entry : commandDetails.entrySet()) {
                Command command = new Command();
                Command.Source source = new Command.Source();
                source.setValue(entry.getKey());
                command.setSource(source);
                List<String> paramList = entry.getValue();
                if (paramList != null && paramList.size() > 0) {
                    for (String params : paramList) {
                        command.getParameter().add(params);
                    }
                }
                if (envDetails != null && !envDetails.isEmpty()) {
                    Map<String, String> envVar = envDetails.get(entry.getKey());
                    for (Map.Entry<String, String> envEntry : envVar.entrySet()) {
                        Command.EnvVar env = new Command.EnvVar();
                        env.setName(envEntry.getKey());
                        env.setValue(envEntry.getValue());
                        command.getEnvVar().add(env);
                    }
                }
                commandList.add(command);
            }
        }
        return commandList;
    }

    public static enum ActionTypes {
        COMMAND_ACTION,
        LIFECYCLE_ACTION,
        OPATCH_ACTION,
        APPLY_SQL_ACTION,
        MANUAL_ACTION;

    }

    public static enum ActionTypeParams {
        TYPE,
        RUN_AS,
        SERVICE_STATUS,
        ACTS_ON,
        ACTS_ON_CLONE,
        DEPENDENCY_TYPE,
        STRIPE_NAME,
        STRIPE_TARGETHOME,
        STRIPE_HOMETYPE,
        COMMAND_DETAILS,
        COMMAND_ENV_DETAILS,
        COMMAND_TAG,
        OPATCHACTION_PARAMETER,
        SQL_ACTION_CONNECT_AS,
        SQL_ACTION_COMMANDS,
        TAG,
        README_TITLE_KEY,
        README_MSG_KEY,
        MANUAL_ACTION_MSG_PROMPT;

    }
}

