/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product;

import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class GILogger {
    private static BufferedWriter stepsLogWriter;
    private static String sessionType;
    private static final Logger _log;
    static String stepsLog;

    public static void instantiateStepsLogFiles(String oracleHomePath, String patchLoc, boolean isAnalyze) throws Exception {
        try {
            boolean ok = true;
            Timestamp ts = new Timestamp(new Date().getTime());
            String timeString = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(ts);
            String patchId = new File(patchLoc).getName();
            String logDir = oracleHomePath + File.separator + "cfgtoollogs" + File.separator + "opatchauto" + File.separator + patchId;
            String crsOwner = OUIDriver.checkFileOwner((File)new File(oracleHomePath, "oraInst.loc"));
            File parentDir = new File(logDir);
            ok = DBPatchingUtil.mkdirs(logDir, crsOwner, null);
            if (!ok) {
                throw new Exception("Failed to create directory \"" + logDir + "\".");
            }
            sessionType = isAnalyze ? "analyze" : "deploy";
            File stepsLogFile = new File(parentDir, "opatch_gi_" + timeString + "_" + sessionType + ".steps.log");
            ok = DBPatchingUtil.createNewFile(stepsLogFile.getAbsolutePath(), crsOwner, null);
            if (!ok) {
                throw new Exception("Failed to create steps log file \"" + stepsLogFile.getAbsolutePath() + "\".");
            }
            GILogger.setStepsLog(stepsLogFile.toString());
            stepsLogWriter = new BufferedWriter(new FileWriter(stepsLogFile));
            stepsLogWriter.write("===============LIST of COMMANDS================\n\n");
        }
        catch (Exception e) {
            System.out.println("Failed to create log files.\n");
            GILogger.printStackTrace(e);
            throw new IOException(e);
        }
    }

    private static void setStepsLog(String stepsLog) {
        GILogger.stepsLog = stepsLog;
    }

    protected static String getStepsLog() {
        return stepsLog;
    }

    public static void closeLogFiles() throws IOException {
        if (stepsLogWriter != null) {
            stepsLogWriter.close();
        }
    }

    public static void steps(String step) {
        GILogger.writeWithoutTimeStamp(stepsLogWriter, step);
    }

    public static void writeWithTimeStamp(BufferedWriter logWriter, String message) {
        try {
            Timestamp ts = new Timestamp(new Date().getTime());
            String timeString = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(ts);
            if (logWriter != null) {
                logWriter.write(timeString + " :\n" + message + "\n");
                logWriter.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWithoutTimeStamp(BufferedWriter logWriter, String message) {
        try {
            if (logWriter != null) {
                logWriter.write(message + "\n");
                logWriter.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printStackTrace(Throwable t) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            String trace = stackTrace[i].toString();
            _log.fine(trace);
        }
    }

    static {
        sessionType = new String();
        _log = Logger.getLogger(GILogger.class.getName());
    }
}

