/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.util.PatchPlanUtils;
import com.oracle.glcm.patch.auto.db.integration.controller.CommandExecutionThread;
import com.oracle.glcm.patch.auto.db.integration.controller.ExecutionCommand;
import com.oracle.glcm.patch.auto.db.integration.controller.ParallelExecution;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.database.DatabaseFactory;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.remote.RemoteNodes;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.oii.oiii.OiiiVersion;

public class DBPatchingUtil {
    private static final Logger _log = Logger.getLogger(DBPatchingUtil.class.getName());
    private static final int INT_ELEVEN = 11;
    private static final String PATCH_STORAGE_DIRECTORY = ".patch_storage";

    public static boolean createNewFile(String filePath, String fileOwner, Credential credential) {
        if (new File(filePath).exists()) {
            return true;
        }
        String newFileCmd = "touch " + filePath;
        GISystemCall.ExecReturn er = GISystemCall.process(newFileCmd, fileOwner, credential);
        if (!er.isOK()) {
            _log.log(Level.WARNING, er.getErrorMessage());
        }
        return er.isOK();
    }

    public static void mergeFiles(String file1, String file2) {
        String line2;
        Throwable throwable;
        BufferedReader reader;
        File sourceFile;
        HashSet<String> uniqueRecords = new HashSet<String>();
        if (!StringUtil.isNullOrEmpty((String)file1) && (sourceFile = new File(file1)).exists()) {
            try {
                reader = new BufferedReader(new FileReader(file1));
                throwable = null;
                try {
                    while ((line2 = reader.readLine()) != null) {
                        uniqueRecords.add(line2);
                    }
                }
                catch (Throwable line2) {
                    throwable = line2;
                    throw line2;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable line2) {
                                throwable.addSuppressed(line2);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtil.isNullOrEmpty((String)file2)) {
            File destnFile = new File(file2);
            if (destnFile.exists()) {
                try {
                    reader = new BufferedReader(new FileReader(file2));
                    throwable = null;
                    try {
                        while ((line2 = reader.readLine()) != null) {
                            uniqueRecords.add(line2);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                throwable = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file2));){
                    for (String record : uniqueRecords) {
                        writer.write(record);
                        writer.newLine();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean scpCookieFile(String scpCmd, String fileOwner, Credential credential) {
        GISystemCall.ExecReturn ret = GISystemCall.process(scpCmd, fileOwner, credential);
        if (!ret.isOK()) {
            _log.log(Level.WARNING, ret.getErrorMessage());
        }
        return ret.isOK();
    }

    public static void setDirPerm(String filePath, String fileOwner, Credential credential, String permission) {
        File patchStorage = new File(filePath);
        GISystemCall.ExecReturn ret = null;
        _log.log(Level.INFO, "Set the permission of the file " + filePath + " to " + permission);
        ret = !patchStorage.exists() ? GISystemCall.process("mkdir -p -m  " + permission + " " + patchStorage.getAbsolutePath(), fileOwner, credential) : GISystemCall.process("chmod " + permission + " " + patchStorage.getAbsolutePath(), fileOwner, credential);
        if (!ret.isOK()) {
            _log.log(Level.WARNING, ret.getErrorMessage());
        }
    }

    public static boolean writeContentToFile(String filePath, String fileOwner, Credential credential, String content) throws IOException {
        return DBPatchingUtil.writeContentToFile(filePath, fileOwner, credential, content, false, false);
    }

    public static boolean writeContentToFile(String filePath, String fileOwner, Credential credential, String content, boolean append, boolean newLine) throws IOException {
        boolean createFile = DBPatchingUtil.createNewFile(filePath, fileOwner, credential);
        if (createFile) {
            createFile = false;
            DBPatchingUtil.writeContent(new File(filePath), content, append, newLine);
            createFile = true;
        }
        return createFile;
    }

    public static void writeContent(File file, String content, boolean append, boolean newLine) throws IOException {
        BufferedWriter output = new BufferedWriter(new FileWriter(file, append));
        if (newLine) {
            output.newLine();
        }
        output.write(content);
        output.close();
    }

    public static boolean mkdirs(String dirPath, String fileOwner, Credential credential) {
        if (new File(dirPath).exists()) {
            return true;
        }
        String mkdirCmd = "mkdir -p  -m 775 " + dirPath;
        GISystemCall.ExecReturn er = GISystemCall.process(mkdirCmd, fileOwner, credential);
        if (!er.isOK()) {
            _log.log(Level.WARNING, er.getErrorMessage());
        }
        return er.isOK();
    }

    public static boolean isDatabaseUp(String oracleHomePath, String username, byte[] password, String nodeName) {
        boolean isUp = false;
        String stfile = (oracleHomePath = PatchPlanUtils.removeFileSeperatorAtEnd(oracleHomePath)) + File.separator + DBCommonPatchingConstants.HOME_STATUS_FILE;
        File statf = new File(stfile);
        if (statf.exists()) {
            statf.delete();
        }
        String srvctlCmd = oracleHomePath + File.separator + DBCommonPatchingConstants.HOME_STATUS_COMMAND;
        srvctlCmd = nodeName != null && !nodeName.equals("") ? srvctlCmd + " -o " + oracleHomePath + " -s " + stfile + " -n " + nodeName : srvctlCmd + " -o " + oracleHomePath + " -s " + stfile;
        String env = "ORACLE_HOME=" + oracleHomePath;
        srvctlCmd = env + " " + srvctlCmd;
        GISystemCall.ExecReturn rt = GISystemCall.process(GISystemCall.formatSHCommand(srvctlCmd, true), username, password);
        if (rt.isOK() && !rt.getNormalMessage().equals("")) {
            isUp = true;
        }
        _log.info("Is database up in " + oracleHomePath + ", Node=" + nodeName + "=" + isUp);
        return isUp;
    }

    public static boolean isDBUpOnSIHA(String oracleHome, String dbname, String user, PatchTarget patchTarget, String version) {
        boolean up = false;
        StringBuffer command = new StringBuffer("");
        command.append("ORACLE_HOME=").append(oracleHome);
        command.append(" ").append(oracleHome);
        command.append(File.separator).append(DBCommonPatchingConstants.DATABASE_STATUS_COMMAND);
        if (version == null || DBPatchingUtil.isDBVersionTweleveOrLater(version)) {
            command.append(" -db ").append(dbname);
        } else {
            command.append(" -d ").append(dbname);
        }
        GISystemCall.ExecReturn rt = GISystemCall.process(GISystemCall.formatSHCommand(command.toString(), true), user, patchTarget.getHost().getPassword());
        if (rt.isOK()) {
            int index = rt.getNormalMessage().indexOf("is running");
            if (index > 0) {
                up = true;
            }
        } else if (null != rt.getErrorMessage() && rt.getErrorMessage().length() != 0) {
            _log.log(Level.WARNING, "ERROR : " + rt.getErrorMessage());
        } else {
            _log.log(Level.WARNING, "ERROR : " + rt.getNormalMessage());
        }
        _log.info("SIDB " + dbname + " status=" + up);
        return up;
    }

    public static boolean isRACOneDBUp(String oracleHome, String dbname, String nodename, String user, PatchTarget patchTarget, String version) {
        boolean up = false;
        StringBuffer command = new StringBuffer("");
        command.append("ORACLE_HOME=").append(oracleHome);
        command.append(" ").append(oracleHome);
        command.append(File.separator).append(DBCommonPatchingConstants.DATABASE_STATUS_COMMAND);
        if (version == null || DBPatchingUtil.isDBVersionTweleveOrLater(version)) {
            command.append(" -db ").append(dbname);
        } else {
            command.append(" -d ").append(dbname);
        }
        GISystemCall.ExecReturn rt = GISystemCall.process(GISystemCall.formatSHCommand(command.toString(), true), user, patchTarget.getHost().getPassword());
        if (rt.isOK()) {
            int index = rt.getNormalMessage().indexOf("is running");
            int indexnode = rt.getNormalMessage().indexOf(nodename);
            if (index > 0 && indexnode > 0) {
                up = true;
            }
        } else if (null != rt.getErrorMessage() && rt.getErrorMessage().length() != 0) {
            _log.log(Level.WARNING, "ERROR : " + rt.getErrorMessage());
        } else {
            _log.log(Level.WARNING, "ERROR : " + rt.getNormalMessage());
        }
        _log.info("RACOne DB " + dbname + " status=" + up);
        return up;
    }

    public static String getSIDBNameFromInstancename(String instancename, PatchTarget target) {
        String dbName = null;
        SystemInstance instance = PatchPlanner.getInstance().getConfigGraph().getSystemInstance();
        for (BaseClass b : instance.getEntities()) {
            if (!(b instanceof SIDatabase)) continue;
            SIDatabase sidb = (SIDatabase)b;
            if (!target.getHost().getHost().equalsIgnoreCase(sidb.getHost().getHostName()) || !target.getHome(true).getLocation().equals(sidb.getRuns_from().getPath())) continue;
            dbName = sidb.getDatabaseName();
            _log.info("SIDB name: " + dbName);
        }
        _log.info("SIDB name is " + dbName);
        return dbName;
    }

    public static String getSIDBInstancename(PatchTarget target) {
        String instName = null;
        SystemInstance instance = PatchPlanner.getInstance().getConfigGraph().getSystemInstance();
        for (BaseClass b : instance.getEntities()) {
            if (!(b instanceof SIDatabase)) continue;
            SIDatabase sidb = (SIDatabase)b;
            if (!target.getHost().getHost().equalsIgnoreCase(sidb.getHost().getHostName()) || !target.getHome(true).getLocation().equals(sidb.getRuns_from().getPath())) continue;
            instName = sidb.getInstanceName();
        }
        _log.info("SIDB instance name is " + instName);
        return instName;
    }

    public static String getRACDBNameFromInstancename(String instancename, PatchTarget target) {
        String dbName = null;
        SystemInstance instance = PatchPlanner.getInstance().getConfigGraph().getSystemInstance();
        for (BaseClass b : instance.getEntities()) {
            if (!(b instanceof RACDatabase)) continue;
            RACDatabase racDB = (RACDatabase)b;
            List insts = racDB.getDbInstances();
            for (RACDBInstance inst : insts) {
                if (!target.getHost().getHost().equalsIgnoreCase(inst.getHost().getHostName()) || !inst.getInstanceName().equals(instancename)) continue;
                dbName = inst.getDbRAC().getDatabaseName();
            }
        }
        _log.info("RAC DB name is " + dbName);
        return dbName;
    }

    public static boolean isRACOneDB(String dbname) {
        boolean isRACOneDB = false;
        SystemInstance si = PatchPlanner.getInstance().getConfigGraph().getSystemInstance();
        for (BaseClass b : si.getEntities()) {
            RACDatabase rdb;
            if (!(b instanceof RACDatabase) || !(rdb = (RACDatabase)b).getDatabaseName().equals(dbname) || !"racone".equals(rdb.getDatabaseType())) continue;
            isRACOneDB = true;
            break;
        }
        _log.info("Is rac one DB=" + isRACOneDB);
        return isRACOneDB;
    }

    public static boolean isDBInstanceUp(String oracleHome, String dbname, String nodename, String user, PatchTarget patchTarget, String version) {
        boolean up = false;
        StringBuffer command = new StringBuffer("");
        command.append("ORACLE_HOME=").append(oracleHome);
        command.append(" ").append(oracleHome);
        command.append(File.separator).append(DBCommonPatchingConstants.INSTANCE_STATUS_COMMAND);
        if (version == null || DBPatchingUtil.isDBVersionTweleveOrLater(version)) {
            command.append(" -db ").append(dbname);
            command.append(" -node ").append(nodename);
        } else {
            command.append(" -d ").append(dbname);
            command.append(" -n ").append(nodename);
        }
        GISystemCall.ExecReturn rt = GISystemCall.process(GISystemCall.formatSHCommand(command.toString(), true), user, patchTarget.getHost().getPassword());
        if (rt.isOK()) {
            int index = rt.getNormalMessage().indexOf("not running");
            if (index < 0) {
                up = true;
            }
        } else if (null != rt.getErrorMessage() && rt.getErrorMessage().length() != 0) {
            _log.log(Level.WARNING, "ERROR : " + rt.getErrorMessage());
        } else {
            _log.log(Level.WARNING, "ERROR : " + rt.getNormalMessage());
        }
        _log.info("RAC DB " + dbname + " status=" + up);
        return up;
    }

    public static String getInstNameUsingCommand(String command) {
        int start = command.indexOf("ORACLE_SID");
        int end = 0;
        String instName = null;
        if (start > 0) {
            end = command.indexOf(" ", start + 11);
            instName = command.substring(start + 11, end);
        }
        return instName;
    }

    public static String getDbNameUsingInstName(HashMap<String, String> localNodeInstancesMap, String instName) {
        String dbname = "";
        if (localNodeInstancesMap != null) {
            Set<Map.Entry<String, String>> set = localNodeInstancesMap.entrySet();
            for (Map.Entry<String, String> me : set) {
                if (me == null || me.getValue() == null || !me.getValue().equals(instName)) continue;
                dbname = me.getKey();
                break;
            }
        }
        _log.info("DB name using instance name is =" + dbname);
        return dbname;
    }

    public static boolean isAIXPlatform() {
        String osname = DBPatchingUtil.getOsName();
        return osname.equalsIgnoreCase("AIX");
    }

    public static String getOsName() {
        return System.getProperty("os.name", "");
    }

    public static boolean rsyncFound(GISystemCall.ExecReturn ret) {
        String osname = DBPatchingUtil.getOsName();
        if (!ret.isOK()) {
            _log.info("Unable to check rysnc version.");
            return false;
        }
        String output = ret.getNormalMessage();
        String error = ret.getErrorMessage();
        _log.info("Output of 'rsync --version' commmand is :\n" + output);
        _log.info("Error message is : " + error);
        if (StringUtil.isNullOrEmpty((String)output, (boolean)true)) {
            _log.info("No rsync found.");
            return false;
        }
        return true;
    }

    public static String getLibPathEnv(String home) {
        String ld_lib_path = "";
        String current_path = "";
        if (DBPatchingUtil.isAIXPlatform()) {
            current_path = OUIDriver.getEnv((String)"LIBPATH");
            _log.info("Current LIBPATH is " + current_path);
            ld_lib_path = "LIBPATH=" + home + "/lib:" + home + "/srvm/lib:" + current_path;
        } else {
            current_path = OUIDriver.getEnv((String)"LD_LIBRARY_PATH");
            _log.info("Current LD_LIBRARY_PATH is " + current_path);
            ld_lib_path = "LD_LIBRARY_PATH=" + home + "/lib:" + home + "/srvm/lib:" + current_path;
        }
        return ld_lib_path;
    }

    public static boolean isVersionEqalOrlater(String versionToCompare, String baseVersion) {
        OiiiVersion baseVersionObj = new OiiiVersion(baseVersion);
        OiiiVersion versionToCompareObj = new OiiiVersion(versionToCompare);
        _log.finest("Comparing version " + versionToCompare + " with base version " + baseVersion);
        return versionToCompareObj.equals(baseVersionObj) || versionToCompareObj.laterThan(baseVersionObj);
    }

    public static boolean isDBVersionTweleveOrLater(String primarypatchVersion) {
        return DBPatchingUtil.isVersionEqalOrlater(primarypatchVersion, "12.1");
    }

    public static boolean isDBVersionEleven(String primarypatchVersion) {
        return primarypatchVersion.startsWith("11.2.0.2") || primarypatchVersion.startsWith("11.2.0.3") || primarypatchVersion.startsWith("11.2.0.4");
    }

    public static HashMap<String, String> getDatabaseNames() {
        HashMap<String, String> map = new HashMap<String, String>();
        String oratabLoc = DBPatchingUtil.getOratabLocation();
        if (oratabLoc.equals("n/a") || !new File(oratabLoc).exists()) {
            return map;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(new File(oratabLoc))));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] nameline;
                if (line.trim().equals("") || line.startsWith("#") || line.startsWith("+") || (nameline = line.split(":")).length <= 2) continue;
                map.put(nameline[0], FileUtils.getFile((String)nameline[1]).getPath());
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            _log.severe("File \"" + oratabLoc + "\" does not exist. Error msg=" + e.getMessage());
        }
        catch (IOException e) {
            _log.severe("Exception in reading oratab file. Error msg=" + e.getMessage());
        }
        return map;
    }

    public static String getOratabLocation() {
        String osname;
        String oratab = "";
        oratab = ComdevHelper.isWindows() ? "n/a" : ((osname = DBPatchingUtil.getOsName()).equalsIgnoreCase("Linux") || osname.equalsIgnoreCase("AIX") ? "/etc/oratab" : (osname.equalsIgnoreCase("HP-UX") || osname.equalsIgnoreCase("SunOS") ? "/var/opt/oracle/oratab" : "n/a"));
        return oratab;
    }

    public static String getUpdatePatchLocation(String ohOwner, String homeLocation, Credential credential) throws OPatchAutoException {
        String zipPatchLocation = System.getProperty(DBProductParameterConstants.PATCH_ZIP_FILE_LOC.getValue());
        File zipFile = new File(zipPatchLocation);
        String folderName = zipFile.getName().split("\\.")[0];
        File patchLocationParentFile = new File(homeLocation + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP);
        File patchLocationFile = new File(patchLocationParentFile.getAbsolutePath() + File.separator + folderName + File.separator);
        String currentUser = System.getProperty("user.name");
        boolean updatePatchLoc = false;
        if (!currentUser.equals(ohOwner)) {
            if (!patchLocationParentFile.exists()) {
                boolean ret = DBPatchingUtil.mkdirs(patchLocationParentFile.getAbsolutePath(), ohOwner, credential);
                if (!ret) {
                    throw new OPatchAutoException("Failed to create directory." + patchLocationParentFile.getAbsolutePath(), new Object[0]);
                }
                patchLocationParentFile.deleteOnExit();
            }
            if (!patchLocationFile.exists()) {
                String perlPath = homeLocation + File.separator + "perl" + File.separator + "bin" + File.separator + "perl";
                String scriptPath = homeLocation + File.separator + "OPatch/auto/database/bin/ZipUnzip.pl unzip ";
                String command = perlPath + " " + scriptPath + zipPatchLocation + " " + patchLocationParentFile.getAbsolutePath();
                GISystemCall.ExecReturn ret = GISystemCall.process(command, ohOwner, credential);
                if (!ret.isOK()) {
                    throw new OPatchAutoException("Failed to unzip files on path." + patchLocationFile.getAbsolutePath() + "Error::" + ret.getErrorMessage(), new Object[0]);
                }
            }
            updatePatchLoc = true;
        }
        String patchLoc = updatePatchLoc ? patchLocationFile.getAbsolutePath() : null;
        return patchLoc;
    }

    public static boolean unzip(String oracleHomeLoc, String zipFilePath, String destLoc, String ohOwner, Credential credential) throws OPatchAutoException {
        String perlPath = oracleHomeLoc + File.separator + "perl" + File.separator + "bin" + File.separator + "perl";
        String scriptPath = oracleHomeLoc + File.separator + "OPatch/auto/database/bin/ZipUnzip.pl unzip ";
        String command = perlPath + " " + scriptPath + zipFilePath + " " + destLoc;
        GISystemCall.ExecReturn ret = GISystemCall.process(command, ohOwner, credential);
        if (!ret.isOK()) {
            throw new OPatchAutoException("Failed to unzip files on path." + destLoc, new Object[0]);
        }
        return ret.isOK();
    }

    public static String getPatchStorageDirectoryPath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(DBPatchingUtil.getPatchStorageName());
        return buff.toString();
    }

    public static String getPatchStorageName() {
        return PATCH_STORAGE_DIRECTORY;
    }

    public static String getOLRLocation() {
        String osname;
        String olrLoc = "";
        olrLoc = ComdevHelper.isWindows() ? "n/a" : ((osname = DBPatchingUtil.getOsName()).equalsIgnoreCase("Linux") || osname.equalsIgnoreCase("AIX") ? "/etc/oracle/olr.loc" : (osname.equalsIgnoreCase("HP-UX") || osname.equalsIgnoreCase("SunOS") ? "/var/opt/oracle/olr.loc" : "n/a"));
        return olrLoc;
    }

    public static boolean isClusterwareUp(String oracleHomePath, String nodeName) {
        boolean isUp = false;
        String crsCmd = oracleHomePath + File.separator + DBCommonPatchingConstants.CRS_STACK_CHECK_COMMAND;
        if (nodeName != null) {
            crsCmd = crsCmd + " -n " + nodeName;
        }
        byte[] pwd = null;
        GISystemCall.ExecReturn rt = GISystemCall.process(crsCmd, System.getProperty("user.name"), pwd);
        if (rt.isOK()) {
            String msg = rt.getNormalMessage();
            boolean all = true;
            for (int i = 0; i < DBCommonPatchingConstants.CRS_STACK_UP_MSGS.length; ++i) {
                if (msg.contains(DBCommonPatchingConstants.CRS_STACK_UP_MSGS[i])) continue;
                all = false;
            }
            if (all) {
                isUp = true;
            }
        }
        return isUp;
    }

    public static String getCopyCmd(File source) {
        if (source.isDirectory()) {
            return "cp -rf ";
        }
        return "cp ";
    }

    public static boolean copyFileToDestLoc(File file, String destFilePath, String fileOwner, Credential credential, boolean replaceExistingFile) throws OPatchAutoException {
        String copyCmd;
        GISystemCall.ExecReturn er;
        String destFileName = destFilePath + file.getName();
        if (new File(destFileName).exists()) {
            if (!replaceExistingFile) {
                return true;
            }
            new File(destFileName).delete();
        }
        if (!(er = GISystemCall.process(copyCmd = DBPatchingUtil.getCopyCmd(file) + file.getAbsolutePath() + " " + destFilePath, fileOwner, credential)).isOK()) {
            _log.log(Level.WARNING, er.getErrorMessage());
        }
        return er.isOK();
    }

    public static boolean isCrsHome(Home home) {
        boolean isCrsHome = false;
        Set productTypes = home.getProductTypes();
        for (ProductType productType : productTypes) {
            String type = productType.getType();
            _log.info("type: " + type);
            if (!type.equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue())) continue;
            isCrsHome = true;
            break;
        }
        _log.info("isCrsPatchingRequested: " + isCrsHome);
        return isCrsHome;
    }

    public static boolean isSIHAHome(Home home) {
        boolean isSihaHome = false;
        Set productTypes = home.getProductTypes();
        for (ProductType productType : productTypes) {
            String type = productType.getType();
            _log.info("type: " + type);
            if (!type.equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue())) continue;
            isSihaHome = true;
            break;
        }
        _log.info("isSIHAPatchingRequested: " + isSihaHome);
        return isSihaHome;
    }

    public static HashMap<String, String> getDatabaseNameLocs() {
        HashMap<String, String> dBnameLocs = new HashMap();
        try {
            Map databases = DatabaseFactory.getInstance().getDatabaseInfos();
            if (databases == null || databases.isEmpty()) {
                dBnameLocs = DBPatchingUtil.getDatabaseNames();
            } else {
                for (Map.Entry entry : databases.entrySet()) {
                    dBnameLocs.put((String)entry.getKey(), FileUtils.getFile((String)((String)((LinkedList)entry.getValue()).get(0))).getPath());
                }
            }
        }
        catch (SoftwareModuleException e) {
            _log.log(Level.SEVERE, "Exception in reading Database details from DatabaseFactory :" + e.getMessage() + "\n Hence Reading from Oratab");
            dBnameLocs = DBPatchingUtil.getDatabaseNames();
        }
        return dBnameLocs;
    }

    public static String getSubCloneHomeDir(String original_path, Set<String> homePaths) throws OPatchAutoException {
        return DBPatchingUtil.getSubCloneHomeDir(original_path, homePaths, new HashSet<String>());
    }

    public static String getSubCloneHomeDir(String original_path, Set<String> homePaths, Set<String> skipPaths) throws OPatchAutoException {
        int MAX_NO_OF_ITERATIONS = 15;
        Pattern p = Pattern.compile("(.*?)(?:_(\\d+))?");
        Matcher m = p.matcher(original_path);
        if (!m.matches()) {
            throw new OPatchAutoException("subCloneHomePath pattern doesn't match", new Object[0]);
        }
        String constant = m.group(1);
        String variable = m.group(2);
        int v = 1;
        if (variable != null && variable.length() != 0) {
            v = Integer.parseInt(variable);
        }
        int no_of_iterations = 0;
        String next_path = null;
        while (no_of_iterations <= 15) {
            String path = constant + "_" + String.valueOf(v + 1);
            if (homePaths.contains(path) || skipPaths.contains(path)) {
                ++v;
                continue;
            }
            File cloneDir = new File(path);
            if (cloneDir.exists()) {
                ++no_of_iterations;
                ++v;
                continue;
            }
            next_path = path;
            break;
        }
        if (next_path == null) {
            _log.log(Level.INFO, "Finished iterating but couldn't find a unique clone path. Creating path with original path with the current timestamp.");
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            next_path = original_path + "_" + ts.toString();
        }
        homePaths.add(next_path);
        return next_path;
    }

    public static String getSubCloneHomeName(String original_name, Set<String> homeNames) throws OPatchAutoException {
        Pattern p = Pattern.compile("(.*?)(?:_(\\d+))?");
        Matcher m = p.matcher(original_name);
        if (!m.matches()) {
            throw new OPatchAutoException("subCloneHomeName pattern doesn't match", new Object[0]);
        }
        String constant = m.group(1);
        String variable = m.group(2);
        int v = 1;
        if (variable != null && variable.length() != 0) {
            v = Integer.parseInt(variable);
        }
        while (true) {
            String next_name;
            if (!homeNames.contains(next_name = constant + "_" + String.valueOf(v + 1))) {
                homeNames.add(next_name);
                return next_name;
            }
            ++v;
        }
    }

    public static boolean canIncludeTargetByVersion(ConfigGraph g, AbstractBaseTarget abt, String version) {
        boolean includeTarget = true;
        _log.info("Supplied version::" + version);
        if (version != null) {
            AbstractBaseTarget siha;
            OracleHome oh = (OracleHome)abt;
            _log.info("Home Type::" + oh.getHomeType());
            if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString().equals(oh.getHomeType())) {
                AbstractBaseTarget crs = g.getRootVertex();
                if (crs != null && !DBPatchingUtil.formattedVersion(version).equals(DBPatchingUtil.formattedVersion(crs.getVersion()))) {
                    includeTarget = false;
                }
            } else if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString().equals(oh.getHomeType())) {
                List<RACDBInstance> racInst = g.getConnectedTargets((AbstractBaseTarget)oh, RACDBInstance.class);
                String racVersion = null;
                if (racInst != null && racInst.size() > 0) {
                    racVersion = new OiiiVersion(racInst.get(0).getVersion()).getVerString();
                } else if ((OUIComponent)oh.getTopLevelOUI().get(0) != null) {
                    racVersion = new OiiiVersion(((OUIComponent)oh.getTopLevelOUI().get(0)).getVersion()).getVerString();
                }
                if (!DBPatchingUtil.formattedVersion(version).equals(DBPatchingUtil.formattedVersion(racVersion))) {
                    includeTarget = false;
                }
            } else if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.sidb.toString().equals(oh.getHomeType())) {
                List<SIDatabase> sidb = g.getConnectedTargets((AbstractBaseTarget)oh, SIDatabase.class);
                if (sidb != null && sidb.size() != 0 && !DBPatchingUtil.formattedVersion(version).equals(DBPatchingUtil.formattedVersion(sidb.get(0).getVersion()))) {
                    includeTarget = false;
                }
            } else if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.siha.toString().equals(oh.getHomeType()) && (siha = g.getRootVertex()) != null && !DBPatchingUtil.formattedVersion(version).equals(DBPatchingUtil.formattedVersion(siha.getVersion()))) {
                includeTarget = false;
            }
        }
        _log.info("Include target::" + includeTarget);
        return includeTarget;
    }

    public static String formattedVersion(String version) {
        String formattedVersion = version;
        if (formattedVersion != null && formattedVersion.split("\\.").length == 5) {
            int index = version.lastIndexOf(".");
            formattedVersion = version.substring(0, index);
        }
        _log.info("Formatted Version::" + formattedVersion);
        return formattedVersion;
    }

    public static boolean enableSRVMTrace(String logFileName) {
        boolean enableSRVMTrace = false;
        if (_log.isLoggable(Level.FINEST)) {
            Trace.traceEnabled((boolean)true);
            Trace.setTraceLevel((int)5);
            enableSRVMTrace = Trace.configure((boolean)false, (boolean)false, (boolean)true, (boolean)true, (String)logFileName, (boolean)true, (boolean)true);
            Trace.enableLogging((String)logFileName, (boolean)true);
            _log.finest("Loggin srvm traces at: " + logFileName);
        }
        return enableSRVMTrace;
    }

    public static String getPerlExecutablePath() {
        return System.getenv("OPATCHAUTO_PERL_PATH");
    }

    public static ArrayList<String> getRemoteNodesForHome(String home) {
        ArrayList<Object> remoteNodes = new ArrayList();
        _log.fine("Reading remote nodes from the file.");
        try {
            remoteNodes = new ArrayList<String>(SessionData.getInstance().getHostPatchDataMap(home).keySet());
            if (!(remoteNodes != null && remoteNodes.size() != 0 || SessionData.getInstance().isLocalCRSUp())) {
                String crsHome = ClusterInformationLoader.getInstance().getGridHome();
                remoteNodes = RemoteNodes.getSerializedInstance((String)crsHome).getRemoteNodes();
            }
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
        return remoteNodes;
    }

    public static void editModeInfo(String oracleHome, String line) throws IOException {
        _log.info("Editing mode info.");
        String modeInfo = oracleHome + File.separator + ".opatchauto_storage" + File.separator + "mode_info";
        File file = new File(modeInfo);
        if (!file.exists()) {
            _log.info("Creating mode info file.");
            file.createNewFile();
            try {
                DBPatchingHelper.changeOwner(oracleHome, null, file);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Path path = Paths.get(modeInfo, new String[0]);
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(path), charset);
        content = line + content;
        Files.write(path, content.getBytes(charset), new OpenOption[0]);
        _log.info("Successfully updated mode info.");
    }

    public static ArrayList<ExecutionCommand> getModeInfoFromRemotesCmds(String home, String owner) {
        ArrayList<String> hosts = DBPatchingUtil.getRemoteNodesForHome(home);
        ArrayList<ExecutionCommand> remoteCopyCmds = new ArrayList<ExecutionCommand>();
        for (String host : hosts) {
            String source = home + File.separator + ".opatchauto_storage" + File.separator + "mode_info";
            String dst = source + "_" + host;
            String scpCmd = "scp " + owner + "@" + host + ":" + source + " " + dst;
            _log.info("Remote command to copy mode info: " + scpCmd);
            ExecutionCommand e = new ExecutionCommand(host, scpCmd);
            remoteCopyCmds.add(e);
        }
        return remoteCopyCmds;
    }

    public static ArrayList<ExecutionCommand> putModeInfoToRemotesCmds(String home, String owner) {
        ArrayList<String> hosts = DBPatchingUtil.getRemoteNodesForHome(home);
        ArrayList<ExecutionCommand> remotePutCmds = new ArrayList<ExecutionCommand>();
        for (String host : hosts) {
            String dst = home + File.separator + ".opatchauto_storage" + File.separator + "mode_info";
            String source = dst + "_" + host;
            String scpCmd = "scp " + source + " " + owner + "@" + host + ":" + dst;
            _log.info("Remote command to push mode info: " + scpCmd);
            ExecutionCommand e = new ExecutionCommand(host, scpCmd);
            remotePutCmds.add(e);
        }
        return remotePutCmds;
    }

    public static ArrayList<ExecutionCommand> deleteRemotesCmds(String home, String owner) {
        ArrayList<String> hosts = DBPatchingUtil.getRemoteNodesForHome(home);
        ArrayList<ExecutionCommand> remoteDelCmds = new ArrayList<ExecutionCommand>();
        for (String host : hosts) {
            StringBuilder remoteCommand = new StringBuilder();
            remoteCommand.append("ssh " + owner + "@" + host + " \"");
            remoteCommand.append("rm ");
            remoteCommand.append(home + File.separator + ".opatchauto_storage");
            remoteCommand.append(File.separator + "mode_info");
            remoteCommand.append("\"");
            _log.info("Remote command to delete mode info: " + remoteCommand.toString());
            ExecutionCommand e = new ExecutionCommand(host, remoteCommand.toString());
            remoteDelCmds.add(e);
        }
        return remoteDelCmds;
    }

    public static void cleanRemoteNodePatchEntries(String home, String owner, List<String> lastNodeEntries) throws IOException {
        ArrayList<ExecutionCommand> remoteCopyCmds = DBPatchingUtil.getModeInfoFromRemotesCmds(home, owner);
        ParallelExecution pe1 = new ParallelExecution(remoteCopyCmds, owner);
        pe1.execute();
        for (CommandExecutionThread commandExecutionThread : pe1.getResults()) {
            GISystemCall.ExecReturn er = commandExecutionThread.er;
            int exit_code = er.getReturnCode();
            if (exit_code == 0) continue;
            _log.info("Unable to copy mode_info from remote host " + commandExecutionThread.host);
        }
        ArrayList<String> hosts = DBPatchingUtil.getRemoteNodesForHome(home);
        for (String host : hosts) {
            String source = home + File.separator + ".opatchauto_storage" + File.separator + "mode_info" + "_" + host;
            File file = new File(source);
            if (!file.exists()) continue;
            Path path = Paths.get(source, new String[0]);
            Charset charset = StandardCharsets.UTF_8;
            List<String> lines = Files.readAllLines(path, charset);
            StringBuffer edited_lines = new StringBuffer();
            for (String line : lines) {
                boolean matches = false;
                for (String lastNode : lastNodeEntries) {
                    if (!line.equals(lastNode)) continue;
                    matches = true;
                    break;
                }
                if (matches || StringUtil.isNullOrEmpty((String)line)) continue;
                edited_lines.append(line + System.lineSeparator());
            }
            String new_content = edited_lines.toString();
            Files.write(path, new_content.getBytes(charset), new OpenOption[0]);
        }
        ArrayList<ExecutionCommand> arrayList = DBPatchingUtil.deleteRemotesCmds(home, owner);
        ParallelExecution pe2 = new ParallelExecution(arrayList, owner);
        pe2.execute();
        for (CommandExecutionThread cet : pe2.getResults()) {
            GISystemCall.ExecReturn er = cet.er;
            int exit_code = er.getReturnCode();
            if (exit_code == 0) continue;
            _log.info("Unable to delete mode_info on remote host " + cet.host);
        }
        ArrayList<ExecutionCommand> remotePutCmds = DBPatchingUtil.putModeInfoToRemotesCmds(home, owner);
        ParallelExecution pe3 = new ParallelExecution(remotePutCmds, owner);
        pe3.execute();
        for (CommandExecutionThread cet : pe3.getResults()) {
            GISystemCall.ExecReturn er = cet.er;
            int exit_code = er.getReturnCode();
            if (exit_code == 0) continue;
            _log.info("Unable to copy mode_info to remote host " + cet.host);
        }
    }
}

