/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.assembler;

import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.assembler.IPatchTargetAssembler;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.ShardGroup;
import java.util.List;
import java.util.logging.Logger;

public class ShardGroupAssembler
implements IPatchTargetAssembler {
    Logger logger = Logger.getLogger(ShardGroupAssembler.class.getName());
    private List<ShardGroup> shardGroups = null;

    public ShardGroupAssembler(List<ShardGroup> shardGroups) {
        this.shardGroups = shardGroups;
    }

    @Override
    public boolean isShardRequired(AbstractBaseTarget shard, SystemInstance systemInstance, String option) {
        this.logger.fine(" shardGroupOption :: " + option);
        if (this.shardGroups == null) {
            this.shardGroups = systemInstance.getTargetsOfType(ShardGroup.class);
        }
        for (ShardGroup shardGrp : this.shardGroups) {
            if (!option.equals(shardGrp.getShardGroupName())) continue;
            if (shard instanceof CRSCluster || shard instanceof HAS) {
                this.logger.fine(shard + " an instance of " + (shard instanceof CRSCluster ? "CRSCluster" : "HAS") + " is required");
                return true;
            }
            for (AbstractBaseTarget abt : shardGrp.getDatabases()) {
                this.logger.fine("Comparing abt name " + abt.getName() + " and shard name " + shard.getName());
                if (!shard.getName().equalsIgnoreCase(abt.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

